/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.elasticsearch;

import com.van.logging.Event;
import com.van.logging.PublishContext;
import com.van.logging.VansLogger;
import com.van.logging.elasticsearch.ElasticsearchConfiguration;
import com.van.logging.elasticsearch.IElasticsearchPublishHelper;
import com.van.logging.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Date;
import org.apache.http.HttpHost;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class ElasticsearchPublishHelper
implements IElasticsearchPublishHelper {
    private ElasticsearchConfiguration configuration;
    private HttpHost[] httpHosts;
    private RestHighLevelClient client;
    private BulkRequest bulkRequest;
    private int offset;
    private Date timeStamp;

    @Override
    public void initialize(ElasticsearchConfiguration configuration) {
        this.configuration = configuration;
        this.httpHosts = (HttpHost[])this.configuration.getHttpHosts().toArray(HttpHost[]::new);
    }

    @Override
    public void start(PublishContext context) {
        this.offset = 0;
        this.timeStamp = new Date();
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.httpHosts);
        this.client = new RestHighLevelClient(builder);
        this.bulkRequest = new BulkRequest();
    }

    @Override
    public void publish(PublishContext context, int sequence, Event event) {
        try {
            String id = String.format("%s-%s-%016d", context.getCacheName(), context.getHostName(), this.offset);
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder().startObject().field("timestamp", (Object)this.timeStamp).field("type", event.getType()).field("hostname", context.getHostName()).field("offset", this.offset).field("thread_name", event.getThreadName()).field("logger", event.getSource()).field("message", event.getMessage()).array("tags", context.getTags()).endObject();
            this.bulkRequest.add(new IndexRequest(this.configuration.getIndex()).id(id).source(contentBuilder));
            ++this.offset;
        }
        catch (Exception ex) {
            VansLogger.logger.error("Cannot publish event", (Throwable)ex);
        }
    }

    @Override
    public void end(PublishContext context) {
        try {
            BulkResponse response;
            if (null != this.client && null != this.bulkRequest && (response = this.client.bulk(this.bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                VansLogger.logger.error("Elasticsearch publish failures: " + response.buildFailureMessage());
            }
        }
        catch (IOException ex) {
            VansLogger.logger.error("Cannot end publish batch", (Throwable)ex);
        }
        finally {
            try {
                if (null != this.client) {
                    this.client.close();
                }
                this.bulkRequest = null;
            }
            catch (IOException e) {
                VansLogger.logger.error("Error closing client", (Throwable)e);
            }
        }
    }

    public static IElasticsearchPublishHelper getPublishHelper(String publishHelperNameSpec, ClassLoader classLoader) {
        return ElasticsearchPublishHelper.getPublishHelper(publishHelperNameSpec, classLoader, false);
    }

    public static IElasticsearchPublishHelper getPublishHelper(String publishHelperNameSpec, ClassLoader classLoader, boolean verbose) {
        ElasticsearchPublishHelper helper = null;
        if (StringUtils.isTruthy(publishHelperNameSpec)) {
            VansLogger.logger.info(String.format("Instantiating %s", publishHelperNameSpec));
            try {
                Class<?> cls = classLoader.loadClass(publishHelperNameSpec);
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                helper = (ElasticsearchPublishHelper)ctor.newInstance(new Object[0]);
                if (verbose) {
                    VansLogger.logger.info(String.format("Successfully registered %s as Elasticsearch publish helper", publishHelperNameSpec));
                }
            }
            catch (Exception ex) {
                VansLogger.logger.error(String.format("Cannot set up %s", publishHelperNameSpec), (Throwable)ex);
            }
        }
        if (null == helper) {
            if (verbose) {
                VansLogger.logger.info("Instantiating the default ElasticsearchPublishHelper");
            }
            helper = new ElasticsearchPublishHelper();
        }
        return helper;
    }
}

