/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging;

import com.van.logging.Event;
import com.van.logging.IBufferPublisher;
import com.van.logging.IPublishHelper;
import com.van.logging.PublishContext;
import com.van.logging.VansLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class BufferPublisher
implements IBufferPublisher {
    private final String hostName;
    private final String[] tags;
    private List<IPublishHelper> helpers = new LinkedList<IPublishHelper>();

    public BufferPublisher(String hostName, String[] tags) {
        this.hostName = hostName;
        this.tags = tags;
    }

    @Override
    public PublishContext startPublish(String cacheName) {
        String namespacedCacheName = this.composeNamespacedCacheName(cacheName);
        if (VansLogger.logger.isDebugEnabled()) {
            VansLogger.logger.debug(String.format("BEGIN publishing %s...", namespacedCacheName));
        }
        PublishContext context = new PublishContext(namespacedCacheName, this.hostName, this.tags);
        for (IPublishHelper helper : this.helpers) {
            try {
                helper.start(context);
            }
            catch (Throwable t) {
                VansLogger.logger.error(String.format("Cannot start publish with %s due to error", helper), t);
            }
        }
        return context;
    }

    String composeNamespacedCacheName(String rawCacheName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return String.format("%s_%s_%s", df.format(new Date()), this.hostName, rawCacheName);
    }

    @Override
    public void publish(PublishContext context, int sequence, Event event) {
        for (IPublishHelper helper : this.helpers) {
            try {
                helper.publish(context, sequence, event);
            }
            catch (Throwable t) {
                VansLogger.logger.error(String.format("Cannot publish with %s due to error", helper), t);
            }
        }
    }

    @Override
    public void endPublish(PublishContext context) {
        for (IPublishHelper helper : this.helpers) {
            try {
                helper.end(context);
            }
            catch (Throwable t) {
                VansLogger.logger.error(String.format("Cannot end publish with %s due to error", helper), t);
            }
        }
        if (VansLogger.logger.isDebugEnabled()) {
            VansLogger.logger.debug(String.format("END publishing %s", context.getCacheName()));
        }
    }

    public void addHelper(IPublishHelper helper) {
        this.helpers.add(helper);
    }
}

