/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.solr;

import com.van.logging.Event;
import com.van.logging.IPublishHelper;
import com.van.logging.PublishContext;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrInputDocument;

public class SolrPublishHelper
implements IPublishHelper {
    private final SolrClient client;
    private int offset;
    private Date timeStamp;
    private List<SolrInputDocument> docs;

    public SolrPublishHelper(URL collectionUrl) {
        this.client = new HttpSolrClient.Builder().withBaseSolrUrl(collectionUrl.toExternalForm()).build();
    }

    @Override
    public void publish(PublishContext context, int sequence, Event event) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("id", (Object)String.format("%s-%s-%016d", context.getCacheName(), context.getHostName(), this.offset));
        doc.addField("timestamp", (Object)this.timeStamp);
        doc.addField("type", (Object)event.getType());
        doc.addField("hostname", (Object)context.getHostName());
        doc.addField("offset", (Object)this.offset);
        doc.addField("thread_name", (Object)event.getThreadName());
        doc.addField("logger", (Object)event.getSource());
        doc.addField("message", (Object)event.getMessage());
        if (context.getTags().length > 0) {
            for (String tag : context.getTags()) {
                doc.addField("tags", (Object)tag);
            }
        }
        this.docs.add(doc);
        ++this.offset;
    }

    @Override
    public void start(PublishContext context) {
        this.offset = 0;
        this.timeStamp = new Date();
        this.docs = new LinkedList<SolrInputDocument>();
    }

    @Override
    public void end(PublishContext context) {
        try {
            this.client.add(this.docs);
            this.client.commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot commit batch", e);
        }
    }
}

