/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.log4j2;

import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.van.logging.BufferPublisher;
import com.van.logging.CapacityBasedBufferMonitor;
import com.van.logging.Event;
import com.van.logging.IBufferMonitor;
import com.van.logging.IBufferPublisher;
import com.van.logging.IPublishHelper;
import com.van.logging.LoggingEventCache;
import com.van.logging.TimePeriodBasedBufferMonitor;
import com.van.logging.aws.AwsClientHelpers;
import com.van.logging.aws.S3Configuration;
import com.van.logging.aws.S3PublishHelper;
import com.van.logging.elasticsearch.ElasticsearchConfiguration;
import com.van.logging.elasticsearch.ElasticsearchPublishHelper;
import com.van.logging.log4j2.Log4j2Appender;
import com.van.logging.solr.SolrConfiguration;
import com.van.logging.solr.SolrPublishHelper;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.util.Builder;

public class Log4j2AppenderBuilder
extends AbstractAppender.Builder
implements Builder<Log4j2Appender> {
    @PluginBuilderAttribute
    private boolean verbose = false;
    @PluginBuilderAttribute
    private String tags;
    @PluginBuilderAttribute
    private int stagingBufferSize = 25;
    @PluginBuilderAttribute
    private int stagingBufferAge = 0;
    @PluginBuilderAttribute
    private String s3Bucket;
    @PluginBuilderAttribute
    private String s3Region;
    @PluginBuilderAttribute
    private String s3Path;
    @PluginBuilderAttribute
    private String s3AwsKey;
    @PluginBuilderAttribute
    private String s3AwsSecret;
    @PluginBuilderAttribute
    private String s3ServiceEndpoint;
    @PluginBuilderAttribute
    private String s3SigningRegion;
    @PluginBuilderAttribute
    private String s3Compression;
    @PluginBuilderAttribute
    private String s3SseKeyType;
    @PluginBuilderAttribute
    private String solrUrl;
    @PluginBuilderAttribute
    private String elasticsearchCluster;
    @PluginBuilderAttribute
    private String elasticsearchIndex;
    @PluginBuilderAttribute
    private String elasticsearchType;
    @PluginBuilderAttribute
    private String elasticsearchHosts;

    public Log4j2Appender build() {
        try {
            String cacheName = UUID.randomUUID().toString().replaceAll("-", "");
            LoggingEventCache cache = new LoggingEventCache(cacheName, this.createCacheMonitor(), this.createCachePublisher());
            return this.installFilter(new Log4j2Appender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)this.getLayout(), true, (LoggingEventCache<Event>)cache));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot build appender due to errors", e);
        }
    }

    Log4j2Appender installFilter(Log4j2Appender appender) {
        appender.addFilter((Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                Filter.Result decision = Filter.Result.NEUTRAL;
                if ("LoggingEventCache-publish-thread".equals(event.getThreadName())) {
                    decision = Filter.Result.DENY;
                }
                return decision;
            }
        });
        return appender;
    }

    Optional<AmazonS3> initS3ClientIfEnabled() {
        Optional<S3Configuration> s3 = Optional.empty();
        if (null != this.s3Bucket && null != this.s3Path) {
            S3Configuration config2 = new S3Configuration();
            config2.setBucket(this.s3Bucket);
            config2.setPath(this.s3Path);
            config2.setRegion(this.s3Region);
            config2.setAccessKey(this.s3AwsKey);
            config2.setSecretKey(this.s3AwsSecret);
            config2.setServiceEndpoint(this.s3ServiceEndpoint);
            config2.setSigningRegion(this.s3SigningRegion);
            s3 = Optional.of(config2);
        }
        return s3.map(config -> AwsClientHelpers.buildClient((String)config.getAccessKey(), (String)config.getSecretKey(), (Region)config.getRegion(), (String)config.getServiceEndpoint(), (String)config.getSigningRegion()));
    }

    static Optional<SolrConfiguration> getSolrConfigurationIfEnabled(String solrUrl) {
        SolrConfiguration config = null;
        if (null != solrUrl) {
            config = new SolrConfiguration();
            config.setUrl(solrUrl);
        }
        return Optional.ofNullable(config);
    }

    static Optional<ElasticsearchConfiguration> getElasticsearchConfigIfEnabled(String elasticsearchHosts) {
        ElasticsearchConfiguration config = null;
        if (null != elasticsearchHosts) {
            String[] hostArray;
            config = new ElasticsearchConfiguration();
            for (String entry : hostArray = elasticsearchHosts.split("[;\\s,]")) {
                config.addHost(entry);
            }
        }
        return Optional.ofNullable(config);
    }

    IBufferPublisher<Event> createCachePublisher() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        String hostName = addr.getHostName();
        BufferPublisher publisher = new BufferPublisher(hostName, this.parseTags(this.tags));
        this.initS3ClientIfEnabled().ifPresent(client -> {
            if (this.verbose) {
                System.out.println(String.format("Registering S3 publish helper -> %s:%s", this.s3Bucket, this.s3Path));
            }
            S3Configuration.S3SSEConfiguration sseConfig = null;
            if (this.s3SseKeyType != null) {
                sseConfig = new S3Configuration.S3SSEConfiguration(S3Configuration.SSEType.valueOf((String)this.s3SseKeyType), null);
            }
            publisher.addHelper((IPublishHelper)new S3PublishHelper((AmazonS3Client)client, this.s3Bucket, this.s3Path, Boolean.parseBoolean(this.s3Compression), sseConfig));
        });
        Log4j2AppenderBuilder.getSolrConfigurationIfEnabled(this.solrUrl).ifPresent(config -> {
            if (this.verbose) {
                System.out.println(String.format("Registering SOLR publish helper -> %s", config));
            }
            publisher.addHelper((IPublishHelper)new SolrPublishHelper(config.getUrl()));
        });
        Log4j2AppenderBuilder.getElasticsearchConfigIfEnabled(this.elasticsearchHosts).ifPresent(config -> {
            if (this.verbose) {
                System.out.println(String.format("Registering Elasticsearch publish helper -> %s", config));
            }
            publisher.addHelper((IPublishHelper)new ElasticsearchPublishHelper(config));
        });
        return publisher;
    }

    String[] parseTags(String tags) {
        Set<String> parsedTags = null;
        parsedTags = null != tags ? Stream.of(tags.split("[,;]")).filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet()) : Collections.emptySet();
        return parsedTags.toArray(new String[0]);
    }

    IBufferMonitor<Event> createCacheMonitor() {
        CapacityBasedBufferMonitor monitor = new CapacityBasedBufferMonitor(this.stagingBufferSize);
        if (0 < this.stagingBufferAge) {
            monitor = new TimePeriodBasedBufferMonitor(this.stagingBufferAge);
        }
        if (this.verbose) {
            System.out.println(String.format("Using cache monitor: %s", monitor.toString()));
        }
        return monitor;
    }
}

