/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.log4j2;

import com.van.logging.BufferPublisher;
import com.van.logging.CapacityBasedBufferMonitor;
import com.van.logging.Event;
import com.van.logging.IBufferMonitor;
import com.van.logging.IBufferPublisher;
import com.van.logging.IPublishHelper;
import com.van.logging.LoggingEventCache;
import com.van.logging.TimePeriodBasedBufferMonitor;
import com.van.logging.aws.S3Configuration;
import com.van.logging.aws.S3PublishHelper;
import com.van.logging.azure.BlobConfiguration;
import com.van.logging.azure.BlobPublishHelper;
import com.van.logging.elasticsearch.ElasticsearchConfiguration;
import com.van.logging.elasticsearch.ElasticsearchPublishHelper;
import com.van.logging.gcp.CloudStorageConfiguration;
import com.van.logging.gcp.CloudStoragePublishHelper;
import com.van.logging.log4j2.Log4j2Appender;
import com.van.logging.solr.SolrConfiguration;
import com.van.logging.solr.SolrPublishHelper;
import com.van.logging.utils.StringUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.util.Builder;

public class Log4j2AppenderBuilder
extends AbstractAppender.Builder
implements Builder<Log4j2Appender> {
    @PluginBuilderAttribute
    private boolean verbose = false;
    @PluginBuilderAttribute
    private String tags;
    @PluginBuilderAttribute
    private int stagingBufferSize = 25;
    @PluginBuilderAttribute
    private int stagingBufferAge = 0;
    @PluginBuilderAttribute
    private String s3Bucket;
    @PluginBuilderAttribute
    private String s3Region;
    @PluginBuilderAttribute
    private String s3Path;
    @PluginBuilderAttribute
    private String s3AwsKey;
    @PluginBuilderAttribute
    private String s3AwsSecret;
    @PluginBuilderAttribute
    private String s3AwsSessionToken = null;
    @PluginBuilderAttribute
    private String s3ServiceEndpoint;
    @PluginBuilderAttribute
    private String s3SigningRegion;
    @PluginBuilderAttribute
    private String s3Compression;
    @PluginBuilderAttribute
    private String s3SseKeyType;
    @PluginBuilderAttribute
    private String azureStorageConnectionString;
    @PluginBuilderAttribute
    private String azureBlobContainer;
    @PluginBuilderAttribute
    private String azureBlobNamePrefix;
    @PluginBuilderAttribute
    private String azureBlobCompressionEnabled;
    @PluginBuilderAttribute
    private String gcpStorageBucket;
    @PluginBuilderAttribute
    private String gcpStorageBlobNamePrefix;
    @PluginBuilderAttribute
    private String gcpStorageCompressionEnabled;
    @PluginBuilderAttribute
    private String solrUrl;
    @PluginBuilderAttribute
    private String elasticsearchCluster;
    @PluginBuilderAttribute
    private String elasticsearchIndex;
    @PluginBuilderAttribute
    private String elasticsearchType;
    @PluginBuilderAttribute
    private String elasticsearchHosts;

    public Log4j2Appender build() {
        try {
            String cacheName = UUID.randomUUID().toString().replaceAll("-", "");
            LoggingEventCache cache = new LoggingEventCache(cacheName, this.createCacheMonitor(), this.createCachePublisher());
            return this.installFilter(new Log4j2Appender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)this.getLayout(), true, (LoggingEventCache<Event>)cache));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot build appender due to errors", e);
        }
    }

    Log4j2Appender installFilter(Log4j2Appender appender) {
        appender.addFilter((Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                Filter.Result decision = Filter.Result.NEUTRAL;
                if ("LoggingEventCache-publish-thread".equals(event.getThreadName())) {
                    decision = Filter.Result.DENY;
                }
                return decision;
            }
        });
        return appender;
    }

    Optional<S3Configuration> getS3ConfigIfEnabled() {
        Optional<S3Configuration> s3Config = Optional.empty();
        if (StringUtils.isTruthy((String)this.s3Bucket) && StringUtils.isTruthy((String)this.s3Path)) {
            S3Configuration config = new S3Configuration();
            config.setBucket(this.s3Bucket);
            config.setPath(this.s3Path);
            config.setRegion(this.s3Region);
            config.setAccessKey(this.s3AwsKey);
            config.setSecretKey(this.s3AwsSecret);
            config.setSessionToken(this.s3AwsSessionToken);
            config.setServiceEndpoint(this.s3ServiceEndpoint);
            config.setSigningRegion(this.s3SigningRegion);
            S3Configuration.S3SSEConfiguration sseConfig = null;
            if (this.s3SseKeyType != null) {
                sseConfig = new S3Configuration.S3SSEConfiguration(S3Configuration.SSEType.valueOf((String)this.s3SseKeyType), null);
            }
            config.setSseConfiguration(sseConfig);
            s3Config = Optional.of(config);
        }
        return s3Config;
    }

    Optional<BlobConfiguration> getBlobConfigurationIfEnabled() {
        Optional<BlobConfiguration> blobConfiguration = Optional.empty();
        if (StringUtils.isTruthy((String)this.azureBlobContainer)) {
            BlobConfiguration config = new BlobConfiguration();
            config.setStorageConnectionString(this.azureStorageConnectionString);
            config.setContainerName(this.azureBlobContainer);
            if (null != this.azureBlobNamePrefix) {
                config.setBlobNamePrefix(this.azureBlobNamePrefix);
            }
            config.setCompressionEnabled(Boolean.parseBoolean(this.azureBlobCompressionEnabled));
            blobConfiguration = Optional.of(config);
        }
        return blobConfiguration;
    }

    Optional<CloudStorageConfiguration> getCloudStorageConfigurationIfEnabled() {
        Optional<CloudStorageConfiguration> cloudStorageConfiguration = Optional.empty();
        if (StringUtils.isTruthy((String)this.gcpStorageBucket)) {
            CloudStorageConfiguration config = new CloudStorageConfiguration();
            config.setBucketName(this.gcpStorageBucket);
            config.setBlobNamePrefix(this.gcpStorageBlobNamePrefix);
            config.setCompressionEnabled(Boolean.parseBoolean(this.gcpStorageCompressionEnabled));
            cloudStorageConfiguration = Optional.of(config);
        }
        return cloudStorageConfiguration;
    }

    static Optional<SolrConfiguration> getSolrConfigurationIfEnabled(String solrUrl) {
        SolrConfiguration config = null;
        if (null != solrUrl) {
            config = new SolrConfiguration();
            config.setUrl(solrUrl);
        }
        return Optional.ofNullable(config);
    }

    static Optional<ElasticsearchConfiguration> getElasticsearchConfigIfEnabled(String elasticsearchHosts) {
        ElasticsearchConfiguration config = null;
        if (null != elasticsearchHosts) {
            String[] hostArray;
            config = new ElasticsearchConfiguration();
            for (String entry : hostArray = elasticsearchHosts.split("[;\\s,]")) {
                config.addHost(entry);
            }
        }
        return Optional.ofNullable(config);
    }

    IBufferPublisher<Event> createCachePublisher() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        String hostName = addr.getHostName();
        BufferPublisher publisher = new BufferPublisher(hostName, this.parseTags(this.tags));
        this.getS3ConfigIfEnabled().ifPresent(config -> {
            if (this.verbose) {
                System.out.println(String.format("Registering AWS S3 publish helper -> %s", config));
            }
            publisher.addHelper((IPublishHelper)new S3PublishHelper(config, this.verbose));
        });
        this.getBlobConfigurationIfEnabled().ifPresent(config -> {
            if (this.verbose) {
                System.out.println(String.format("Registering Azure Blob Storage publish helper -> %s", config));
            }
            publisher.addHelper((IPublishHelper)new BlobPublishHelper(config, this.verbose));
        });
        this.getCloudStorageConfigurationIfEnabled().ifPresent(config -> {
            if (this.verbose) {
                System.out.println(String.format("Registering Google Cloud Storage publish helper -> %s", config));
            }
            publisher.addHelper((IPublishHelper)new CloudStoragePublishHelper(config, this.verbose));
        });
        Log4j2AppenderBuilder.getSolrConfigurationIfEnabled(this.solrUrl).ifPresent(config -> {
            if (this.verbose) {
                System.out.println(String.format("Registering SOLR publish helper -> %s", config));
            }
            publisher.addHelper((IPublishHelper)new SolrPublishHelper(config.getUrl()));
        });
        Log4j2AppenderBuilder.getElasticsearchConfigIfEnabled(this.elasticsearchHosts).ifPresent(config -> {
            if (this.verbose) {
                System.out.println(String.format("Registering Elasticsearch publish helper -> %s", config));
            }
            publisher.addHelper((IPublishHelper)new ElasticsearchPublishHelper(config));
        });
        return publisher;
    }

    String[] parseTags(String tags) {
        Set<String> parsedTags = null;
        parsedTags = null != tags ? Stream.of(tags.split("[,;]")).filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet()) : Collections.emptySet();
        return parsedTags.toArray(new String[0]);
    }

    IBufferMonitor<Event> createCacheMonitor() {
        CapacityBasedBufferMonitor monitor = new CapacityBasedBufferMonitor(this.stagingBufferSize);
        if (0 < this.stagingBufferAge) {
            monitor = new TimePeriodBasedBufferMonitor(this.stagingBufferAge);
        }
        if (this.verbose) {
            System.out.println(String.format("Using cache monitor: %s", monitor.toString()));
        }
        return monitor;
    }
}

