/*
 * Decompiled with CFR 0.152.
 */
package com.thesamet.spatial;

import com.thesamet.spatial.AboveHyperplane;
import com.thesamet.spatial.BelowHyperplane;
import com.thesamet.spatial.EntireSpace;
import com.thesamet.spatial.Region;
import com.thesamet.spatial.RegionIntersection;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u0013\ti!+Z4j_:\u0014U/\u001b7eKJT!a\u0001\u0003\u0002\u000fM\u0004\u0018\r^5bY*\u0011QAB\u0001\ti\",7/Y7fi*\tq!A\u0002d_6\u001c\u0001!\u0006\u0002\u000b1M\u0011\u0001a\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bI\u0001A\u0011A\n\u0002\rqJg.\u001b;?)\u0005!\u0002cA\u000b\u0001-5\t!\u0001\u0005\u0002\u001811\u0001A!B\r\u0001\u0005\u0004Q\"!A!\u0012\u0005mq\u0002C\u0001\u0007\u001d\u0013\tiRBA\u0004O_RD\u0017N\\4\u0011\u00051y\u0012B\u0001\u0011\u000e\u0005\r\te.\u001f\u0005\bE\u0001\u0001\r\u0011\"\u0001$\u0003\u001d\u0011XmZ5p]N,\u0012\u0001\n\t\u0004K)bS\"\u0001\u0014\u000b\u0005\u001dB\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003S5\t!bY8mY\u0016\u001cG/[8o\u0013\tYcEA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA\u000b.-%\u0011aF\u0001\u0002\u0007%\u0016<\u0017n\u001c8\t\u000fA\u0002\u0001\u0019!C\u0001c\u0005Y!/Z4j_:\u001cx\fJ3r)\t\u0011T\u0007\u0005\u0002\rg%\u0011A'\u0004\u0002\u0005+:LG\u000fC\u00047_\u0005\u0005\t\u0019\u0001\u0013\u0002\u0007a$\u0013\u0007\u0003\u00049\u0001\u0001\u0006K\u0001J\u0001\te\u0016<\u0017n\u001c8tA!)!\b\u0001C\u0001w\u0005I\u0011\r\u001a3SK\u001eLwN\u001c\u000b\u0003)qBQ!P\u001dA\u00021\naA]3hS>t\u0007\"B \u0001\t\u0003\u0001\u0015\u0001\u00024s_6$2\u0001F!D\u0011\u0015\u0011e\b1\u0001\u0017\u0003\u0005\t\u0007\"\u0002#?\u0001\u0004)\u0015a\u00013j[B\u0011ABR\u0005\u0003\u000f6\u00111!\u00138u\u0011\u0015I\u0005\u0001\"\u0001K\u0003\t!x\u000eF\u0002\u0015\u00172CQA\u0011%A\u0002YAQ\u0001\u0012%A\u0002\u0015CQA\u0014\u0001\u0005\u0002=\u000b1!\u00198e)\t!\u0002\u000bC\u0003R\u001b\u0002\u0007A#A\u0003pi\",'\u000fC\u0003T\u0001\u0011\u0005A+A\u0003ck&dG-F\u0001-\u0001")
public class RegionBuilder<A> {
    private ArrayBuffer<Region<A>> regions = new ArrayBuffer();

    public ArrayBuffer<Region<A>> regions() {
        return this.regions;
    }

    public void regions_$eq(ArrayBuffer<Region<A>> x$1) {
        this.regions = x$1;
    }

    public RegionBuilder<A> addRegion(Region<A> region) {
        this.regions().$plus$eq(region);
        return this;
    }

    public RegionBuilder<A> from(A a, int dim) {
        return this.addRegion(new AboveHyperplane<A>(a, dim));
    }

    public RegionBuilder<A> to(A a, int dim) {
        return this.addRegion(new BelowHyperplane<A>(a, dim));
    }

    public RegionBuilder<A> and(RegionBuilder<A> other) {
        this.regions().$plus$plus$eq(other.regions());
        return this;
    }

    public Region<A> build() {
        Region region;
        int n = this.regions().length();
        switch (n) {
            case 0: {
                region = new EntireSpace();
                break;
            }
            case 1: {
                region = (Region)this.regions().head();
                break;
            }
            default: {
                region = new RegionIntersection<A>(this.regions());
                break;
            }
        }
        return region;
    }
}

