/*
 * Decompiled with CFR 0.152.
 */
package protocbridge.frontend;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import protocbridge.ProtocCodeGenerator;
import protocbridge.frontend.PluginFrontend;
import protocbridge.frontend.PluginFrontend$;
import protocbridge.frontend.PosixPluginFrontend;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.sys.process.package$;

public final class PosixPluginFrontend$
implements PluginFrontend {
    public static final PosixPluginFrontend$ MODULE$;

    static {
        new PosixPluginFrontend$();
    }

    public Tuple2<Path, PosixPluginFrontend.InternalState> prepare(ProtocCodeGenerator plugin) {
        Path tempDirPath = Files.createTempDirectory("protopipe-", new FileAttribute[0]);
        Path inputPipe = this.createPipe(tempDirPath, "input");
        Path outputPipe = this.createPipe(tempDirPath, "output");
        Path sh = this.createShellScript(inputPipe, outputPipe);
        Future$.MODULE$.apply((Function0)new Serializable(plugin, inputPipe, outputPipe){
            public static final long serialVersionUID = 0L;
            private final ProtocCodeGenerator plugin$1;
            private final Path inputPipe$1;
            private final Path outputPipe$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputStream fsin = Files.newInputStream(this.inputPipe$1, new OpenOption[0]);
                byte[] response = PluginFrontend$.MODULE$.runWithInputStream(this.plugin$1, fsin);
                fsin.close();
                OutputStream fsout = Files.newOutputStream(this.outputPipe$1, new OpenOption[0]);
                fsout.write(response);
                fsout.close();
            }
            {
                this.plugin$1 = plugin$1;
                this.inputPipe$1 = inputPipe$1;
                this.outputPipe$1 = outputPipe$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        return new Tuple2((Object)sh, (Object)new PosixPluginFrontend.InternalState(inputPipe, outputPipe, tempDirPath, sh));
    }

    public void cleanup(PosixPluginFrontend.InternalState state) {
        Files.delete(state.inputPipe());
        Files.delete(state.outputPipe());
        Files.delete(state.tempDir());
        Files.delete(state.shellScript());
    }

    /*
     * WARNING - void declaration
     */
    private Path createPipe(Path tempDirPath, String name) {
        void var3_3;
        Path pipeName = tempDirPath.resolve(name);
        package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkfifo", "-m", "600", ((Object)pipeName.toAbsolutePath()).toString()}))).$bang$bang();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Path createShellScript(Path inputPipe, Path outputPipe) {
        void var3_3;
        Path scriptName = PluginFrontend$.MODULE$.createTempFile("", new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|#!/usr/bin/env sh\n          |set -e\n          |cat /dev/stdin > \"", "\"\n          |cat \"", "\"\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputPipe, outputPipe})))).stripMargin());
        Files.setPosixFilePermissions(scriptName, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ}))).asJava());
        return var3_3;
    }

    private PosixPluginFrontend$() {
        MODULE$ = this;
    }
}

