/*
 * Decompiled with CFR 0.152.
 */
package protocbridge.frontend;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import protocbridge.ExtraEnv;
import protocbridge.ProtocCodeGenerator;
import protocbridge.frontend.PluginFrontend;
import protocbridge.frontend.PluginFrontend$;
import protocbridge.frontend.PosixPluginFrontend;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.runtime.java8.JFunction0;

public final class PosixPluginFrontend$
implements PluginFrontend {
    public static PosixPluginFrontend$ MODULE$;

    static {
        new PosixPluginFrontend$();
    }

    public Tuple2<Path, PosixPluginFrontend.InternalState> prepare(ProtocCodeGenerator plugin, ExtraEnv env) {
        Path tempDirPath = Files.createTempDirectory("protopipe-", new FileAttribute[0]);
        Path inputPipe = this.createPipe(tempDirPath, "input");
        Path outputPipe = this.createPipe(tempDirPath, "output");
        Path sh = this.createShellScript(inputPipe, outputPipe);
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            InputStream fsin = Files.newInputStream(inputPipe, new OpenOption[0]);
            byte[] response = PluginFrontend$.MODULE$.runWithInputStream(plugin, fsin, env);
            fsin.close();
            OutputStream fsout = Files.newOutputStream(outputPipe, new OpenOption[0]);
            fsout.write(response);
            fsout.close();
        }), ExecutionContext.Implicits$.MODULE$.global());
        return new Tuple2((Object)sh, (Object)new PosixPluginFrontend.InternalState(inputPipe, outputPipe, tempDirPath, sh));
    }

    public void cleanup(PosixPluginFrontend.InternalState state) {
        block0: {
            Option option = scala.sys.package$.MODULE$.props().get("protocbridge.debug");
            Some some = new Some((Object)"1");
            if (!(option == null ? some != null : !option.equals(some))) break block0;
            Files.delete(state.inputPipe());
            Files.delete(state.outputPipe());
            Files.delete(state.tempDir());
            Files.delete(state.shellScript());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Path createPipe(Path tempDirPath, String name) {
        void var3_3;
        Path pipeName = tempDirPath.resolve(name);
        scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"mkfifo", (List)new .colon.colon((Object)"-m", (List)new .colon.colon((Object)"600", (List)new .colon.colon((Object)((Object)pipeName.toAbsolutePath()).toString(), (List)Nil$.MODULE$))))).$bang$bang();
        return var3_3;
    }

    private Path createShellScript(Path inputPipe, Path outputPipe) {
        String shell = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PROTOCBRIDGE_SHELL", (Function0 & Serializable & scala.Serializable)() -> "/bin/sh");
        Path scriptName = PluginFrontend$.MODULE$.createTempFile("", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("|#!").append(shell).append("\n          |set -e\n          |cat /dev/stdin > \"").append(inputPipe).append("\"\n          |cat \"").append(outputPipe).append("\"\n      ").toString())).stripMargin());
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.OWNER_READ);
        Files.setPosixFilePermissions(scriptName, perms);
        return scriptName;
    }

    private PosixPluginFrontend$() {
        MODULE$ = this;
    }
}

