/*
 * Decompiled with CFR 0.152.
 */
package protocbridge;

import java.util.Locale;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.sys.package$;
import scala.util.matching.Regex;

public final class SystemDetector$ {
    public static SystemDetector$ MODULE$;
    private final String UNKNOWN;
    private final Regex X86_64_RE;
    private final Regex X86_32_RE;

    static {
        new SystemDetector$();
    }

    private String UNKNOWN() {
        return this.UNKNOWN;
    }

    private Regex X86_64_RE() {
        return this.X86_64_RE;
    }

    private Regex X86_32_RE() {
        return this.X86_32_RE;
    }

    public String normalizedOs(String s) {
        String string = this.normalize(s);
        if (string.startsWith("aix")) {
            return "aix";
        }
        if (string.startsWith("hpux")) {
            return "hpux";
        }
        if (string.startsWith("linux")) {
            return "linux";
        }
        if (string.startsWith("osx") || string.startsWith("macosx")) {
            return "osx";
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        if (string.startsWith("freebsd")) {
            return "freebsd";
        }
        if (string.startsWith("openbsd")) {
            return "openbsd";
        }
        if (string.startsWith("netbsd")) {
            return "netbsd";
        }
        return this.UNKNOWN();
    }

    public String normalizedArch(String s) {
        String string = this.normalize(s);
        Option option = this.X86_64_RE().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            return "x86_64";
        }
        Option option2 = this.X86_32_RE().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
            return "x86_32";
        }
        if ("aarch64".equals(string)) {
            return "aarch_64";
        }
        if ("ppc64le".equals(string)) {
            return "ppcle_64";
        }
        if ("ppc64".equals(string)) {
            return "ppc_64";
        }
        if ("s390x".equals(string)) {
            return "s390x";
        }
        return this.UNKNOWN();
    }

    public String detectedClassifier() {
        String osName = (String)package$.MODULE$.props().getOrElse((Object)"os.name", (Function0 & java.io.Serializable & Serializable)() -> "");
        String osArch = (String)package$.MODULE$.props().getOrElse((Object)"os.arch", (Function0 & java.io.Serializable & Serializable)() -> "");
        System.getProperty("os.name");
        return new StringBuilder(1).append(this.normalizedOs(osName)).append("-").append(this.normalizedArch(osArch)).toString();
    }

    public String normalize(String s) {
        return s.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private SystemDetector$() {
        MODULE$ = this;
        this.UNKNOWN = "unknown";
        this.X86_64_RE = new StringOps(Predef$.MODULE$.augmentString("^(x8664|amd64|ia32e|em64t|x64)$")).r();
        this.X86_32_RE = new StringOps(Predef$.MODULE$.augmentString("^(x8632|x86|i[3-6]86|ia32|x32)$")).r();
    }
}

