/*
 * Decompiled with CFR 0.152.
 */
package protocbridge;

import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import protocbridge.FileCache$;
import scala.Function1;
import scala.Function2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e4A\u0001E\t\u0003)!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\"B%\u0001\t\u0003Q\u0005\u0002\u0003)\u0001\u0005\u0004%\t!E)\t\rq\u0003\u0001\u0015!\u0003S\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0019\t\u0007\u0001\"\u0001\u0012E\"1q\r\u0001C\u0001#!DaA\u001b\u0001\u0005\u0002EYw!B7\u0012\u0011\u0003qg!\u0002\t\u0012\u0011\u0003y\u0007\"B%\r\t\u0003\u0001\b\"\u0002\u000f\r\t\u0003\t\bB\u0002:\r\t\u0003\t2OA\u0005GS2,7)Y2iK*\t!#\u0001\u0007qe>$xn\u00192sS\u0012<Wm\u0001\u0001\u0016\u0005UY3C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fM\u0006A1-Y2iK\u0012K'\u000f\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005\u0011\u0011n\u001c\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0003GS2,\u0017!\u00023p\u000f\u0016$\b#B\f(;%\"\u0014B\u0001\u0015\u0019\u0005%1UO\\2uS>t'\u0007\u0005\u0002+W1\u0001A!\u0002\u0017\u0001\u0005\u0004i#!A&\u0012\u00059\n\u0004CA\f0\u0013\t\u0001\u0004DA\u0004O_RD\u0017N\\4\u0011\u0005]\u0011\u0014BA\u001a\u0019\u0005\r\te.\u001f\t\u0004kajR\"\u0001\u001c\u000b\u0005]B\u0012AC2p]\u000e,(O]3oi&\u0011\u0011H\u000e\u0002\u0007\rV$XO]3\u0002\u001b-,\u00170Q:GS2,g*Y7f!\u00119B(\u000b \n\u0005uB\"!\u0003$v]\u000e$\u0018n\u001c82!\tydI\u0004\u0002A\tB\u0011\u0011\tG\u0007\u0002\u0005*\u00111iE\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015C\u0012A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\r\u0002\rqJg.\u001b;?)\u0011YUJT(\u0011\u00071\u0003\u0011&D\u0001\u0012\u0011\u0015aB\u00011\u0001\u001e\u0011\u0015)C\u00011\u0001'\u0011\u0015QD\u00011\u0001<\u0003\u0015!\u0018m]6t+\u0005\u0011\u0006\u0003B*XSek\u0011\u0001\u0016\u0006\u0003oUS!AV\u0011\u0002\tU$\u0018\u000e\\\u0005\u00031R\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\r)$,H\u0005\u00037Z\u0012q\u0001\u0015:p[&\u001cX-\u0001\u0004uCN\\7\u000fI\u0001\u0004O\u0016$HC\u0001\u001b`\u0011\u0015\u0001w\u00011\u0001*\u0003\rYW-_\u0001\fG>\u0004\u0018\u0010V8DC\u000eDW\rF\u0002\u001eG\u0016DQ\u0001\u001a\u0005A\u0002u\t1a\u001d:d\u0011\u00151\u0007\u00021\u0001\u001e\u0003\r!7\u000f^\u0001\u000bM&dWMR8s\u0017\u0016LHCA\u000fj\u0011\u0015\u0001\u0017\u00021\u0001*\u00039\u0019w.\u001c9mKR,W*\u0019:lKJ$\"!\b7\t\u000b\u0001T\u0001\u0019A\u0015\u0002\u0013\u0019KG.Z\"bG\",\u0007C\u0001'\r'\taa\u0003F\u0001o+\u0005i\u0012A\u00023fY\u0016$X\r\u0006\u0002uoB\u0011q#^\u0005\u0003mb\u0011A!\u00168ji\")\u0001p\u0004a\u0001;\u0005\u0019A-\u001b:")
public final class FileCache<K> {
    private final File cacheDir;
    private final Function2<File, K, Future<File>> doGet;
    private final Function1<K, String> keyAsFileName;
    private final ConcurrentHashMap<K, Promise<File>> tasks;

    public ConcurrentHashMap<K, Promise<File>> tasks() {
        return this.tasks;
    }

    public Future<File> get(K key) {
        Future future;
        File f = this.fileForKey(key);
        File cm = this.completeMarker(key);
        if (cm.exists() && f.exists()) {
            f.setExecutable(true);
            future = Future$.MODULE$.successful((Object)f);
        } else {
            Promise p = Promise$.MODULE$.apply();
            Promise<File> prev = this.tasks().putIfAbsent(key, (Promise<File>)p);
            if (prev == null) {
                File tmpDir = Files.createTempDirectory("protocbridge", new FileAttribute[0]).toFile();
                ((Future)this.doGet.apply((Object)tmpDir, key)).map((Function1 & Serializable)x$1 -> this.copyToCache((File)x$1, f), ExecutionContext.Implicits$.MODULE$.global()).onComplete((Function1 & Serializable)res -> {
                    FileCache$.MODULE$.delete(tmpDir);
                    Object object = res.isFailure() ? this.tasks().remove(key) : BoxesRunTime.boxToBoolean((boolean)this.completeMarker(key).createNewFile());
                    return p.complete(res);
                }, ExecutionContext.Implicits$.MODULE$.global());
                future = p.future();
            } else {
                p.complete(null);
                future = prev.future();
            }
        }
        return future;
    }

    public File copyToCache(File src, File dst) {
        Path dstPath = dst.toPath();
        Files.copy(src.toPath(), dst.toPath(), new CopyOption[0]);
        dst.setExecutable(true);
        return dst;
    }

    public File fileForKey(K key) {
        return new File(this.cacheDir, (String)this.keyAsFileName.apply(key));
    }

    public File completeMarker(K key) {
        return new File(this.cacheDir, new StringBuilder(9).append((String)this.keyAsFileName.apply(key)).append(".complete").toString());
    }

    public FileCache(File cacheDir, Function2<File, K, Future<File>> doGet, Function1<K, String> keyAsFileName) {
        this.cacheDir = cacheDir;
        this.doGet = doGet;
        this.keyAsFileName = keyAsFileName;
        this.tasks = new ConcurrentHashMap();
    }
}

