/*
 * Decompiled with CFR 0.152.
 */
package scalapb.json4s;

import com.google.protobuf.TextFormat;
import com.google.protobuf.timestamp.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.json4s.Durations$;

public final class Timestamps$ {
    public static final Timestamps$ MODULE$;
    private final long TIMESTAMP_SECONDS_MIN;
    private final long TIMESTAMP_SECONDS_MAX;
    private final int MILLIS_PER_SECOND;
    private final int MICROS_PER_SECOND;
    private final int NANOS_PER_SECOND;
    private final int NANOS_PER_MILLISECOND;
    private final int NANOS_PER_MICROSECOND;
    private final ThreadLocal<SimpleDateFormat> timestampFormat;

    static {
        new Timestamps$();
    }

    public long TIMESTAMP_SECONDS_MIN() {
        return this.TIMESTAMP_SECONDS_MIN;
    }

    public long TIMESTAMP_SECONDS_MAX() {
        return this.TIMESTAMP_SECONDS_MAX;
    }

    public int MILLIS_PER_SECOND() {
        return this.MILLIS_PER_SECOND;
    }

    public int MICROS_PER_SECOND() {
        return this.MICROS_PER_SECOND;
    }

    public int NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public int NANOS_PER_MILLISECOND() {
        return this.NANOS_PER_MILLISECOND;
    }

    public int NANOS_PER_MICROSECOND() {
        return this.NANOS_PER_MICROSECOND;
    }

    private ThreadLocal<SimpleDateFormat> timestampFormat() {
        return this.timestampFormat;
    }

    public boolean isValid(Timestamp ts) {
        return ts.seconds() >= this.TIMESTAMP_SECONDS_MIN() && ts.seconds() <= this.TIMESTAMP_SECONDS_MAX() && ts.nanos() >= 0 && ts.nanos() < this.NANOS_PER_SECOND();
    }

    public Timestamp checkValid(Timestamp ts) {
        Predef$.MODULE$.require(this.isValid(ts), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timestamp is not valid.";
            }
        });
        return ts;
    }

    public String formatNanos(int nanos) {
        return nanos % this.NANOS_PER_MILLISECOND() == 0 ? new StringOps(Predef$.MODULE$.augmentString("%1$03d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MILLISECOND()))})) : (nanos % this.NANOS_PER_MICROSECOND() == 0 ? new StringOps(Predef$.MODULE$.augmentString("%1$06d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MICROSECOND()))})) : new StringOps(Predef$.MODULE$.augmentString("%1$09d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nanos)})));
    }

    public String writeTimestamp(Timestamp ts) {
        BoxedUnit boxedUnit;
        this.checkValid(ts);
        StringBuilder result = new StringBuilder();
        Date date = new Date(ts.seconds() * (long)this.MILLIS_PER_SECOND());
        result.append(((DateFormat)this.timestampFormat().get()).format(date));
        if (ts.nanos() != 0) {
            result.append(".");
            boxedUnit = result.append(this.formatNanos(ts.nanos()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        result.append("Z");
        return result.toString();
    }

    public long parseTimezoneOffset(String s) {
        long l;
        char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0);
        switch (c) {
            default: {
                throw new TextFormat.ParseException("Failed to parse timestamp.");
            }
            case '+': 
            case '-': {
                int pos = s.indexOf(58);
                if (pos == -1) {
                    throw new TextFormat.ParseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse timestamp: invalid offset value: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                }
                String hours = s.substring(1, pos);
                String minutes = s.substring(pos + 1);
                long r = new StringOps(Predef$.MODULE$.augmentString(hours)).toLong() * 3600L + new StringOps(Predef$.MODULE$.augmentString(minutes)).toLong() * 60L;
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0) == '-') {
                    l = -r;
                    break;
                }
                l = r;
                break;
            }
            case 'Z': {
                if (s.length() != 1) {
                    throw new TextFormat.ParseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse timestamp: invalid trailing data: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                }
                l = 0L;
            }
        }
        return l;
    }

    public Timestamp parseTimestamp(String value) {
        block8: {
            Tuple2 tuple2;
            int n;
            block6: {
                int dayOffset;
                block7: {
                    block5: {
                        dayOffset = value.indexOf(84);
                        if (dayOffset == -1) {
                            throw new TextFormat.ParseException("Failed to parse timestamp.");
                        }
                        int zIndex = value.indexOf(90, dayOffset);
                        if (zIndex == -1) break block5;
                        n = zIndex;
                        break block6;
                    }
                    int pIndex = value.indexOf(43, dayOffset);
                    if (pIndex == -1) break block7;
                    n = pIndex;
                    break block6;
                }
                int mIndex = value.indexOf(45, dayOffset);
                if (mIndex == -1) break block8;
                n = mIndex;
            }
            int timezoneOffsetPosition = n;
            long timezoneOffset = this.parseTimezoneOffset(value.substring(timezoneOffsetPosition));
            String timeValue = value.substring(0, timezoneOffsetPosition);
            int pointPosition = timeValue.indexOf(46);
            Tuple2 tuple22 = tuple2 = pointPosition == -1 ? new Tuple2((Object)timeValue, (Object)"") : new Tuple2((Object)timeValue.substring(0, pointPosition), (Object)timeValue.substring(pointPosition + 1));
            if (tuple2 != null) {
                Tuple2 tuple23;
                String secondValue = (String)tuple2._1();
                String nanoValue = (String)tuple2._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)secondValue, (Object)nanoValue);
                String secondValue2 = (String)tuple24._1();
                String nanoValue2 = (String)tuple24._2();
                Date date = ((DateFormat)this.timestampFormat().get()).parse(secondValue2);
                long seconds = date.getTime() / (long)this.MILLIS_PER_SECOND() - timezoneOffset;
                int nanos = nanoValue2.isEmpty() ? 0 : Durations$.MODULE$.parseNanos(nanoValue2);
                return this.normalizedTimestamp(seconds, nanos);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new TextFormat.ParseException("Failed to parse timestamp: missing valid timezone offset.");
    }

    public Timestamp normalizedTimestamp(long seconds, int nanos) {
        Tuple2.mcJI.sp sp2;
        Tuple2.mcJI.sp sp3 = sp2 = nanos <= -this.NANOS_PER_SECOND() || nanos >= this.NANOS_PER_SECOND() ? new Tuple2.mcJI.sp(seconds + (long)(nanos / this.NANOS_PER_SECOND()), nanos % this.NANOS_PER_SECOND()) : new Tuple2.mcJI.sp(seconds, nanos);
        if (sp2 != null) {
            Tuple2.mcJI.sp sp4;
            Tuple2.mcJI.sp sp5;
            long ns = sp2._1$mcJ$sp();
            int nn = sp2._2$mcI$sp();
            Tuple2.mcJI.sp sp6 = sp5 = new Tuple2.mcJI.sp(ns, nn);
            long ns2 = sp6._1$mcJ$sp();
            int nn2 = sp6._2$mcI$sp();
            Tuple2.mcJI.sp sp7 = sp4 = nn2 < 0 ? new Tuple2.mcJI.sp(seconds - 1L, nanos + this.NANOS_PER_SECOND()) : new Tuple2.mcJI.sp(ns2, nn2);
            if (sp4 != null) {
                Tuple2.mcJI.sp sp8;
                long ns22 = sp4._1$mcJ$sp();
                int nn22 = sp4._2$mcI$sp();
                Tuple2.mcJI.sp sp9 = sp8 = new Tuple2.mcJI.sp(ns22, nn22);
                long ns23 = sp9._1$mcJ$sp();
                int nn23 = sp9._2$mcI$sp();
                return this.checkValid(new Timestamp(ns23, nn23));
            }
            throw new MatchError((Object)sp4);
        }
        throw new MatchError((Object)sp2);
    }

    private Timestamps$() {
        MODULE$ = this;
        this.TIMESTAMP_SECONDS_MIN = -62135596800L;
        this.TIMESTAMP_SECONDS_MAX = 253402300799L;
        this.MILLIS_PER_SECOND = 1000;
        this.MICROS_PER_SECOND = 1000000;
        this.NANOS_PER_SECOND = 1000000000;
        this.NANOS_PER_MILLISECOND = 1000000;
        this.NANOS_PER_MICROSECOND = 1000;
        this.timestampFormat = new ThreadLocal<SimpleDateFormat>(){

            /*
             * WARNING - void declaration
             */
            public SimpleDateFormat initialValue() {
                void var1_1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                calendar.setGregorianChange(new Date(Long.MIN_VALUE));
                sdf.setCalendar(calendar);
                return var1_1;
            }
        };
    }
}

