/*
 * Decompiled with CFR 0.152.
 */
package scalapb.json4s;

import com.google.protobuf.TextFormat;
import com.google.protobuf.timestamp.Timestamp;
import com.google.protobuf.timestamp.Timestamp$;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.json4s.Durations$;

public final class Timestamps$ {
    public static Timestamps$ MODULE$;
    private final long TIMESTAMP_SECONDS_MIN;
    private final long TIMESTAMP_SECONDS_MAX;
    private final int MILLIS_PER_SECOND;
    private final int MICROS_PER_SECOND;
    private final int NANOS_PER_SECOND;
    private final int NANOS_PER_MILLISECOND;
    private final int NANOS_PER_MICROSECOND;
    private final ThreadLocal<SimpleDateFormat> timestampFormat;

    static {
        new Timestamps$();
    }

    public long TIMESTAMP_SECONDS_MIN() {
        return this.TIMESTAMP_SECONDS_MIN;
    }

    public long TIMESTAMP_SECONDS_MAX() {
        return this.TIMESTAMP_SECONDS_MAX;
    }

    public int MILLIS_PER_SECOND() {
        return this.MILLIS_PER_SECOND;
    }

    public int MICROS_PER_SECOND() {
        return this.MICROS_PER_SECOND;
    }

    public int NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public int NANOS_PER_MILLISECOND() {
        return this.NANOS_PER_MILLISECOND;
    }

    public int NANOS_PER_MICROSECOND() {
        return this.NANOS_PER_MICROSECOND;
    }

    private ThreadLocal<SimpleDateFormat> timestampFormat() {
        return this.timestampFormat;
    }

    public boolean isValid(Timestamp ts) {
        return ts.seconds() >= this.TIMESTAMP_SECONDS_MIN() && ts.seconds() <= this.TIMESTAMP_SECONDS_MAX() && ts.nanos() >= 0 && ts.nanos() < this.NANOS_PER_SECOND();
    }

    public Timestamp checkValid(Timestamp ts) {
        Predef$.MODULE$.require(this.isValid(ts), (Function0 & java.io.Serializable & Serializable)() -> "Timestamp is not valid.");
        return ts;
    }

    public String formatNanos(int nanos) {
        return nanos % this.NANOS_PER_MILLISECOND() == 0 ? new StringOps(Predef$.MODULE$.augmentString("%1$03d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MILLISECOND()))})) : (nanos % this.NANOS_PER_MICROSECOND() == 0 ? new StringOps(Predef$.MODULE$.augmentString("%1$06d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MICROSECOND()))})) : new StringOps(Predef$.MODULE$.augmentString("%1$09d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nanos)})));
    }

    public String writeTimestamp(Timestamp ts) {
        BoxedUnit boxedUnit;
        this.checkValid(ts);
        scala.collection.mutable.StringBuilder result = new scala.collection.mutable.StringBuilder();
        Date date = new Date(ts.seconds() * (long)this.MILLIS_PER_SECOND());
        result.append(((DateFormat)this.timestampFormat().get()).format(date));
        if (ts.nanos() != 0) {
            result.append(".");
            boxedUnit = result.append(this.formatNanos(ts.nanos()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        result.append("Z");
        return result.toString();
    }

    public long parseTimezoneOffset(String s) {
        long l;
        char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0);
        switch (c) {
            case 'Z': {
                if (s.length() != 1) {
                    throw new TextFormat.ParseException(new StringBuilder(52).append("Failed to parse timestamp: invalid trailing data: '").append(s).append("'").toString());
                }
                l = 0L;
                break;
            }
            case '+': 
            case '-': {
                int pos = s.indexOf(58);
                if (pos == -1) {
                    throw new TextFormat.ParseException(new StringBuilder(51).append("Failed to parse timestamp: invalid offset value: '").append(s).append("'").toString());
                }
                String hours = s.substring(1, pos);
                String minutes = s.substring(pos + 1);
                long r = new StringOps(Predef$.MODULE$.augmentString(hours)).toLong() * 3600L + new StringOps(Predef$.MODULE$.augmentString(minutes)).toLong() * 60L;
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0) == '-') {
                    l = -r;
                    break;
                }
                l = r;
                break;
            }
            default: {
                throw new TextFormat.ParseException("Failed to parse timestamp.");
            }
        }
        return l;
    }

    public Timestamp parseTimestamp(String value) {
        Tuple2 tuple2;
        int n;
        int dayOffset = value.indexOf(84);
        if (dayOffset == -1) {
            throw new TextFormat.ParseException("Failed to parse timestamp.");
        }
        int zIndex = value.indexOf(90, dayOffset);
        if (zIndex != -1) {
            n = zIndex;
        } else {
            int pIndex = value.indexOf(43, dayOffset);
            if (pIndex != -1) {
                n = pIndex;
            } else {
                int mIndex = value.indexOf(45, dayOffset);
                if (mIndex != -1) {
                    n = mIndex;
                } else {
                    throw new TextFormat.ParseException("Failed to parse timestamp: missing valid timezone offset.");
                }
            }
        }
        int timezoneOffsetPosition = n;
        long timezoneOffset = this.parseTimezoneOffset(value.substring(timezoneOffsetPosition));
        String timeValue = value.substring(0, timezoneOffsetPosition);
        int pointPosition = timeValue.indexOf(46);
        Tuple2 tuple22 = tuple2 = pointPosition == -1 ? new Tuple2((Object)timeValue, (Object)"") : new Tuple2((Object)timeValue.substring(0, pointPosition), (Object)timeValue.substring(pointPosition + 1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String secondValue = (String)tuple2._1();
        String nanoValue = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)secondValue, (Object)nanoValue);
        Tuple2 tuple24 = tuple23;
        String secondValue2 = (String)tuple24._1();
        String nanoValue2 = (String)tuple24._2();
        Date date = ((DateFormat)this.timestampFormat().get()).parse(secondValue2);
        long seconds = date.getTime() / (long)this.MILLIS_PER_SECOND() - timezoneOffset;
        int nanos = nanoValue2.isEmpty() ? 0 : Durations$.MODULE$.parseNanos(nanoValue2);
        return this.normalizedTimestamp(seconds, nanos);
    }

    public Timestamp normalizedTimestamp(long seconds, int nanos) {
        Tuple2.mcJI.sp sp2;
        Tuple2.mcJI.sp sp3;
        Tuple2.mcJI.sp sp4 = sp3 = nanos <= -this.NANOS_PER_SECOND() || nanos >= this.NANOS_PER_SECOND() ? new Tuple2.mcJI.sp(seconds + (long)(nanos / this.NANOS_PER_SECOND()), nanos % this.NANOS_PER_SECOND()) : new Tuple2.mcJI.sp(seconds, nanos);
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        long ns = sp3._1$mcJ$sp();
        int nn = sp3._2$mcI$sp();
        Tuple2.mcJI.sp sp5 = new Tuple2.mcJI.sp(ns, nn);
        Tuple2.mcJI.sp sp6 = sp5;
        long ns2 = sp6._1$mcJ$sp();
        int nn2 = sp6._2$mcI$sp();
        Tuple2.mcJI.sp sp7 = sp2 = nn2 < 0 ? new Tuple2.mcJI.sp(seconds - 1L, nanos + this.NANOS_PER_SECOND()) : new Tuple2.mcJI.sp(ns2, nn2);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long ns22 = sp2._1$mcJ$sp();
        int nn22 = sp2._2$mcI$sp();
        Tuple2.mcJI.sp sp8 = new Tuple2.mcJI.sp(ns22, nn22);
        Tuple2.mcJI.sp sp9 = sp8;
        long ns23 = sp9._1$mcJ$sp();
        int nn23 = sp9._2$mcI$sp();
        return this.checkValid(new Timestamp(ns23, nn23, Timestamp$.MODULE$.apply$default$3()));
    }

    private Timestamps$() {
        MODULE$ = this;
        this.TIMESTAMP_SECONDS_MIN = -62135596800L;
        this.TIMESTAMP_SECONDS_MAX = 253402300799L;
        this.MILLIS_PER_SECOND = 1000;
        this.MICROS_PER_SECOND = 1000000;
        this.NANOS_PER_SECOND = 1000000000;
        this.NANOS_PER_MILLISECOND = 1000000;
        this.NANOS_PER_MICROSECOND = 1000;
        this.timestampFormat = new ThreadLocal<SimpleDateFormat>(){

            /*
             * WARNING - void declaration
             */
            public SimpleDateFormat initialValue() {
                void var1_1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                calendar.setGregorianChange(new Date(Long.MIN_VALUE));
                sdf.setCalendar(calendar);
                return var1_1;
            }
        };
    }
}

