/*
 * Decompiled with CFR 0.152.
 */
package scalapb.json4s;

import com.fasterxml.jackson.core.Base64Variants;
import com.google.protobuf.ByteString;
import com.google.protobuf.any.Any;
import com.google.protobuf.descriptor.FieldDescriptorProto;
import com.google.protobuf.duration.Duration;
import com.google.protobuf.struct.ListValue;
import com.google.protobuf.struct.NullValue;
import com.google.protobuf.struct.NullValue$;
import com.google.protobuf.struct.Struct;
import com.google.protobuf.struct.Value;
import com.google.protobuf.timestamp.Timestamp;
import com.google.protobuf.wrappers.BoolValue;
import com.google.protobuf.wrappers.BoolValue$;
import com.google.protobuf.wrappers.BytesValue;
import com.google.protobuf.wrappers.BytesValue$;
import com.google.protobuf.wrappers.DoubleValue;
import com.google.protobuf.wrappers.DoubleValue$;
import com.google.protobuf.wrappers.FloatValue;
import com.google.protobuf.wrappers.FloatValue$;
import com.google.protobuf.wrappers.Int32Value;
import com.google.protobuf.wrappers.Int32Value$;
import com.google.protobuf.wrappers.Int64Value;
import com.google.protobuf.wrappers.Int64Value$;
import com.google.protobuf.wrappers.StringValue;
import com.google.protobuf.wrappers.StringValue$;
import com.google.protobuf.wrappers.UInt32Value;
import com.google.protobuf.wrappers.UInt32Value$;
import com.google.protobuf.wrappers.UInt64Value;
import com.google.protobuf.wrappers.UInt64Value$;
import org.json4s.JsonAST;
import org.json4s.Reader;
import org.json4s.Writer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scalapb.GeneratedMessage;
import scalapb.GeneratedMessageCompanion;
import scalapb.Message;
import scalapb.descriptors.EnumDescriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEnum;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PString;
import scalapb.descriptors.PValue;
import scalapb.descriptors.ScalaType;
import scalapb.json4s.AnyFormat$;
import scalapb.json4s.Durations$;
import scalapb.json4s.FormatRegistry;
import scalapb.json4s.FormatRegistry$;
import scalapb.json4s.JsonFormatException;
import scalapb.json4s.NameUtils$;
import scalapb.json4s.Parser;
import scalapb.json4s.Parser$;
import scalapb.json4s.Printer;
import scalapb.json4s.Printer$;
import scalapb.json4s.StructFormat$;
import scalapb.json4s.Timestamps$;

public final class JsonFormat$ {
    public static JsonFormat$ MODULE$;
    private final FormatRegistry DefaultRegistry;
    private final Printer printer;
    private final Parser parser;
    private final BigInt MAX_UINT64;

    static {
        new JsonFormat$();
    }

    public FormatRegistry DefaultRegistry() {
        return this.DefaultRegistry;
    }

    public <T extends GeneratedMessage & Message<T>> Function2<Printer, T, JsonAST.JValue> primitiveWrapperWriter(GeneratedMessageCompanion<T> cmp) {
        FieldDescriptor fieldDesc = (FieldDescriptor)cmp.scalaDescriptor().findFieldByNumber(1).get();
        return (Function2 & java.io.Serializable & Serializable)(printer, t) -> printer.serializeSingleValue(fieldDesc, t.getField(fieldDesc), false);
    }

    public <T extends GeneratedMessage & Message<T>> Function2<Parser, JsonAST.JValue, T> primitiveWrapperParser(GeneratedMessageCompanion<T> cmp) {
        FieldDescriptor fieldDesc = (FieldDescriptor)cmp.scalaDescriptor().findFieldByNumber(1).get();
        return (Function2 & java.io.Serializable & Serializable)(parser, jv) -> (GeneratedMessage)cmp.messageReads().read().apply((Object)new PMessage((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fieldDesc), (Object)MODULE$.parsePrimitive(fieldDesc.scalaType(), fieldDesc.protoType(), (JsonAST.JValue)jv, (Function0<PValue>)(Function0 & java.io.Serializable & Serializable)() -> {
            throw new JsonFormatException(new StringBuilder(21).append("Unexpected value for ").append(cmp.scalaDescriptor().name()).toString());
        }))}))));
    }

    public Printer printer() {
        return this.printer;
    }

    public Parser parser() {
        return this.parser;
    }

    public <A extends GeneratedMessage> String toJsonString(A m) {
        return this.printer().print(m);
    }

    public <A extends GeneratedMessage> JsonAST.JValue toJson(A m) {
        return this.printer().toJson(m);
    }

    public <A extends GeneratedMessage & Message<A>> A fromJson(JsonAST.JValue value, GeneratedMessageCompanion<A> evidence$2) {
        return this.parser().fromJson(value, evidence$2);
    }

    public <A extends GeneratedMessage & Message<A>> A fromJsonString(String str, GeneratedMessageCompanion<A> evidence$3) {
        return this.parser().fromJsonString(str, evidence$3);
    }

    public <T extends GeneratedMessage & Message<T>> Reader<T> protoToReader(GeneratedMessageCompanion<T> evidence$4) {
        return new Reader<T>(evidence$4){
            private final GeneratedMessageCompanion evidence$4$1;

            public T read(JsonAST.JValue value) {
                return (T)JsonFormat$.MODULE$.parser().fromJson(value, this.evidence$4$1);
            }
            {
                this.evidence$4$1 = evidence$4$1;
            }
        };
    }

    public <T extends GeneratedMessage & Message<T>> Writer<T> protoToWriter() {
        return new Writer<T>(){

            public JsonAST.JValue write(T obj) {
                return JsonFormat$.MODULE$.printer().toJson(obj);
            }
        };
    }

    public PValue defaultValue(FieldDescriptor fd) {
        PInt pInt;
        Predef$.MODULE$.require(fd.isOptional());
        ScalaType scalaType = fd.scalaType();
        if (ScalaType.Int$.MODULE$.equals(scalaType)) {
            pInt = new PInt(0);
        } else if (ScalaType.Long$.MODULE$.equals(scalaType)) {
            pInt = new PLong(0L);
        } else if (ScalaType.Float$.MODULE$.equals(scalaType)) {
            pInt = new PFloat(0.0f);
        } else if (ScalaType.Double$.MODULE$.equals(scalaType)) {
            pInt = new PDouble(0.0);
        } else if (ScalaType.Boolean$.MODULE$.equals(scalaType)) {
            pInt = new PBoolean(false);
        } else if (ScalaType.String$.MODULE$.equals(scalaType)) {
            pInt = new PString("");
        } else if (ScalaType.ByteString$.MODULE$.equals(scalaType)) {
            pInt = new PByteString(ByteString.EMPTY);
        } else if (scalaType instanceof ScalaType.Enum) {
            ScalaType.Enum enum_ = (ScalaType.Enum)scalaType;
            EnumDescriptor ed = enum_.descriptor();
            pInt = new PEnum((EnumValueDescriptor)ed.values().apply(0));
        } else {
            if (scalaType instanceof ScalaType.Message) {
                throw new RuntimeException("No default value for message");
            }
            throw new MatchError((Object)scalaType);
        }
        return pInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PValue parsePrimitive(ScalaType scalaType, FieldDescriptorProto.Type protoType, JsonAST.JValue value, Function0<PValue> onError) {
        Tuple2 tuple2 = new Tuple2((Object)scalaType, (Object)value);
        if (tuple2 != null) {
            ScalaType scalaType2 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Int$.MODULE$.equals(scalaType2) && jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt x = jInt.num();
                return new PInt(x.intValue());
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType3 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Int$.MODULE$.equals(scalaType3) && jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double x = jDouble.num();
                return new PInt(Predef$.MODULE$.double2Double(x).intValue());
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType4 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Int$.MODULE$.equals(scalaType4) && jValue instanceof JsonAST.JDecimal) {
                JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
                BigDecimal x = jDecimal.num();
                return new PInt(x.intValue());
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType5 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Int$.MODULE$.equals(scalaType5) && jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String x = jString.s();
                if (protoType.isTypeInt32()) {
                    return this.parseInt32(x);
                }
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType6 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Int$.MODULE$.equals(scalaType6) && jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String x = jString.s();
                if (protoType.isTypeSint32()) {
                    return this.parseInt32(x);
                }
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType7 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Int$.MODULE$.equals(scalaType7) && jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String x = jString.s();
                return this.parseUint32(x);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType8 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Long$.MODULE$.equals(scalaType8) && jValue instanceof JsonAST.JLong) {
                JsonAST.JLong jLong = (JsonAST.JLong)jValue;
                long x = jLong.num();
                return new PLong(x);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType9 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Long$.MODULE$.equals(scalaType9) && jValue instanceof JsonAST.JDecimal) {
                JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
                BigDecimal x = jDecimal.num();
                return new PLong(x.longValue());
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType10 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Long$.MODULE$.equals(scalaType10) && jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String x = jString.s();
                if (protoType.isTypeInt64()) {
                    return this.parseInt64(x);
                }
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType11 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Long$.MODULE$.equals(scalaType11) && jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String x = jString.s();
                if (protoType.isTypeSint64()) {
                    return this.parseInt64(x);
                }
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType12 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Long$.MODULE$.equals(scalaType12) && jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String x = jString.s();
                return this.parseUint64(x);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType13 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Long$.MODULE$.equals(scalaType13) && jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt x = jInt.num();
                return new PLong(x.toLong());
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType14 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Double$.MODULE$.equals(scalaType14) && jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double x = jDouble.num();
                return new PDouble(x);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType15 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Double$.MODULE$.equals(scalaType15) && jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt x = jInt.num();
                return new PDouble(x.toDouble());
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType16 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Double$.MODULE$.equals(scalaType16) && jValue instanceof JsonAST.JDecimal) {
                JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
                BigDecimal x = jDecimal.num();
                return new PDouble(x.toDouble());
            }
        }
        if (tuple2 != null) {
            JsonAST.JString jString;
            String string;
            ScalaType scalaType17 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Double$.MODULE$.equals(scalaType17) && jValue instanceof JsonAST.JString && "NaN".equals(string = (jString = (JsonAST.JString)jValue).s())) {
                return new PDouble(Double.NaN);
            }
        }
        if (tuple2 != null) {
            JsonAST.JString jString;
            String string;
            ScalaType scalaType18 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Double$.MODULE$.equals(scalaType18) && jValue instanceof JsonAST.JString && "Infinity".equals(string = (jString = (JsonAST.JString)jValue).s())) {
                return new PDouble(Double.POSITIVE_INFINITY);
            }
        }
        if (tuple2 != null) {
            JsonAST.JString jString;
            String string;
            ScalaType scalaType19 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Double$.MODULE$.equals(scalaType19) && jValue instanceof JsonAST.JString && "-Infinity".equals(string = (jString = (JsonAST.JString)jValue).s())) {
                return new PDouble(Double.NEGATIVE_INFINITY);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType20 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Float$.MODULE$.equals(scalaType20) && jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double x = jDouble.num();
                return new PFloat((float)x);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType21 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Float$.MODULE$.equals(scalaType21) && jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt x = jInt.num();
                return new PFloat(x.toFloat());
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType22 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Float$.MODULE$.equals(scalaType22) && jValue instanceof JsonAST.JDecimal) {
                JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
                BigDecimal x = jDecimal.num();
                return new PFloat(x.toFloat());
            }
        }
        if (tuple2 != null) {
            JsonAST.JString jString;
            String string;
            ScalaType scalaType23 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Float$.MODULE$.equals(scalaType23) && jValue instanceof JsonAST.JString && "NaN".equals(string = (jString = (JsonAST.JString)jValue).s())) {
                return new PFloat(Float.NaN);
            }
        }
        if (tuple2 != null) {
            JsonAST.JString jString;
            String string;
            ScalaType scalaType24 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Float$.MODULE$.equals(scalaType24) && jValue instanceof JsonAST.JString && "Infinity".equals(string = (jString = (JsonAST.JString)jValue).s())) {
                return new PFloat(Float.POSITIVE_INFINITY);
            }
        }
        if (tuple2 != null) {
            JsonAST.JString jString;
            String string;
            ScalaType scalaType25 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Float$.MODULE$.equals(scalaType25) && jValue instanceof JsonAST.JString && "-Infinity".equals(string = (jString = (JsonAST.JString)jValue).s())) {
                return new PFloat(Float.NEGATIVE_INFINITY);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType26 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.Boolean$.MODULE$.equals(scalaType26) && jValue instanceof JsonAST.JBool) {
                JsonAST.JBool jBool = (JsonAST.JBool)jValue;
                boolean b = jBool.value();
                return new PBoolean(b);
            }
        }
        if (tuple2 != null) {
            ScalaType scalaType27 = (ScalaType)tuple2._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            if (ScalaType.String$.MODULE$.equals(scalaType27) && jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                return new PString(s);
            }
        }
        if (tuple2 == null) return (PValue)onError.apply();
        ScalaType scalaType28 = (ScalaType)tuple2._1();
        JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
        if (!ScalaType.ByteString$.MODULE$.equals(scalaType28)) return (PValue)onError.apply();
        if (!(jValue instanceof JsonAST.JString)) return (PValue)onError.apply();
        JsonAST.JString jString = (JsonAST.JString)jValue;
        String s = jString.s();
        return new PByteString(ByteString.copyFrom((byte[])Base64Variants.getDefaultVariant().decode(s)));
    }

    public BigDecimal parseBigDecimal(String value) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(value);
        }
        catch (Exception e) {
            throw new JsonFormatException(new StringBuilder(21).append("Not a numeric value: ").append(value).toString(), e);
        }
        return bigDecimal;
    }

    public PValue parseInt32(String value) {
        PInt pInt;
        try {
            pInt = new PInt(new StringOps(Predef$.MODULE$.augmentString(value)).toInt());
        }
        catch (Exception exception) {
            try {
                pInt = new PInt(this.parseBigDecimal(value).toIntExact());
            }
            catch (Exception e) {
                throw new JsonFormatException(new StringBuilder(20).append("Not an int32 value: ").append(value).toString(), e);
            }
        }
        return pInt;
    }

    public PValue parseInt64(String value) {
        PLong pLong;
        try {
            pLong = new PLong(new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
        }
        catch (Exception exception) {
            BigDecimal bd = this.parseBigDecimal(value);
            try {
                pLong = new PLong(bd.toLongExact());
            }
            catch (Exception e) {
                throw new JsonFormatException(new StringBuilder(20).append("Not an int64 value: ").append(value).toString(), e);
            }
        }
        return pLong;
    }

    public PValue parseUint32(String value) {
        try {
            long result = new StringOps(Predef$.MODULE$.augmentString(value)).toLong();
            if (result < 0L || result > 0xFFFFFFFFL) {
                throw new JsonFormatException(new StringBuilder(27).append("Out of range uint32 value: ").append(value).toString());
            }
            return new PInt((int)result);
        }
        catch (JsonFormatException e) {
            throw e;
        }
        catch (Exception e) {
            return (PValue)this.parseBigDecimal(value).toBigIntExact().map((Function1 & java.io.Serializable & Serializable)intVal -> new PLong(JsonFormat$.$anonfun$parseUint32$1(value, intVal))).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
                throw new JsonFormatException(new StringBuilder(21).append("Not an uint32 value: ").append(value).toString());
            });
        }
    }

    public BigInt MAX_UINT64() {
        return this.MAX_UINT64;
    }

    public PValue parseUint64(String value) {
        return (PValue)this.parseBigDecimal(value).toBigIntExact().map((Function1 & java.io.Serializable & Serializable)intVal -> new PLong(JsonFormat$.$anonfun$parseUint64$1(value, intVal))).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new JsonFormatException(new StringBuilder(21).append("Not an uint64 value: ").append(value).toString());
        });
    }

    public String jsonName(FieldDescriptor fd) {
        return (String)fd.asProto().jsonName().getOrElse((Function0 & java.io.Serializable & Serializable)() -> NameUtils$.MODULE$.snakeCaseToCamelCase(fd.asProto().getName(), NameUtils$.MODULE$.snakeCaseToCamelCase$default$2()));
    }

    public static final /* synthetic */ long $anonfun$parseUint32$1(String value$2, BigInt intVal) {
        if (intVal.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || intVal.$greater((Object)BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL))) {
            throw new JsonFormatException(new StringBuilder(27).append("Out of range uint32 value: ").append(value$2).toString());
        }
        return intVal.intValue();
    }

    public static final /* synthetic */ long $anonfun$parseUint64$1(String value$3, BigInt intVal) {
        if (intVal.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || intVal.$greater((Object)MODULE$.MAX_UINT64())) {
            throw new JsonFormatException(new StringBuilder(27).append("Out of range uint64 value: ").append(value$3).toString());
        }
        return intVal.longValue();
    }

    private JsonFormat$() {
        MODULE$ = this;
        this.DefaultRegistry = new FormatRegistry(FormatRegistry$.MODULE$.apply$default$1(), FormatRegistry$.MODULE$.apply$default$2(), FormatRegistry$.MODULE$.apply$default$3()).registerWriter((Function1 & java.io.Serializable & Serializable)d -> new JsonAST.JString(Durations$.MODULE$.writeDuration((Duration)d)), (Function1 & java.io.Serializable & Serializable)jv -> {
            JsonAST.JValue jValue = jv;
            if (!(jValue instanceof JsonAST.JString)) {
                throw new JsonFormatException("Expected a string.");
            }
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String str = jString.s();
            Duration duration = Durations$.MODULE$.parseDuration(str);
            return duration;
        }, ClassTag$.MODULE$.apply(Duration.class)).registerWriter((Function1 & java.io.Serializable & Serializable)t -> new JsonAST.JString(Timestamps$.MODULE$.writeTimestamp((Timestamp)t)), (Function1 & java.io.Serializable & Serializable)jv -> {
            JsonAST.JValue jValue = jv;
            if (!(jValue instanceof JsonAST.JString)) {
                throw new JsonFormatException("Expected a string.");
            }
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String str = jString.s();
            Timestamp timestamp = Timestamps$.MODULE$.parseTimestamp(str);
            return timestamp;
        }, ClassTag$.MODULE$.apply(Timestamp.class)).registerMessageFormatter(this.primitiveWrapperWriter(DoubleValue$.MODULE$.messageCompanion()), this.primitiveWrapperParser(DoubleValue$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(DoubleValue.class)).registerMessageFormatter(this.primitiveWrapperWriter(FloatValue$.MODULE$.messageCompanion()), this.primitiveWrapperParser(FloatValue$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(FloatValue.class)).registerMessageFormatter(this.primitiveWrapperWriter(Int32Value$.MODULE$.messageCompanion()), this.primitiveWrapperParser(Int32Value$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(Int32Value.class)).registerMessageFormatter(this.primitiveWrapperWriter(Int64Value$.MODULE$.messageCompanion()), this.primitiveWrapperParser(Int64Value$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(Int64Value.class)).registerMessageFormatter(this.primitiveWrapperWriter(UInt32Value$.MODULE$.messageCompanion()), this.primitiveWrapperParser(UInt32Value$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(UInt32Value.class)).registerMessageFormatter(this.primitiveWrapperWriter(UInt64Value$.MODULE$.messageCompanion()), this.primitiveWrapperParser(UInt64Value$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(UInt64Value.class)).registerMessageFormatter(this.primitiveWrapperWriter(BoolValue$.MODULE$.messageCompanion()), this.primitiveWrapperParser(BoolValue$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(BoolValue.class)).registerMessageFormatter(this.primitiveWrapperWriter(BytesValue$.MODULE$.messageCompanion()), this.primitiveWrapperParser(BytesValue$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(BytesValue.class)).registerMessageFormatter(this.primitiveWrapperWriter(StringValue$.MODULE$.messageCompanion()), this.primitiveWrapperParser(StringValue$.MODULE$.messageCompanion()), ClassTag$.MODULE$.apply(StringValue.class)).registerEnumFormatter((Function2<Printer, EnumValueDescriptor, JsonAST.JValue>)(Function2 & java.io.Serializable & Serializable)(x$8, x$9) -> JsonAST.JNull$.MODULE$, (Function2<Parser, JsonAST.JValue, EnumValueDescriptor>)(Function2 & java.io.Serializable & Serializable)(parser, value) -> {
            JsonAST.JValue jValue = value;
            EnumValueDescriptor enumValueDescriptor = JsonAST.JNull$.MODULE$.equals(jValue) ? NullValue.NULL_VALUE$.MODULE$.scalaValueDescriptor() : parser.defaultEnumParser(NullValue$.MODULE$.scalaDescriptor(), (JsonAST.JValue)value);
            return enumValueDescriptor;
        }, NullValue$.MODULE$.enumCompanion()).registerWriter((Function1 & java.io.Serializable & Serializable)v -> StructFormat$.MODULE$.structValueWriter((Value)v), (Function1 & java.io.Serializable & Serializable)v -> StructFormat$.MODULE$.structValueParser((JsonAST.JValue)v), ClassTag$.MODULE$.apply(Value.class)).registerWriter((Function1 & java.io.Serializable & Serializable)v -> StructFormat$.MODULE$.structWriter((Struct)v), (Function1 & java.io.Serializable & Serializable)v -> StructFormat$.MODULE$.structParser((JsonAST.JValue)v), ClassTag$.MODULE$.apply(Struct.class)).registerWriter((Function1 & java.io.Serializable & Serializable)v -> StructFormat$.MODULE$.listValueWriter((ListValue)v), (Function1 & java.io.Serializable & Serializable)v -> StructFormat$.MODULE$.listValueParser((JsonAST.JValue)v), ClassTag$.MODULE$.apply(ListValue.class)).registerMessageFormatter(AnyFormat$.MODULE$.anyWriter(), AnyFormat$.MODULE$.anyParser(), ClassTag$.MODULE$.apply(Any.class));
        this.printer = new Printer(Printer$.MODULE$.$lessinit$greater$default$1(), Printer$.MODULE$.$lessinit$greater$default$2(), Printer$.MODULE$.$lessinit$greater$default$3(), Printer$.MODULE$.$lessinit$greater$default$4(), Printer$.MODULE$.$lessinit$greater$default$5(), Printer$.MODULE$.$lessinit$greater$default$6());
        this.parser = new Parser(Parser$.MODULE$.$lessinit$greater$default$1(), Parser$.MODULE$.$lessinit$greater$default$2(), Parser$.MODULE$.$lessinit$greater$default$3());
        this.MAX_UINT64 = package$.MODULE$.BigInt().apply("FFFFFFFFFFFFFFFF", 16);
    }
}

