/*
 * Decompiled with CFR 0.152.
 */
package scalapb.json4s;

import com.google.protobuf.duration.Duration;
import com.google.protobuf.duration.Duration$;
import java.io.Serializable;
import java.text.ParseException;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scalapb.json4s.Timestamps$;

public final class Durations$
implements Serializable {
    private static final long DURATION_SECONDS_MIN;
    private static final long DURATION_SECONDS_MAX;
    public static final Durations$ MODULE$;

    private Durations$() {
    }

    static {
        MODULE$ = new Durations$();
        DURATION_SECONDS_MIN = -315576000000L;
        DURATION_SECONDS_MAX = 315576000000L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Durations$.class);
    }

    public long DURATION_SECONDS_MIN() {
        return DURATION_SECONDS_MIN;
    }

    public long DURATION_SECONDS_MAX() {
        return DURATION_SECONDS_MAX;
    }

    public void checkValid(Duration duration) {
        boolean secondsInRange = duration.seconds() >= this.DURATION_SECONDS_MIN() && duration.seconds() <= this.DURATION_SECONDS_MAX();
        boolean nanosInRange = (long)duration.nanos() >= -999999999L && duration.nanos() <= Timestamps$.MODULE$.NANOS_PER_SECOND();
        boolean sameSign = duration.seconds() >= 0L && duration.nanos() >= 0 || duration.seconds() <= 0L && duration.nanos() <= 0;
        Predef$.MODULE$.require(secondsInRange && nanosInRange && sameSign, this::checkValid$$anonfun$1);
    }

    public String writeDuration(Duration duration) {
        Tuple2.mcJI.sp sp2;
        this.checkValid(duration);
        StringBuilder result = new StringBuilder();
        if (duration.seconds() < 0L || duration.nanos() < 0) {
            result.append("-");
            sp2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(-duration.seconds())), (Object)BoxesRunTime.boxToInteger((int)(-duration.nanos())));
        } else {
            sp2 = new Tuple2.mcJI.sp(duration.seconds(), duration.nanos());
        }
        Tuple2.mcJI.sp sp3 = sp2;
        long seconds = sp3._1$mcJ$sp();
        int nanos = sp3._2$mcI$sp();
        result.append(seconds);
        if (nanos != 0) {
            result.append(".");
            result.append(Timestamps$.MODULE$.formatNanos(nanos));
        }
        result.append("s");
        return result.result();
    }

    public int parseNanos(String value) {
        String h = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(value), 9);
        if (!StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(h), (Function1 & Serializable)_$1 -> this.parseNanos$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)))) {
            throw new ParseException("Invalid nanoseconds.", 0);
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(h), 9, '0')));
    }

    public Duration parseDuration(String value) {
        int nanos;
        if (!value.endsWith("s")) {
            throw new ParseException(new java.lang.StringBuilder(25).append("Invalid duration string: ").append(value).toString(), 0);
        }
        Tuple2 tuple2 = value.startsWith("-") ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)value.substring(1, value.length() - 1)) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)value.substring(0, value.length() - 1));
        boolean negative = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        String number = (String)tuple2._2();
        int pointPosition = number.indexOf(46);
        Tuple2 tuple22 = pointPosition != -1 ? Tuple2$.MODULE$.apply((Object)number.substring(0, pointPosition), (Object)number.substring(pointPosition + 1)) : Tuple2$.MODULE$.apply((Object)number, (Object)"");
        String secondsStr = (String)tuple22._1();
        String nanosStr = (String)tuple22._2();
        long seconds = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(secondsStr));
        int n = nanos = nanosStr.isEmpty() ? 0 : this.parseNanos(nanosStr);
        if (seconds < 0L) {
            throw new ParseException(new java.lang.StringBuilder(25).append("Invalid duration string: ").append(value).toString(), 0);
        }
        Duration result = Duration$.MODULE$.apply(negative ? -seconds : seconds, negative ? -nanos : nanos, Duration$.MODULE$.$lessinit$greater$default$3());
        this.checkValid(result);
        return result;
    }

    private final Object checkValid$$anonfun$1() {
        return "Duration is not valid.";
    }

    private final /* synthetic */ boolean parseNanos$$anonfun$1(char _$1) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$1));
    }
}

