/*
 * Decompiled with CFR 0.152.
 */
package scalapb.json4s;

import com.google.protobuf.TextFormat;
import com.google.protobuf.timestamp.Timestamp;
import com.google.protobuf.timestamp.Timestamp$;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scalapb.json4s.Durations$;

public final class Timestamps$
implements Serializable {
    private static final long TIMESTAMP_SECONDS_MIN;
    private static final long TIMESTAMP_SECONDS_MAX;
    private static final int MILLIS_PER_SECOND;
    private static final int MICROS_PER_SECOND;
    private static final int NANOS_PER_SECOND;
    private static final int NANOS_PER_MILLISECOND;
    private static final int NANOS_PER_MICROSECOND;
    private static final ThreadLocal<SimpleDateFormat> timestampFormat;
    public static final Timestamps$ MODULE$;

    private Timestamps$() {
    }

    static {
        MODULE$ = new Timestamps$();
        TIMESTAMP_SECONDS_MIN = -62135596800L;
        TIMESTAMP_SECONDS_MAX = 253402300799L;
        MILLIS_PER_SECOND = 1000;
        MICROS_PER_SECOND = 1000000;
        NANOS_PER_SECOND = 1000000000;
        NANOS_PER_MILLISECOND = 1000000;
        NANOS_PER_MICROSECOND = 1000;
        timestampFormat = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                calendar.setGregorianChange(new Date(Long.MIN_VALUE));
                sdf.setCalendar(calendar);
                return sdf;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Timestamps$.class);
    }

    public long TIMESTAMP_SECONDS_MIN() {
        return TIMESTAMP_SECONDS_MIN;
    }

    public long TIMESTAMP_SECONDS_MAX() {
        return TIMESTAMP_SECONDS_MAX;
    }

    public int MILLIS_PER_SECOND() {
        return MILLIS_PER_SECOND;
    }

    public int MICROS_PER_SECOND() {
        return MICROS_PER_SECOND;
    }

    public int NANOS_PER_SECOND() {
        return NANOS_PER_SECOND;
    }

    public int NANOS_PER_MILLISECOND() {
        return NANOS_PER_MILLISECOND;
    }

    public int NANOS_PER_MICROSECOND() {
        return NANOS_PER_MICROSECOND;
    }

    public boolean isValid(Timestamp ts) {
        return ts.seconds() >= this.TIMESTAMP_SECONDS_MIN() && ts.seconds() <= this.TIMESTAMP_SECONDS_MAX() && ts.nanos() >= 0 && ts.nanos() < this.NANOS_PER_SECOND();
    }

    public Timestamp checkValid(Timestamp ts) {
        Predef$.MODULE$.require(this.isValid(ts), this::checkValid$$anonfun$1);
        return ts;
    }

    public String formatNanos(int nanos) {
        if (nanos % this.NANOS_PER_MILLISECOND() == 0) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%1$03d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MILLISECOND()))}));
        }
        if (nanos % this.NANOS_PER_MICROSECOND() == 0) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%1$06d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / this.NANOS_PER_MICROSECOND()))}));
        }
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%1$09d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nanos)}));
    }

    public String writeTimestamp(Timestamp ts) {
        this.checkValid(ts);
        scala.collection.mutable.StringBuilder result = new scala.collection.mutable.StringBuilder();
        Date date = new Date(ts.seconds() * (long)this.MILLIS_PER_SECOND());
        result.append(((DateFormat)timestampFormat.get()).format(date));
        if (ts.nanos() != 0) {
            result.append(".");
            result.append(this.formatNanos(ts.nanos()));
        }
        result.append("Z");
        return result.toString();
    }

    public long parseTimezoneOffset(String s) {
        char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0);
        switch (c) {
            case 'Z': {
                if (s.length() != 1) {
                    throw new TextFormat.ParseException(new StringBuilder(52).append("Failed to parse timestamp: invalid trailing data: '").append(s).append("'").toString());
                }
                return 0L;
            }
            case '+': 
            case '-': {
                int pos = s.indexOf(58);
                if (pos == -1) {
                    throw new TextFormat.ParseException(new StringBuilder(51).append("Failed to parse timestamp: invalid offset value: '").append(s).append("'").toString());
                }
                String hours = s.substring(1, pos);
                String minutes = s.substring(pos + 1);
                long r = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(hours)) * 3600L + StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(minutes)) * 60L;
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0) == '-') {
                    return -r;
                }
                return r;
            }
        }
        throw new TextFormat.ParseException("Failed to parse timestamp.");
    }

    public Timestamp parseTimestamp(String value) {
        int n;
        int dayOffset = value.indexOf(84);
        if (dayOffset == -1) {
            throw new TextFormat.ParseException("Failed to parse timestamp.");
        }
        int zIndex = value.indexOf(90, dayOffset);
        if (zIndex != -1) {
            n = zIndex;
        } else {
            int pIndex = value.indexOf(43, dayOffset);
            if (pIndex != -1) {
                n = pIndex;
            } else {
                int mIndex = value.indexOf(45, dayOffset);
                if (mIndex != -1) {
                    n = mIndex;
                } else {
                    throw new TextFormat.ParseException("Failed to parse timestamp: missing valid timezone offset.");
                }
            }
        }
        int timezoneOffsetPosition = n;
        long timezoneOffset = this.parseTimezoneOffset(value.substring(timezoneOffsetPosition));
        String timeValue = value.substring(0, timezoneOffsetPosition);
        int pointPosition = timeValue.indexOf(46);
        Tuple2 tuple2 = pointPosition == -1 ? Tuple2$.MODULE$.apply((Object)timeValue, (Object)"") : Tuple2$.MODULE$.apply((Object)timeValue.substring(0, pointPosition), (Object)timeValue.substring(pointPosition + 1));
        String secondValue = (String)tuple2._1();
        String nanoValue = (String)tuple2._2();
        Date date = ((DateFormat)timestampFormat.get()).parse(secondValue);
        long seconds = date.getTime() / (long)this.MILLIS_PER_SECOND() - timezoneOffset;
        int nanos = nanoValue.isEmpty() ? 0 : Durations$.MODULE$.parseNanos(nanoValue);
        return this.normalizedTimestamp(seconds, nanos);
    }

    public Timestamp normalizedTimestamp(long seconds, int nanos) {
        Tuple2.mcJI.sp sp2 = nanos <= -this.NANOS_PER_SECOND() || nanos >= this.NANOS_PER_SECOND() ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(seconds + (long)(nanos / this.NANOS_PER_SECOND()))), (Object)BoxesRunTime.boxToInteger((int)(nanos % this.NANOS_PER_SECOND()))) : new Tuple2.mcJI.sp(seconds, nanos);
        long ns = sp2._1$mcJ$sp();
        int nn = sp2._2$mcI$sp();
        Tuple2.mcJI.sp sp3 = nn < 0 ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(seconds - 1L)), (Object)BoxesRunTime.boxToInteger((int)(nanos + this.NANOS_PER_SECOND()))) : new Tuple2.mcJI.sp(ns, nn);
        long ns2 = sp3._1$mcJ$sp();
        int nn2 = sp3._2$mcI$sp();
        return this.checkValid(Timestamp$.MODULE$.apply(ns2, nn2, Timestamp$.MODULE$.$lessinit$greater$default$3()));
    }

    private final Object checkValid$$anonfun$1() {
        return "Timestamp is not valid.";
    }
}

