// Generated by the Scala Plugin for the Protocol Buffer Compiler.
// Do not edit!

package com.google.protobuf.compiler.plugin
import _root_.scalapb.internal.compat.JavaConverters._

/** The plugin writes an encoded CodeGeneratorResponse to stdout.
  *
  * @param error
  *   Error message.  If non-empty, code generation failed.  The plugin process
  *   should exit with status code zero even if it reports an error in this way.
  *  
  *   This should be used to indicate errors in .proto files which prevent the
  *   code generator from generating correct code.  Errors which indicate a
  *   problem in protoc itself -- such as the input CodeGeneratorRequest being
  *   unparseable -- should be reported by writing a message to stderr and
  *   exiting with a non-zero status code.
  * @param supportedFeatures
  *   A bitmask of supported features that the code generator supports.
  *   This is a bitwise "or" of values from the Feature enum.
  * @param minimumEdition
  *   The minimum edition this plugin supports.  This will be treated as an
  *   Edition enum, but we want to allow unknown values.  It should be specified
  *   according the edition enum value, *not* the edition number.  Only takes
  *   effect for plugins that have FEATURE_SUPPORTS_EDITIONS set.
  * @param maximumEdition
  *   The maximum edition this plugin supports.  This will be treated as an
  *   Edition enum, but we want to allow unknown values.  It should be specified
  *   according the edition enum value, *not* the edition number.  Only takes
  *   effect for plugins that have FEATURE_SUPPORTS_EDITIONS set.
  */
@SerialVersionUID(0L)
final case class CodeGeneratorResponse(
    error: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None,
    supportedFeatures: _root_.scala.Option[_root_.scala.Long] = _root_.scala.None,
    minimumEdition: _root_.scala.Option[_root_.scala.Int] = _root_.scala.None,
    maximumEdition: _root_.scala.Option[_root_.scala.Int] = _root_.scala.None,
    file: _root_.scala.Seq[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File] = _root_.scala.Vector.empty,
    unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
    ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[CodeGeneratorResponse] {
    @transient
    private[this] var __serializedSizeMemoized: _root_.scala.Int = 0
    private[this] def __computeSerializedSize(): _root_.scala.Int = {
      var __size = 0
      if (error.isDefined) {
        val __value = error.get
        __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
      };
      if (supportedFeatures.isDefined) {
        val __value = supportedFeatures.get
        __size += _root_.com.google.protobuf.CodedOutputStream.computeUInt64Size(2, __value)
      };
      if (minimumEdition.isDefined) {
        val __value = minimumEdition.get
        __size += _root_.com.google.protobuf.CodedOutputStream.computeInt32Size(3, __value)
      };
      if (maximumEdition.isDefined) {
        val __value = maximumEdition.get
        __size += _root_.com.google.protobuf.CodedOutputStream.computeInt32Size(4, __value)
      };
      file.foreach { __item =>
        val __value = __item
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      }
      __size += unknownFields.serializedSize
      __size
    }
    override def serializedSize: _root_.scala.Int = {
      var __size = __serializedSizeMemoized
      if (__size == 0) {
        __size = __computeSerializedSize() + 1
        __serializedSizeMemoized = __size
      }
      __size - 1
      
    }
    def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
      error.foreach { __v =>
        val __m = __v
        _output__.writeString(1, __m)
      };
      supportedFeatures.foreach { __v =>
        val __m = __v
        _output__.writeUInt64(2, __m)
      };
      minimumEdition.foreach { __v =>
        val __m = __v
        _output__.writeInt32(3, __m)
      };
      maximumEdition.foreach { __v =>
        val __m = __v
        _output__.writeInt32(4, __m)
      };
      file.foreach { __v =>
        val __m = __v
        _output__.writeTag(15, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      unknownFields.writeTo(_output__)
    }
    def getError: _root_.scala.Predef.String = error.getOrElse("")
    def clearError: CodeGeneratorResponse = copy(error = _root_.scala.None)
    def withError(__v: _root_.scala.Predef.String): CodeGeneratorResponse = copy(error = _root_.scala.Option(__v))
    def getSupportedFeatures: _root_.scala.Long = supportedFeatures.getOrElse(0L)
    def clearSupportedFeatures: CodeGeneratorResponse = copy(supportedFeatures = _root_.scala.None)
    def withSupportedFeatures(__v: _root_.scala.Long): CodeGeneratorResponse = copy(supportedFeatures = _root_.scala.Option(__v))
    def getMinimumEdition: _root_.scala.Int = minimumEdition.getOrElse(0)
    def clearMinimumEdition: CodeGeneratorResponse = copy(minimumEdition = _root_.scala.None)
    def withMinimumEdition(__v: _root_.scala.Int): CodeGeneratorResponse = copy(minimumEdition = _root_.scala.Option(__v))
    def getMaximumEdition: _root_.scala.Int = maximumEdition.getOrElse(0)
    def clearMaximumEdition: CodeGeneratorResponse = copy(maximumEdition = _root_.scala.None)
    def withMaximumEdition(__v: _root_.scala.Int): CodeGeneratorResponse = copy(maximumEdition = _root_.scala.Option(__v))
    def clearFile = copy(file = _root_.scala.Vector.empty)
    def addFile(__vs: _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File *): CodeGeneratorResponse = addAllFile(__vs)
    def addAllFile(__vs: Iterable[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File]): CodeGeneratorResponse = copy(file = file ++ __vs)
    def withFile(__v: _root_.scala.Seq[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File]): CodeGeneratorResponse = copy(file = __v)
    def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
    def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
    def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
      (__fieldNumber: @_root_.scala.unchecked) match {
        case 1 => error.orNull
        case 2 => supportedFeatures.orNull
        case 3 => minimumEdition.orNull
        case 4 => maximumEdition.orNull
        case 15 => file
      }
    }
    def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
      _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
      (__field.number: @_root_.scala.unchecked) match {
        case 1 => error.map(_root_.scalapb.descriptors.PString(_)).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 2 => supportedFeatures.map(_root_.scalapb.descriptors.PLong(_)).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 3 => minimumEdition.map(_root_.scalapb.descriptors.PInt(_)).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 4 => maximumEdition.map(_root_.scalapb.descriptors.PInt(_)).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 15 => _root_.scalapb.descriptors.PRepeated(file.iterator.map(_.toPMessage).toVector)
      }
    }
    def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
    def companion: _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.type = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse
    // @@protoc_insertion_point(GeneratedMessage[google.protobuf.compiler.CodeGeneratorResponse])
}

object CodeGeneratorResponse extends scalapb.GeneratedMessageCompanion[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse] with scalapb.JavaProtoSupport[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse, com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse] {
  implicit def messageCompanion: scalapb.GeneratedMessageCompanion[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse] with scalapb.JavaProtoSupport[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse, com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse] = this
  def toJavaProto(scalaPbSource: _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse): com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse = {
    val javaPbOut = com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.newBuilder
    scalaPbSource.error.foreach(javaPbOut.setError)
    scalaPbSource.supportedFeatures.foreach(javaPbOut.setSupportedFeatures)
    scalaPbSource.minimumEdition.foreach(javaPbOut.setMinimumEdition)
    scalaPbSource.maximumEdition.foreach(javaPbOut.setMaximumEdition)
    javaPbOut.addAllFile(_root_.scalapb.internal.compat.toIterable(scalaPbSource.file.iterator.map(_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File.toJavaProto(_))).asJava)
    javaPbOut.build
  }
  def fromJavaProto(javaPbSource: com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse): _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse(
    error = if (javaPbSource.hasError) Some(javaPbSource.getError) else _root_.scala.None,
    supportedFeatures = if (javaPbSource.hasSupportedFeatures) Some(javaPbSource.getSupportedFeatures.longValue) else _root_.scala.None,
    minimumEdition = if (javaPbSource.hasMinimumEdition) Some(javaPbSource.getMinimumEdition.intValue) else _root_.scala.None,
    maximumEdition = if (javaPbSource.hasMaximumEdition) Some(javaPbSource.getMaximumEdition.intValue) else _root_.scala.None,
    file = javaPbSource.getFileList.asScala.iterator.map(_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File.fromJavaProto(_)).toSeq
  )
  def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse = {
    var __error: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None
    var __supportedFeatures: _root_.scala.Option[_root_.scala.Long] = _root_.scala.None
    var __minimumEdition: _root_.scala.Option[_root_.scala.Int] = _root_.scala.None
    var __maximumEdition: _root_.scala.Option[_root_.scala.Int] = _root_.scala.None
    val __file: _root_.scala.collection.immutable.VectorBuilder[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File] = new _root_.scala.collection.immutable.VectorBuilder[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File]
    var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
    var _done__ = false
    while (!_done__) {
      val _tag__ = _input__.readTag()
      _tag__ match {
        case 0 => _done__ = true
        case 10 =>
          __error = _root_.scala.Option(_input__.readStringRequireUtf8())
        case 16 =>
          __supportedFeatures = _root_.scala.Option(_input__.readUInt64())
        case 24 =>
          __minimumEdition = _root_.scala.Option(_input__.readInt32())
        case 32 =>
          __maximumEdition = _root_.scala.Option(_input__.readInt32())
        case 122 =>
          __file += _root_.scalapb.LiteParser.readMessage[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File](_input__)
        case tag =>
          if (_unknownFields__ == null) {
            _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
          }
          val _ = _unknownFields__.parseField(tag, _input__)
      }
    }
    _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse(
        error = __error,
        supportedFeatures = __supportedFeatures,
        minimumEdition = __minimumEdition,
        maximumEdition = __maximumEdition,
        file = __file.result(),
        unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
    )
  }
  implicit def messageReads: _root_.scalapb.descriptors.Reads[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse] = _root_.scalapb.descriptors.Reads{
    case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
      _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
      _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse(
        error = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).flatMap(_.as[_root_.scala.Option[_root_.scala.Predef.String]]),
        supportedFeatures = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).flatMap(_.as[_root_.scala.Option[_root_.scala.Long]]),
        minimumEdition = __fieldsMap.get(scalaDescriptor.findFieldByNumber(3).get).flatMap(_.as[_root_.scala.Option[_root_.scala.Int]]),
        maximumEdition = __fieldsMap.get(scalaDescriptor.findFieldByNumber(4).get).flatMap(_.as[_root_.scala.Option[_root_.scala.Int]]),
        file = __fieldsMap.get(scalaDescriptor.findFieldByNumber(15).get).map(_.as[_root_.scala.Seq[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File]]).getOrElse(_root_.scala.Seq.empty)
      )
    case _ => throw new RuntimeException("Expected PMessage")
  }
  def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = _root_.com.google.protobuf.compiler.plugin.PluginProto.javaDescriptor.getMessageTypes().get(2)
  def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = _root_.com.google.protobuf.compiler.plugin.PluginProto.scalaDescriptor.messages(2)
  def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[_] = {
    var __out: _root_.scalapb.GeneratedMessageCompanion[_] = null
    (__number: @_root_.scala.unchecked) match {
      case 15 => __out = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File
    }
    __out
  }
  lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[_ <: _root_.scalapb.GeneratedMessage]] =
    Seq[_root_.scalapb.GeneratedMessageCompanion[_ <: _root_.scalapb.GeneratedMessage]](
      _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File
    )
  def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[_] = throw new MatchError(__fieldNumber)
  lazy val defaultInstance = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse(
    error = _root_.scala.None,
    supportedFeatures = _root_.scala.None,
    minimumEdition = _root_.scala.None,
    maximumEdition = _root_.scala.None,
    file = _root_.scala.Vector.empty
  )
  /** Sync with code_generator.h.
    */
  sealed abstract class Feature(val value: _root_.scala.Int) extends _root_.scalapb.GeneratedEnum {
    type EnumType = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.Feature
    type RecognizedType = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.Feature.Recognized
    def isFeatureNone: _root_.scala.Boolean = false
    def isFeatureProto3Optional: _root_.scala.Boolean = false
    def isFeatureSupportsEditions: _root_.scala.Boolean = false
    def companion: _root_.scalapb.GeneratedEnumCompanion[Feature] = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.Feature
    final def asRecognized: _root_.scala.Option[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.Feature.Recognized] = if (isUnrecognized) _root_.scala.None else _root_.scala.Some(this.asInstanceOf[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.Feature.Recognized])
  }
  
  object Feature extends _root_.scalapb.GeneratedEnumCompanion[Feature] {
    sealed trait Recognized extends Feature
    implicit def enumCompanion: _root_.scalapb.GeneratedEnumCompanion[Feature] = this
    
    @SerialVersionUID(0L)
    case object FEATURE_NONE extends Feature(0) with Feature.Recognized {
      val index = 0
      val name = "FEATURE_NONE"
      override def isFeatureNone: _root_.scala.Boolean = true
    }
    
    @SerialVersionUID(0L)
    case object FEATURE_PROTO3_OPTIONAL extends Feature(1) with Feature.Recognized {
      val index = 1
      val name = "FEATURE_PROTO3_OPTIONAL"
      override def isFeatureProto3Optional: _root_.scala.Boolean = true
    }
    
    @SerialVersionUID(0L)
    case object FEATURE_SUPPORTS_EDITIONS extends Feature(2) with Feature.Recognized {
      val index = 2
      val name = "FEATURE_SUPPORTS_EDITIONS"
      override def isFeatureSupportsEditions: _root_.scala.Boolean = true
    }
    
    @SerialVersionUID(0L)
    final case class Unrecognized(unrecognizedValue: _root_.scala.Int) extends Feature(unrecognizedValue) with _root_.scalapb.UnrecognizedEnum
    lazy val values: scala.collection.immutable.Seq[ValueType] = scala.collection.immutable.Seq(FEATURE_NONE, FEATURE_PROTO3_OPTIONAL, FEATURE_SUPPORTS_EDITIONS)
    def fromValue(__value: _root_.scala.Int): Feature = __value match {
      case 0 => FEATURE_NONE
      case 1 => FEATURE_PROTO3_OPTIONAL
      case 2 => FEATURE_SUPPORTS_EDITIONS
      case __other => Unrecognized(__other)
    }
    def javaDescriptor: _root_.com.google.protobuf.Descriptors.EnumDescriptor = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.javaDescriptor.getEnumTypes().get(0)
    def scalaDescriptor: _root_.scalapb.descriptors.EnumDescriptor = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.scalaDescriptor.enums(0)
    def fromJavaValue(pbJavaSource: com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.Feature): Feature = fromValue(pbJavaSource.getNumber)
    def toJavaValue(pbScalaSource: Feature): com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.Feature = {
      _root_.scala.Predef.require(!pbScalaSource.isUnrecognized, "Unrecognized enum values can not be converted to Java")
      com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.Feature.forNumber(pbScalaSource.value)
    }
  }
  /** Represents a single generated file.
    *
    * @param name
    *   The file name, relative to the output directory.  The name must not
    *   contain "." or ".." components and must be relative, not be absolute (so,
    *   the file cannot lie outside the output directory).  "/" must be used as
    *   the path separator, not "&92;".
    *  
    *   If the name is omitted, the content will be appended to the previous
    *   file.  This allows the generator to break large files into small chunks,
    *   and allows the generated text to be streamed back to protoc so that large
    *   files need not reside completely in memory at one time.  Note that as of
    *   this writing protoc does not optimize for this -- it will read the entire
    *   CodeGeneratorResponse before writing files to disk.
    * @param insertionPoint
    *   If non-empty, indicates that the named file should already exist, and the
    *   content here is to be inserted into that file at a defined insertion
    *   point.  This feature allows a code generator to extend the output
    *   produced by another code generator.  The original generator may provide
    *   insertion points by placing special annotations in the file that look
    *   like:
    *     &#64;&#64;protoc_insertion_point(NAME)
    *   The annotation can have arbitrary text before and after it on the line,
    *   which allows it to be placed in a comment.  NAME should be replaced with
    *   an identifier naming the point -- this is what other generators will use
    *   as the insertion_point.  Code inserted at this point will be placed
    *   immediately above the line containing the insertion point (thus multiple
    *   insertions to the same point will come out in the order they were added).
    *   The double-&#64; is intended to make it unlikely that the generated code
    *   could contain things that look like insertion points by accident.
    *  
    *   For example, the C++ code generator places the following line in the
    *   .pb.h files that it generates:
    *     // &#64;&#64;protoc_insertion_point(namespace_scope)
    *   This line appears within the scope of the file's package namespace, but
    *   outside of any particular class.  Another plugin can then specify the
    *   insertion_point "namespace_scope" to generate additional classes or
    *   other declarations that should be placed in this scope.
    *  
    *   Note that if the line containing the insertion point begins with
    *   whitespace, the same whitespace will be added to every line of the
    *   inserted text.  This is useful for languages like Python, where
    *   indentation matters.  In these languages, the insertion point comment
    *   should be indented the same amount as any inserted code will need to be
    *   in order to work correctly in that context.
    *  
    *   The code generator that generates the initial file and the one which
    *   inserts into it must both run as part of a single invocation of protoc.
    *   Code generators are executed in the order in which they appear on the
    *   command line.
    *  
    *   If |insertion_point| is present, |name| must also be present.
    * @param content
    *   The file contents.
    * @param generatedCodeInfo
    *   Information describing the file content being inserted. If an insertion
    *   point is used, this information will be appropriately offset and inserted
    *   into the code generation metadata for the generated files.
    */
  @SerialVersionUID(0L)
  final case class File(
      name: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None,
      insertionPoint: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None,
      content: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None,
      generatedCodeInfo: _root_.scala.Option[_root_.com.google.protobuf.descriptor.GeneratedCodeInfo] = _root_.scala.None,
      unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
      ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[File] {
      @transient
      private[this] var __serializedSizeMemoized: _root_.scala.Int = 0
      private[this] def __computeSerializedSize(): _root_.scala.Int = {
        var __size = 0
        if (name.isDefined) {
          val __value = name.get
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(1, __value)
        };
        if (insertionPoint.isDefined) {
          val __value = insertionPoint.get
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(2, __value)
        };
        if (content.isDefined) {
          val __value = content.get
          __size += _root_.com.google.protobuf.CodedOutputStream.computeStringSize(15, __value)
        };
        if (generatedCodeInfo.isDefined) {
          val __value = generatedCodeInfo.get
          __size += 2 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
        };
        __size += unknownFields.serializedSize
        __size
      }
      override def serializedSize: _root_.scala.Int = {
        var __size = __serializedSizeMemoized
        if (__size == 0) {
          __size = __computeSerializedSize() + 1
          __serializedSizeMemoized = __size
        }
        __size - 1
        
      }
      def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
        name.foreach { __v =>
          val __m = __v
          _output__.writeString(1, __m)
        };
        insertionPoint.foreach { __v =>
          val __m = __v
          _output__.writeString(2, __m)
        };
        content.foreach { __v =>
          val __m = __v
          _output__.writeString(15, __m)
        };
        generatedCodeInfo.foreach { __v =>
          val __m = __v
          _output__.writeTag(16, 2)
          _output__.writeUInt32NoTag(__m.serializedSize)
          __m.writeTo(_output__)
        };
        unknownFields.writeTo(_output__)
      }
      def getName: _root_.scala.Predef.String = name.getOrElse("")
      def clearName: File = copy(name = _root_.scala.None)
      def withName(__v: _root_.scala.Predef.String): File = copy(name = _root_.scala.Option(__v))
      def getInsertionPoint: _root_.scala.Predef.String = insertionPoint.getOrElse("")
      def clearInsertionPoint: File = copy(insertionPoint = _root_.scala.None)
      def withInsertionPoint(__v: _root_.scala.Predef.String): File = copy(insertionPoint = _root_.scala.Option(__v))
      def getContent: _root_.scala.Predef.String = content.getOrElse("")
      def clearContent: File = copy(content = _root_.scala.None)
      def withContent(__v: _root_.scala.Predef.String): File = copy(content = _root_.scala.Option(__v))
      def getGeneratedCodeInfo: _root_.com.google.protobuf.descriptor.GeneratedCodeInfo = generatedCodeInfo.getOrElse(_root_.com.google.protobuf.descriptor.GeneratedCodeInfo.defaultInstance)
      def clearGeneratedCodeInfo: File = copy(generatedCodeInfo = _root_.scala.None)
      def withGeneratedCodeInfo(__v: _root_.com.google.protobuf.descriptor.GeneratedCodeInfo): File = copy(generatedCodeInfo = _root_.scala.Option(__v))
      def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
      def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
      def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
        (__fieldNumber: @_root_.scala.unchecked) match {
          case 1 => name.orNull
          case 2 => insertionPoint.orNull
          case 15 => content.orNull
          case 16 => generatedCodeInfo.orNull
        }
      }
      def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
        _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
        (__field.number: @_root_.scala.unchecked) match {
          case 1 => name.map(_root_.scalapb.descriptors.PString(_)).getOrElse(_root_.scalapb.descriptors.PEmpty)
          case 2 => insertionPoint.map(_root_.scalapb.descriptors.PString(_)).getOrElse(_root_.scalapb.descriptors.PEmpty)
          case 15 => content.map(_root_.scalapb.descriptors.PString(_)).getOrElse(_root_.scalapb.descriptors.PEmpty)
          case 16 => generatedCodeInfo.map(_.toPMessage).getOrElse(_root_.scalapb.descriptors.PEmpty)
        }
      }
      def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
      def companion: _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File.type = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File
      // @@protoc_insertion_point(GeneratedMessage[google.protobuf.compiler.CodeGeneratorResponse.File])
  }
  
  object File extends scalapb.GeneratedMessageCompanion[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File] with scalapb.JavaProtoSupport[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File, com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.File] {
    implicit def messageCompanion: scalapb.GeneratedMessageCompanion[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File] with scalapb.JavaProtoSupport[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File, com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.File] = this
    def toJavaProto(scalaPbSource: _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File): com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.File = {
      val javaPbOut = com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.File.newBuilder
      scalaPbSource.name.foreach(javaPbOut.setName)
      scalaPbSource.insertionPoint.foreach(javaPbOut.setInsertionPoint)
      scalaPbSource.content.foreach(javaPbOut.setContent)
      scalaPbSource.generatedCodeInfo.map(_root_.com.google.protobuf.descriptor.GeneratedCodeInfo.toJavaProto(_)).foreach(javaPbOut.setGeneratedCodeInfo)
      javaPbOut.build
    }
    def fromJavaProto(javaPbSource: com.google.protobuf.compiler.PluginProtos.CodeGeneratorResponse.File): _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File(
      name = if (javaPbSource.hasName) Some(javaPbSource.getName) else _root_.scala.None,
      insertionPoint = if (javaPbSource.hasInsertionPoint) Some(javaPbSource.getInsertionPoint) else _root_.scala.None,
      content = if (javaPbSource.hasContent) Some(javaPbSource.getContent) else _root_.scala.None,
      generatedCodeInfo = if (javaPbSource.hasGeneratedCodeInfo) Some(_root_.com.google.protobuf.descriptor.GeneratedCodeInfo.fromJavaProto(javaPbSource.getGeneratedCodeInfo)) else _root_.scala.None
    )
    def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File = {
      var __name: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None
      var __insertionPoint: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None
      var __content: _root_.scala.Option[_root_.scala.Predef.String] = _root_.scala.None
      var __generatedCodeInfo: _root_.scala.Option[_root_.com.google.protobuf.descriptor.GeneratedCodeInfo] = _root_.scala.None
      var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
      var _done__ = false
      while (!_done__) {
        val _tag__ = _input__.readTag()
        _tag__ match {
          case 0 => _done__ = true
          case 10 =>
            __name = _root_.scala.Option(_input__.readStringRequireUtf8())
          case 18 =>
            __insertionPoint = _root_.scala.Option(_input__.readStringRequireUtf8())
          case 122 =>
            __content = _root_.scala.Option(_input__.readStringRequireUtf8())
          case 130 =>
            __generatedCodeInfo = _root_.scala.Option(__generatedCodeInfo.fold(_root_.scalapb.LiteParser.readMessage[_root_.com.google.protobuf.descriptor.GeneratedCodeInfo](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
          case tag =>
            if (_unknownFields__ == null) {
              _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
            }
            val _ = _unknownFields__.parseField(tag, _input__)
        }
      }
      _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File(
          name = __name,
          insertionPoint = __insertionPoint,
          content = __content,
          generatedCodeInfo = __generatedCodeInfo,
          unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
      )
    }
    implicit def messageReads: _root_.scalapb.descriptors.Reads[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File] = _root_.scalapb.descriptors.Reads{
      case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
        _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
        _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File(
          name = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).flatMap(_.as[_root_.scala.Option[_root_.scala.Predef.String]]),
          insertionPoint = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).flatMap(_.as[_root_.scala.Option[_root_.scala.Predef.String]]),
          content = __fieldsMap.get(scalaDescriptor.findFieldByNumber(15).get).flatMap(_.as[_root_.scala.Option[_root_.scala.Predef.String]]),
          generatedCodeInfo = __fieldsMap.get(scalaDescriptor.findFieldByNumber(16).get).flatMap(_.as[_root_.scala.Option[_root_.com.google.protobuf.descriptor.GeneratedCodeInfo]])
        )
      case _ => throw new RuntimeException("Expected PMessage")
    }
    def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.javaDescriptor.getNestedTypes().get(0)
    def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.scalaDescriptor.nestedMessages(0)
    def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[_] = {
      var __out: _root_.scalapb.GeneratedMessageCompanion[_] = null
      (__number: @_root_.scala.unchecked) match {
        case 16 => __out = _root_.com.google.protobuf.descriptor.GeneratedCodeInfo
      }
      __out
    }
    lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[_ <: _root_.scalapb.GeneratedMessage]] = Seq.empty
    def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[_] = throw new MatchError(__fieldNumber)
    lazy val defaultInstance = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File(
      name = _root_.scala.None,
      insertionPoint = _root_.scala.None,
      content = _root_.scala.None,
      generatedCodeInfo = _root_.scala.None
    )
    implicit class FileLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File]) extends _root_.scalapb.lenses.ObjectLens[UpperPB, _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File](_l) {
      def name: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.getName)((c_, f_) => c_.copy(name = _root_.scala.Option(f_)))
      def optionalName: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.scala.Predef.String]] = field(_.name)((c_, f_) => c_.copy(name = f_))
      def insertionPoint: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.getInsertionPoint)((c_, f_) => c_.copy(insertionPoint = _root_.scala.Option(f_)))
      def optionalInsertionPoint: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.scala.Predef.String]] = field(_.insertionPoint)((c_, f_) => c_.copy(insertionPoint = f_))
      def content: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.getContent)((c_, f_) => c_.copy(content = _root_.scala.Option(f_)))
      def optionalContent: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.scala.Predef.String]] = field(_.content)((c_, f_) => c_.copy(content = f_))
      def generatedCodeInfo: _root_.scalapb.lenses.Lens[UpperPB, _root_.com.google.protobuf.descriptor.GeneratedCodeInfo] = field(_.getGeneratedCodeInfo)((c_, f_) => c_.copy(generatedCodeInfo = _root_.scala.Option(f_)))
      def optionalGeneratedCodeInfo: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.com.google.protobuf.descriptor.GeneratedCodeInfo]] = field(_.generatedCodeInfo)((c_, f_) => c_.copy(generatedCodeInfo = f_))
    }
    final val NAME_FIELD_NUMBER = 1
    final val INSERTION_POINT_FIELD_NUMBER = 2
    final val CONTENT_FIELD_NUMBER = 15
    final val GENERATED_CODE_INFO_FIELD_NUMBER = 16
    def of(
      name: _root_.scala.Option[_root_.scala.Predef.String],
      insertionPoint: _root_.scala.Option[_root_.scala.Predef.String],
      content: _root_.scala.Option[_root_.scala.Predef.String],
      generatedCodeInfo: _root_.scala.Option[_root_.com.google.protobuf.descriptor.GeneratedCodeInfo]
    ): _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File(
      name,
      insertionPoint,
      content,
      generatedCodeInfo
    )
    // @@protoc_insertion_point(GeneratedMessageCompanion[google.protobuf.compiler.CodeGeneratorResponse.File])
  }
  
  implicit class CodeGeneratorResponseLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse]) extends _root_.scalapb.lenses.ObjectLens[UpperPB, _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse](_l) {
    def error: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Predef.String] = field(_.getError)((c_, f_) => c_.copy(error = _root_.scala.Option(f_)))
    def optionalError: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.scala.Predef.String]] = field(_.error)((c_, f_) => c_.copy(error = f_))
    def supportedFeatures: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Long] = field(_.getSupportedFeatures)((c_, f_) => c_.copy(supportedFeatures = _root_.scala.Option(f_)))
    def optionalSupportedFeatures: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.scala.Long]] = field(_.supportedFeatures)((c_, f_) => c_.copy(supportedFeatures = f_))
    def minimumEdition: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Int] = field(_.getMinimumEdition)((c_, f_) => c_.copy(minimumEdition = _root_.scala.Option(f_)))
    def optionalMinimumEdition: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.scala.Int]] = field(_.minimumEdition)((c_, f_) => c_.copy(minimumEdition = f_))
    def maximumEdition: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Int] = field(_.getMaximumEdition)((c_, f_) => c_.copy(maximumEdition = _root_.scala.Option(f_)))
    def optionalMaximumEdition: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[_root_.scala.Int]] = field(_.maximumEdition)((c_, f_) => c_.copy(maximumEdition = f_))
    def file: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Seq[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File]] = field(_.file)((c_, f_) => c_.copy(file = f_))
  }
  final val ERROR_FIELD_NUMBER = 1
  final val SUPPORTED_FEATURES_FIELD_NUMBER = 2
  final val MINIMUM_EDITION_FIELD_NUMBER = 3
  final val MAXIMUM_EDITION_FIELD_NUMBER = 4
  final val FILE_FIELD_NUMBER = 15
  def of(
    error: _root_.scala.Option[_root_.scala.Predef.String],
    supportedFeatures: _root_.scala.Option[_root_.scala.Long],
    minimumEdition: _root_.scala.Option[_root_.scala.Int],
    maximumEdition: _root_.scala.Option[_root_.scala.Int],
    file: _root_.scala.Seq[_root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse.File]
  ): _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse = _root_.com.google.protobuf.compiler.plugin.CodeGeneratorResponse(
    error,
    supportedFeatures,
    minimumEdition,
    maximumEdition,
    file
  )
  // @@protoc_insertion_point(GeneratedMessageCompanion[google.protobuf.compiler.CodeGeneratorResponse])
}
