/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scalapb.GeneratedMessage;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PBoolean$;
import scalapb.descriptors.PByteString;
import scalapb.descriptors.PByteString$;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PDouble$;
import scalapb.descriptors.PEmpty$;
import scalapb.descriptors.PEnum;
import scalapb.descriptors.PEnum$;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PFloat$;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PInt$;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PLong$;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PMessage$;
import scalapb.descriptors.PRepeated;
import scalapb.descriptors.PRepeated$;
import scalapb.descriptors.PString;
import scalapb.descriptors.PString$;
import scalapb.descriptors.PValue;
import scalapb.textformat.NumberUtils$;
import scalapb.textformat.TextFormatUtils$;
import scalapb.textformat.TextGenerator;

public final class Printer$
implements Serializable {
    public static final Printer$ MODULE$ = new Printer$();

    private Printer$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Printer$.class);
    }

    public void print(GeneratedMessage t, TextGenerator out) {
        this.print(t.toPMessage(), out);
    }

    public void print(Map p, TextGenerator out) {
        ((IterableOnceOps)p.toSeq().sortBy((Function1 & Serializable)_$1 -> ((FieldDescriptor)_$1._1()).number(), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FieldDescriptor fd = (FieldDescriptor)tuple2._1();
            PValue value = (PValue)tuple2._2();
            this.printField(fd, value, out);
        });
    }

    public String printToString(GeneratedMessage t, boolean singleLineMode, boolean escapeNonAscii) {
        TextGenerator out = new TextGenerator(singleLineMode, escapeNonAscii);
        this.print(t, out);
        return out.result();
    }

    public void printField(FieldDescriptor fd, PValue value, TextGenerator out) {
        block1: {
            PValue pValue;
            block0: {
                Vector<PValue> vector;
                pValue = value;
                if (!(pValue instanceof PRepeated)) break block0;
                Vector vector2 = PRepeated$.MODULE$.unapply(pValue == null ? null : ((PRepeated)pValue).value());
                Vector<PValue> values = vector = PRepeated$.MODULE$._1$extension(vector2);
                values.foreach((Function1 & Serializable)v -> this.printSingleField(fd, (PValue)v, out));
                break block1;
            }
            if (PEmpty$.MODULE$.equals(pValue)) break block1;
            this.printSingleField(fd, value, out);
        }
    }

    public TextGenerator printSingleField(FieldDescriptor fd, PValue value, TextGenerator out) {
        TextGenerator textGenerator;
        out.add(fd.name());
        PValue pValue = value;
        if (pValue instanceof PMessage) {
            Map map = PMessage$.MODULE$.unapply(pValue == null ? null : ((PMessage)pValue).value());
            Map<FieldDescriptor, PValue> map2 = PMessage$.MODULE$._1$extension(map);
            out.addNewLine(" {").indent();
            this.printFieldValue(fd, value, out);
            textGenerator = out.outdent().addNewLine("}");
        } else {
            out.add(": ");
            this.printFieldValue(fd, value, out);
            textGenerator = out.addNewLine("");
        }
        return textGenerator;
    }

    public void printFieldValue(FieldDescriptor fd, PValue value, TextGenerator out) {
        TextGenerator textGenerator;
        PValue pValue = value;
        if (pValue instanceof PInt) {
            int n;
            int n2 = PInt$.MODULE$.unapply(pValue == null ? BoxesRunTime.unboxToInt(null) : ((PInt)pValue).value());
            int v = n = PInt$.MODULE$._1$extension(n2);
            textGenerator = fd.protoType().isTypeUint32() || fd.protoType().isTypeFixed32() ? out.add(TextFormatUtils$.MODULE$.unsignedToString(v)) : out.add(BoxesRunTime.boxToInteger((int)v).toString());
        } else if (pValue instanceof PLong) {
            long l;
            long l2 = PLong$.MODULE$.unapply(pValue == null ? BoxesRunTime.unboxToLong(null) : ((PLong)pValue).value());
            long v = l = PLong$.MODULE$._1$extension(l2);
            textGenerator = fd.protoType().isTypeUint64() || fd.protoType().isTypeFixed64() ? out.add(TextFormatUtils$.MODULE$.unsignedToString(v)) : out.add(BoxesRunTime.boxToLong((long)v).toString());
        } else if (pValue instanceof PBoolean) {
            boolean bl;
            boolean bl2 = PBoolean$.MODULE$.unapply(pValue == null ? BoxesRunTime.unboxToBoolean(null) : ((PBoolean)pValue).value());
            boolean v = bl = PBoolean$.MODULE$._1$extension(bl2);
            textGenerator = out.add(BoxesRunTime.boxToBoolean((boolean)v).toString());
        } else if (pValue instanceof PFloat) {
            float f;
            float f2 = PFloat$.MODULE$.unapply(pValue == null ? BoxesRunTime.unboxToFloat(null) : ((PFloat)pValue).value());
            float v = f = PFloat$.MODULE$._1$extension(f2);
            textGenerator = out.add(NumberUtils$.MODULE$.floatToString(v));
        } else if (pValue instanceof PDouble) {
            double d;
            double d2 = PDouble$.MODULE$.unapply(pValue == null ? BoxesRunTime.unboxToDouble(null) : ((PDouble)pValue).value());
            double v = d = PDouble$.MODULE$._1$extension(d2);
            textGenerator = out.add(NumberUtils$.MODULE$.doubleToString(v));
        } else if (pValue instanceof PEnum) {
            EnumValueDescriptor enumValueDescriptor = PEnum$.MODULE$.unapply(pValue == null ? null : ((PEnum)pValue).value());
            EnumValueDescriptor enumValueDescriptor2 = PEnum$.MODULE$._1$extension(enumValueDescriptor);
            EnumValueDescriptor v = enumValueDescriptor2;
            textGenerator = !v.isUnrecognized() ? out.add(v.name()) : out.add(BoxesRunTime.boxToInteger((int)v.number()).toString());
        } else if (pValue instanceof PMessage) {
            Map<FieldDescriptor, PValue> e = pValue == null ? null : ((PMessage)pValue).value();
            this.print(e, out);
            textGenerator = BoxedUnit.UNIT;
        } else if (pValue instanceof PString) {
            String string;
            String string2 = PString$.MODULE$.unapply(pValue == null ? null : ((PString)pValue).value());
            String v = string = PString$.MODULE$._1$extension(string2);
            textGenerator = out.add("\"").addMaybeEscape(v).add("\"");
        } else if (pValue instanceof PByteString) {
            ByteString byteString;
            ByteString byteString2 = PByteString$.MODULE$.unapply(pValue == null ? null : ((PByteString)pValue).value());
            ByteString v = byteString = PByteString$.MODULE$._1$extension(byteString2);
            textGenerator = out.add("\"").add(TextFormatUtils$.MODULE$.escapeBytes(v)).add("\"");
        } else {
            if (pValue instanceof PRepeated) {
                Vector vector = PRepeated$.MODULE$.unapply(pValue == null ? null : ((PRepeated)pValue).value());
                Vector<PValue> vector2 = PRepeated$.MODULE$._1$extension(vector);
                throw new RuntimeException("Should not happen.");
            }
            if (PEmpty$.MODULE$.equals(pValue)) {
                throw new RuntimeException("Should not happen.");
            }
            throw new MatchError((Object)pValue);
        }
    }
}

