/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scalapb.TextFormatError;
import scalapb.TextFormatError$;
import scalapb.textformat.Constants$;
import scalapb.textformat.TextFormatUtils;
import scalapb.textformat.TextFormatUtils$Default$;
import scalapb.textformat.TextFormatUtils$Error$;
import scalapb.textformat.TextFormatUtils$EscapeMode$;
import scalapb.textformat.TextFormatUtils$Hex0$;
import scalapb.textformat.TextFormatUtils$Hex1$;
import scalapb.textformat.TextFormatUtils$JavaConversions$;
import scalapb.textformat.TextFormatUtils$Octal1$;
import scalapb.textformat.TextFormatUtils$Octal2$;

public final class TextFormatUtils$
implements Serializable {
    public static final TextFormatUtils$Default$ Default;
    public static final TextFormatUtils$EscapeMode$ EscapeMode;
    public static final TextFormatUtils$Hex0$ Hex0;
    public static final TextFormatUtils$Hex1$ Hex1;
    public static final TextFormatUtils$Octal1$ Octal1;
    public static final TextFormatUtils$Octal2$ Octal2;
    public static final TextFormatUtils$Error$ Error;
    private static final String HEXDIGIT;
    public static final TextFormatUtils$JavaConversions$ JavaConversions;
    public static final TextFormatUtils$ MODULE$;

    private TextFormatUtils$() {
    }

    static {
        MODULE$ = new TextFormatUtils$();
        HEXDIGIT = "0123456789abcdefABCDEF";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TextFormatUtils$.class);
    }

    public boolean isHexDigit(char c) {
        return StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(HEXDIGIT), c);
    }

    private int digitValue(byte c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public String escapeBytes(ByteString bytes) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        TextFormatUtils$JavaConversions$.MODULE$.foreach$extension(this.JavaConversions((Iterable<Byte>)bytes), (Function1 & Serializable)x$1 -> {
            Byte by = x$1;
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH_A(), (Object)by)) {
                return sb.append("\\a");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH_B(), (Object)by)) {
                return sb.append("\\b");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH_F(), (Object)by)) {
                return sb.append("\\f");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH_N(), (Object)by)) {
                return sb.append("\\n");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH_R(), (Object)by)) {
                return sb.append("\\r");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH_T(), (Object)by)) {
                return sb.append("\\t");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH_V(), (Object)by)) {
                return sb.append("\\v");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH(), (Object)by)) {
                return sb.append("\\\\");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SQ(), (Object)by)) {
                return sb.append("\\'");
            }
            if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_DQ(), (Object)by)) {
                return sb.append("\\\"");
            }
            Byte b = by;
            if (Predef$.MODULE$.Byte2byte(b) >= 32) {
                return sb.append((char)Predef$.MODULE$.Byte2byte(b));
            }
            Byte b2 = by;
            sb.append('\\');
            sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(b2) >>> 6 & 3)));
            sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(b2) >>> 3 & 7)));
            return sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(b2) & 7)));
        });
        return sb.result();
    }

    public final Iterable JavaConversions(Iterable<Byte> iter) {
        return iter;
    }

    public Either<TextFormatError, ByteString> unescapeBytes(String charString) {
        TextFormatUtils.ByteParsingState endState;
        ByteString input = ByteString.copyFromUtf8((String)charString);
        ArrayBuilder result = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Byte.TYPE));
        result.sizeHint(input.size());
        TextFormatUtils.ByteParsingState byteParsingState = endState = (TextFormatUtils.ByteParsingState)TextFormatUtils$JavaConversions$.MODULE$.foldLeft$extension(this.JavaConversions((Iterable<Byte>)input), TextFormatUtils$Default$.MODULE$, (Function2 & Serializable)(state, b) -> {
            Object object;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(state, b);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            TextFormatUtils.ByteParsingState byteParsingState = (TextFormatUtils.ByteParsingState)tuple2._1();
            Byte by = (Byte)tuple2._2();
            if (byteParsingState instanceof TextFormatUtils.Error) {
                String e = byteParsingState == null ? null : ((TextFormatUtils.Error)byteParsingState).s();
                object = new TextFormatUtils.Error(e);
                return (TextFormatUtils.ByteParsingState)object;
            } else if (TextFormatUtils$Default$.MODULE$.equals(byteParsingState)) {
                Byte b2 = by;
                object = this.defaultHandle$1(result, Predef$.MODULE$.Byte2byte(b2));
                return (TextFormatUtils.ByteParsingState)object;
            } else if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState)) {
                Byte b3 = by;
                if (Predef$.MODULE$.Byte2byte(b3) >= 48 && Predef$.MODULE$.Byte2byte(b3) <= 55) {
                    object = new TextFormatUtils.Octal1(TextFormatUtils$Octal1$.MODULE$.apply(this.digitValue(Predef$.MODULE$.Byte2byte(b3))));
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_A(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)7));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_B(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)8));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_F(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)12));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_N(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)10));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_R(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)13));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_T(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)9));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_V(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)11));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SLASH(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)92));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_SQ(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)39));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else if (BoxesRunTime.equals((Object)Constants$.MODULE$.CH_DQ(), (Object)by)) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)34));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else {
                    object = BoxesRunTime.equals((Object)Constants$.MODULE$.CH_X(), (Object)by) ? TextFormatUtils$Hex0$.MODULE$ : new TextFormatUtils.Error(TextFormatUtils$Error$.MODULE$.apply(new StringBuilder(25).append("Invalid escape sequence: ").append((char)Predef$.MODULE$.Byte2byte(b)).toString()));
                }
                return (TextFormatUtils.ByteParsingState)object;
            } else if (byteParsingState instanceof TextFormatUtils.Octal1) {
                int n;
                int n2 = TextFormatUtils$Octal1$.MODULE$.unapply(byteParsingState == null ? BoxesRunTime.unboxToInt(null) : ((TextFormatUtils.Octal1)byteParsingState).b());
                int i = n = TextFormatUtils$Octal1$.MODULE$._1$extension(n2);
                Byte b4 = by;
                if (Predef$.MODULE$.Byte2byte(b4) >= 48 && Predef$.MODULE$.Byte2byte(b4) <= 55) {
                    object = new TextFormatUtils.Octal2(TextFormatUtils$Octal2$.MODULE$.apply(i * 8 + this.digitValue(Predef$.MODULE$.Byte2byte(b4))));
                    return (TextFormatUtils.ByteParsingState)object;
                } else {
                    int i2 = n;
                    Byte b5 = by;
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i2)));
                    object = this.defaultHandle$1(result, Predef$.MODULE$.Byte2byte(b5));
                }
                return (TextFormatUtils.ByteParsingState)object;
            } else if (byteParsingState instanceof TextFormatUtils.Octal2) {
                int n;
                int n3 = TextFormatUtils$Octal2$.MODULE$.unapply(byteParsingState == null ? BoxesRunTime.unboxToInt(null) : ((TextFormatUtils.Octal2)byteParsingState).b());
                int i = n = TextFormatUtils$Octal2$.MODULE$._1$extension(n3);
                Byte b6 = by;
                if (Predef$.MODULE$.Byte2byte(b6) >= 48 && Predef$.MODULE$.Byte2byte(b6) <= 55) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(i * 8 + this.digitValue(Predef$.MODULE$.Byte2byte(b6))))));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else {
                    int i3 = n;
                    Byte b7 = by;
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i3)));
                    object = this.defaultHandle$1(result, Predef$.MODULE$.Byte2byte(b7));
                }
                return (TextFormatUtils.ByteParsingState)object;
            } else if (TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState)) {
                Byte b8 = by;
                object = this.isHexDigit((char)Predef$.MODULE$.Byte2byte(b8)) ? new TextFormatUtils.Hex1(TextFormatUtils$Hex1$.MODULE$.apply(this.digitValue(Predef$.MODULE$.Byte2byte(b8)))) : new TextFormatUtils.Error(TextFormatUtils$Error$.MODULE$.apply("'\\x' with no digits"));
                return (TextFormatUtils.ByteParsingState)object;
            } else {
                int n;
                if (!(byteParsingState instanceof TextFormatUtils.Hex1)) throw new MatchError((Object)tuple2);
                int n4 = TextFormatUtils$Hex1$.MODULE$.unapply(byteParsingState == null ? BoxesRunTime.unboxToInt(null) : ((TextFormatUtils.Hex1)byteParsingState).b());
                int i = n = TextFormatUtils$Hex1$.MODULE$._1$extension(n4);
                Byte b9 = by;
                if (this.isHexDigit((char)Predef$.MODULE$.Byte2byte(b9))) {
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(16 * i + this.digitValue(Predef$.MODULE$.Byte2byte(b9))))));
                    object = TextFormatUtils$Default$.MODULE$;
                    return (TextFormatUtils.ByteParsingState)object;
                } else {
                    int i4 = n;
                    Byte b10 = by;
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i4)));
                    object = this.defaultHandle$1(result, Predef$.MODULE$.Byte2byte(b10));
                }
            }
            return (TextFormatUtils.ByteParsingState)object;
        });
        if (byteParsingState instanceof TextFormatUtils.Error) {
            String string;
            String string2 = TextFormatUtils$Error$.MODULE$.unapply(byteParsingState == null ? null : ((TextFormatUtils.Error)byteParsingState).s());
            String e = string = TextFormatUtils$Error$.MODULE$._1$extension(string2);
            return package$.MODULE$.Left().apply((Object)TextFormatError$.MODULE$.apply(e));
        }
        if (TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState)) {
            return package$.MODULE$.Left().apply((Object)TextFormatError$.MODULE$.apply("'\\x' with no digits"));
        }
        if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState)) {
            return package$.MODULE$.Left().apply((Object)TextFormatError$.MODULE$.apply("Invalid escape sequence '\\' at end of string."));
        }
        if (byteParsingState instanceof TextFormatUtils.Hex1) {
            int n;
            int n2 = TextFormatUtils$Hex1$.MODULE$.unapply(byteParsingState == null ? BoxesRunTime.unboxToInt(null) : ((TextFormatUtils.Hex1)byteParsingState).b());
            int i = n = TextFormatUtils$Hex1$.MODULE$._1$extension(n2);
            result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
            return package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        if (byteParsingState instanceof TextFormatUtils.Octal1) {
            int n;
            int n3 = TextFormatUtils$Octal1$.MODULE$.unapply(byteParsingState == null ? BoxesRunTime.unboxToInt(null) : ((TextFormatUtils.Octal1)byteParsingState).b());
            int i = n = TextFormatUtils$Octal1$.MODULE$._1$extension(n3);
            result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
            return package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        if (byteParsingState instanceof TextFormatUtils.Octal2) {
            int n;
            int n4 = TextFormatUtils$Octal2$.MODULE$.unapply(byteParsingState == null ? BoxesRunTime.unboxToInt(null) : ((TextFormatUtils.Octal2)byteParsingState).b());
            int i = n = TextFormatUtils$Octal2$.MODULE$._1$extension(n4);
            result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
            return package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        if (TextFormatUtils$Default$.MODULE$.equals(byteParsingState)) {
            return package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])((byte[])result.result())));
        }
        throw new MatchError((Object)byteParsingState);
    }

    public String escapeText(String input) {
        return this.escapeBytes(ByteString.copyFromUtf8((String)input));
    }

    public Either<TextFormatError, String> unescapeText(String input) {
        return this.unescapeBytes(input).map((Function1 & Serializable)_$1 -> _$1.toStringUtf8());
    }

    public String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    public String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public String escapeDoubleQuotesAndBackslashes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private final Object defaultHandle$1(ArrayBuilder result$1, byte b) {
        Byte by = BoxesRunTime.boxToByte((byte)b);
        Byte by2 = Constants$.MODULE$.CH_SLASH();
        if (!(by != null ? !((Object)by).equals(by2) : by2 != null)) {
            return TextFormatUtils$EscapeMode$.MODULE$;
        }
        result$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)b));
        return TextFormatUtils$Default$.MODULE$;
    }
}

