/*
 * Decompiled with CFR 0.152.
 */
package scalapb.descriptors;

import com.google.protobuf.descriptor.EnumDescriptorProto;
import com.google.protobuf.descriptor.EnumOptions;
import com.google.protobuf.descriptor.EnumValueDescriptorProto;
import com.google.protobuf.descriptor.EnumValueDescriptorProto$;
import com.google.protobuf.descriptor.SourceCodeInfo;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scalapb.descriptors.BaseDescriptor;
import scalapb.descriptors.ConcurrentWeakReferenceMap;
import scalapb.descriptors.Descriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FileDescriptor;
import scalapb.descriptors.FileDescriptor$;
import scalapb.descriptors.SourceCodePath$;

public class EnumDescriptor
implements BaseDescriptor {
    private final String fullName;
    private final int index;
    private final EnumDescriptorProto asProto;
    private final Option containingMessage;
    private final FileDescriptor file;
    private final Vector values;
    private final ConcurrentWeakReferenceMap<Option<Object>, EnumValueDescriptor> unknownValues;

    public EnumDescriptor(String fullName, int index, EnumDescriptorProto asProto, Option<Descriptor> containingMessage, FileDescriptor file) {
        this.fullName = fullName;
        this.index = index;
        this.asProto = asProto;
        this.containingMessage = containingMessage;
        this.file = file;
        this.values = ((IterableOnceOps)((IterableOps)asProto.value().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                EnumValueDescriptorProto v = (EnumValueDescriptorProto)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return new EnumValueDescriptor(FileDescriptor$.MODULE$.join(fullName, v.getName()), this, v, index);
            }
            throw new MatchError((Object)tuple2);
        })).toVector();
        this.unknownValues = new ConcurrentWeakReferenceMap();
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    public int index() {
        return this.index;
    }

    public EnumDescriptorProto asProto() {
        return this.asProto;
    }

    public Option<Descriptor> containingMessage() {
        return this.containingMessage;
    }

    public FileDescriptor file() {
        return this.file;
    }

    public Vector<EnumValueDescriptor> values() {
        return this.values;
    }

    public String name() {
        return this.asProto().getName();
    }

    public Option<EnumValueDescriptor> findValueByNumber(int number) {
        return this.values().find((Function1 & Serializable)_$2 -> _$2.number() == number);
    }

    public EnumValueDescriptor findValueByNumberCreatingIfUnknown(int number) {
        return (EnumValueDescriptor)this.findValueByNumber(number).getOrElse(() -> this.findValueByNumberCreatingIfUnknown$$anonfun$1(number));
    }

    public Option<SourceCodeInfo.Location> location() {
        return this.file().findLocationByPath(SourceCodePath$.MODULE$.get(this));
    }

    public EnumOptions getOptions() {
        return this.asProto().getOptions();
    }

    public String toString() {
        return this.fullName();
    }

    private final EnumValueDescriptor findValueByNumberCreatingIfUnknown$$anonfun$1$$anonfun$1(int number$4, Option numberKey$1) {
        String valueName = new StringBuilder(20).append("UNKNOWN_ENUM_VALUE_").append(this.name()).append("_").append(number$4).toString();
        EnumValueDescriptorProto proto = EnumValueDescriptorProto$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)valueName), (Option<Object>)numberKey$1, EnumValueDescriptorProto$.MODULE$.$lessinit$greater$default$3(), EnumValueDescriptorProto$.MODULE$.$lessinit$greater$default$4());
        return new EnumValueDescriptor(FileDescriptor$.MODULE$.join(this.fullName(), "Unrecognized"), this, proto, -1);
    }

    private final EnumValueDescriptor findValueByNumberCreatingIfUnknown$$anonfun$1(int number$3) {
        Some numberKey = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)number$3));
        return this.unknownValues.getOrElseUpdate((Option<Object>)numberKey, (Function0<EnumValueDescriptor>)((Function0 & Serializable)() -> this.findValueByNumberCreatingIfUnknown$$anonfun$1$$anonfun$1(number$3, (Option)numberKey)));
    }
}

