/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scalapb.textformat.TextFormatUtils$;
import scalapb.textformat.TextGenerator$;

public class TextGenerator {
    private final boolean singleLine;
    private final boolean escapeNonAscii;
    private final StringBuilder sb;
    private int indentLevel;
    private boolean lineStart;

    public static boolean $lessinit$greater$default$1() {
        return TextGenerator$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean $lessinit$greater$default$2() {
        return TextGenerator$.MODULE$.$lessinit$greater$default$2();
    }

    public TextGenerator(boolean singleLine, boolean escapeNonAscii) {
        this.singleLine = singleLine;
        this.escapeNonAscii = escapeNonAscii;
        this.sb = new StringBuilder();
        this.indentLevel = 0;
        this.lineStart = true;
    }

    private void maybeNewLine() {
        if (this.lineStart) {
            if (!this.singleLine) {
                this.sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), this.indentLevel * 2));
            } else if (this.sb.nonEmpty()) {
                this.sb.append(' ');
            }
        }
    }

    public TextGenerator add(String s) {
        this.maybeNewLine();
        this.sb.append(s);
        this.lineStart = false;
        return this;
    }

    public TextGenerator addMaybeEscape(String s) {
        return this.add(this.escapeNonAscii ? TextFormatUtils$.MODULE$.escapeText(s) : TextFormatUtils$.MODULE$.escapeDoubleQuotesAndBackslashes(s).replace("\n", "\\n"));
    }

    public TextGenerator addNewLine(String s) {
        this.maybeNewLine();
        this.sb.append(s);
        if (!this.singleLine) {
            this.sb.append('\n');
        }
        this.lineStart = true;
        return this;
    }

    public TextGenerator indent() {
        ++this.indentLevel;
        return this;
    }

    public TextGenerator outdent() {
        --this.indentLevel;
        return this;
    }

    public String result() {
        return this.sb.result();
    }
}

