/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Predef$;
import scala.collection.StringOps$;
import scalapb.textformat.Position;
import scalapb.textformat.Position$;
import scalapb.textformat.Tokenizer$;

public class Tokenizer {
    private final String s;
    private int pos;
    private int line;
    private int column;
    private int tokenStartLine;
    private int tokenStartCol;
    private int prevTokenStartLine;
    private int prevTokenStartCol;
    private String currentToken;

    public static Pattern FRACTIONAL() {
        return Tokenizer$.MODULE$.FRACTIONAL();
    }

    public static Pattern TEXT() {
        return Tokenizer$.MODULE$.TEXT();
    }

    public static String WHITESPACE() {
        return Tokenizer$.MODULE$.WHITESPACE();
    }

    public static boolean isIdentifier(String string) {
        return Tokenizer$.MODULE$.isIdentifier(string);
    }

    public Tokenizer(String s) {
        this.s = s;
        this.pos = 0;
        this.line = 0;
        this.column = 0;
        this.tokenStartLine = 0;
        this.tokenStartCol = 0;
        this.prevTokenStartLine = 0;
        this.prevTokenStartCol = 0;
        this.currentToken = "";
        this.nextToken();
    }

    public int pos() {
        return this.pos;
    }

    public void pos_$eq(int x$1) {
        this.pos = x$1;
    }

    public int line() {
        return this.line;
    }

    public void line_$eq(int x$1) {
        this.line = x$1;
    }

    public int column() {
        return this.column;
    }

    public void column_$eq(int x$1) {
        this.column = x$1;
    }

    public int tokenStartLine() {
        return this.tokenStartLine;
    }

    public void tokenStartLine_$eq(int x$1) {
        this.tokenStartLine = x$1;
    }

    public int tokenStartCol() {
        return this.tokenStartCol;
    }

    public void tokenStartCol_$eq(int x$1) {
        this.tokenStartCol = x$1;
    }

    public int prevTokenStartLine() {
        return this.prevTokenStartLine;
    }

    public void prevTokenStartLine_$eq(int x$1) {
        this.prevTokenStartLine = x$1;
    }

    public int prevTokenStartCol() {
        return this.prevTokenStartCol;
    }

    public void prevTokenStartCol_$eq(int x$1) {
        this.prevTokenStartCol = x$1;
    }

    public String currentToken() {
        return this.currentToken;
    }

    public void currentToken_$eq(String x$1) {
        this.currentToken = x$1;
    }

    public Position lastPosition() {
        return Position$.MODULE$.apply(this.prevTokenStartLine(), this.prevTokenStartCol());
    }

    public Position position() {
        return Position$.MODULE$.apply(this.tokenStartLine(), this.tokenStartCol());
    }

    private void skipWhitespace() {
        while (this.pos() < this.s.length() && Tokenizer$.MODULE$.WHITESPACE().indexOf(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), this.pos())) != -1) {
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), this.pos()) == '#') {
                while (this.pos() < this.s.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), this.pos()) != '\n') {
                    this.pos_$eq(this.pos() + 1);
                }
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), this.pos()) == '\n') {
                this.line_$eq(this.line() + 1);
                this.column_$eq(0);
                this.pos_$eq(this.pos() + 1);
                continue;
            }
            this.column_$eq(this.column() + 1);
            this.pos_$eq(this.pos() + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String next() {
        void var1_1;
        String r = this.currentToken();
        this.nextToken();
        return var1_1;
    }

    public boolean hasNext() {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.currentToken()));
    }

    /*
     * WARNING - void declaration
     */
    public int findEndOfQuotedString(int pos, char quote) {
        void var3_3;
        int current = pos;
        boolean bl = false;
        while (current < this.s.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), current) != '\n' && !bl) {
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), current) == quote) {
                ++current;
                bl = true;
                continue;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), current) == '\\') {
                if (++current >= this.s.length() || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), current) == '\n') continue;
                ++current;
                continue;
            }
            ++current;
        }
        return (int)var3_3;
    }

    public void nextToken() {
        this.skipWhitespace();
        this.prevTokenStartLine_$eq(this.tokenStartLine());
        this.prevTokenStartCol_$eq(this.tokenStartCol());
        this.tokenStartLine_$eq(this.line());
        this.tokenStartCol_$eq(this.column());
        if (this.pos() == this.s.length()) {
            this.currentToken_$eq("");
        } else {
            Matcher m = Tokenizer$.MODULE$.TEXT().matcher(this.s).region(this.pos(), this.s.length());
            if (m.lookingAt()) {
                this.currentToken_$eq(m.group());
                this.pos_$eq(this.pos() + this.currentToken().length());
                this.column_$eq(this.column() + this.currentToken().length());
            } else if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), this.pos()) == '\"' || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), this.pos()) == '\'') {
                int end = this.findEndOfQuotedString(this.pos() + 1, StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.s), this.pos()));
                this.currentToken_$eq(this.s.substring(this.pos(), end));
                this.column_$eq(this.column() + (end - this.pos()));
                this.pos_$eq(end);
            } else {
                this.currentToken_$eq(this.s.substring(this.pos(), this.pos() + 1));
                this.pos_$eq(this.pos() + 1);
                this.column_$eq(this.column() + 1);
            }
        }
    }
}

