/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scalapb.TextFormatException;
import scalapb.textformat.Position;
import scalapb.textformat.TArray;
import scalapb.textformat.TArray$;
import scalapb.textformat.TBytes;
import scalapb.textformat.TBytes$;
import scalapb.textformat.TField;
import scalapb.textformat.TField$;
import scalapb.textformat.TIntLiteral;
import scalapb.textformat.TIntLiteral$;
import scalapb.textformat.TLiteral;
import scalapb.textformat.TLiteral$;
import scalapb.textformat.TMessage;
import scalapb.textformat.TMessage$;
import scalapb.textformat.TPrimitive;
import scalapb.textformat.TValue;
import scalapb.textformat.Tokenizer;
import scalapb.textformat.Tokenizer$;

public class Parser {
    private final Tokenizer it;

    public Parser(String text) {
        this.it = new Tokenizer(text);
    }

    public Tokenizer it() {
        return this.it;
    }

    public final Seq<TField> parseKeyValueList(Option<String> closer, Seq<TField> acc) {
        while (true) {
            if (!this.it().hasNext()) {
                Option<String> option = closer;
                if (option instanceof Some) {
                    String cl = (String)((Some)option).value();
                    throw this.parseException(new StringBuilder(35).append("Expected ").append(cl).append(" but reached end of stream").toString());
                }
                if (None$.MODULE$.equals(option)) {
                    return acc;
                }
                throw new MatchError(option);
            }
            String token = this.it().next();
            Position pos = this.it().lastPosition();
            Option<String> option = closer;
            if (option instanceof Some) {
                String cl = (String)((Some)option).value();
                String string = token;
                String string2 = cl;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return acc;
                }
            }
            if (!Tokenizer$.MODULE$.isIdentifier(token)) {
                throw this.parseException(new StringBuilder(25).append("Expected identifier, got ").append(token).toString());
            }
            if (!this.it().hasNext()) {
                throw this.parseException("Expected value after identifier");
            }
            TValue value = this.parseValue(this.it().next());
            acc = (Seq)acc.$colon$plus((Object)TField$.MODULE$.apply(pos, token, value));
        }
    }

    public final <T> Seq<T> rep(Seq<T> acc, boolean readyForNext, Function1<String, Option<T>> parse) {
        Option option;
        while (true) {
            String token;
            if (!this.it().hasNext()) {
                throw this.parseException("Unclosed list of messages.");
            }
            String string = token = this.it().next();
            String string2 = "]";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (acc.nonEmpty() && readyForNext) {
                    throw this.parseException("Expected value, found ']' (trailing commas not allowed)");
                }
                return acc;
            }
            String string3 = token;
            String string4 = ",";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                if (readyForNext) {
                    throw this.parseException("Unexpected comma");
                }
                readyForNext = true;
                continue;
            }
            option = (Option)parse.apply((Object)token);
            if (None$.MODULE$.equals(option)) {
                throw this.parseException("Expected value");
            }
            if (!(option instanceof Some)) break;
            Object msg = ((Some)option).value();
            Seq seq = (Seq)acc.$colon$plus(msg);
            boolean bl = false;
            acc = seq;
            readyForNext = bl;
        }
        throw new MatchError((Object)option);
    }

    public Seq<TValue> messageArray() {
        return this.rep((Seq)package$.MODULE$.Nil(), true, (Function1)(Function1 & Serializable)init -> this.tryMessage((String)init));
    }

    public Seq<TValue> valueArray() {
        return this.rep((Seq)package$.MODULE$.Nil(), true, (Function1)(Function1 & Serializable)m -> this.tryMessage((String)m).orElse(() -> this.valueArray$$anonfun$1$$anonfun$1(m)));
    }

    public Option<TArray> tryMessageArray(String init) {
        String string = init;
        String string2 = "[";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Some$.MODULE$.apply((Object)TArray$.MODULE$.apply(this.it().lastPosition(), this.messageArray()));
        }
        return None$.MODULE$;
    }

    public Option<TArray> tryValueArray(String init) {
        String string = init;
        String string2 = "[";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Some$.MODULE$.apply((Object)TArray$.MODULE$.apply(this.it().lastPosition(), this.valueArray()));
        }
        return None$.MODULE$;
    }

    public Option<TMessage> tryMessage(String init) {
        String string = init;
        if ("{".equals(string)) {
            return Some$.MODULE$.apply((Object)TMessage$.MODULE$.apply(this.it().lastPosition(), this.parseKeyValueList((Option<String>)Some$.MODULE$.apply((Object)"}"), (Seq<TField>)package$.MODULE$.Nil())));
        }
        if ("<".equals(string)) {
            return Some$.MODULE$.apply((Object)TMessage$.MODULE$.apply(this.it().lastPosition(), this.parseKeyValueList((Option<String>)Some$.MODULE$.apply((Object)">"), (Seq<TField>)package$.MODULE$.Nil())));
        }
        return None$.MODULE$;
    }

    public Option<BigInt> tryHexIntegral(String token, int index, int sign) {
        boolean hexPrefix;
        boolean bl = hexPrefix = index + 1 < token.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), index) == '0' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), index + 1) == 'x';
        if (!hexPrefix) {
            return None$.MODULE$;
        }
        String s = token.substring(index + 2);
        if (!StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> Parser.tryHexIntegral$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)))) {
            throw this.parseException(new StringBuilder(21).append("Invalid hex literal: ").append(token).toString());
        }
        return Some$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(s, 16).$times(BigInt$.MODULE$.int2bigInt(sign)));
    }

    public Option<BigInt> tryOctIntegral(String token, int index, int sign) {
        boolean octPrefix;
        boolean bl = octPrefix = index < token.length() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), index) == '0';
        if (!octPrefix) {
            return None$.MODULE$;
        }
        String s = token.substring(index);
        if (!StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> Parser.tryOctIntegral$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)))) {
            throw this.parseException(new StringBuilder(23).append("Invalid octal literal: ").append(token).toString());
        }
        return Some$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(s, 8).$times(BigInt$.MODULE$.int2bigInt(sign)));
    }

    public Option<BigInt> tryDecimal(String token, int index, int sign) {
        String s = token.substring(index);
        if (!StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> Parser.tryDecimal$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)))) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(s, 10).$times(BigInt$.MODULE$.int2bigInt(sign)));
    }

    public Option<BigInt> tryBigInt(String token) {
        if (token.isEmpty()) {
            return None$.MODULE$;
        }
        Tuple2.mcII.sp sp2 = token.startsWith("-") ? new Tuple2.mcII.sp(-1, 1) : (token.startsWith("+") ? new Tuple2.mcII.sp(1, 1) : new Tuple2.mcII.sp(1, 0));
        int sign = sp2._1$mcI$sp();
        int index = sp2._2$mcI$sp();
        return this.tryHexIntegral(token, index, sign).orElse(() -> this.tryBigInt$$anonfun$1(token, index, sign)).orElse(() -> this.tryBigInt$$anonfun$2(token, index, sign));
    }

    public Option<TIntLiteral> tryBigIntLiteral(String token) {
        Position pos = this.it().lastPosition();
        return this.tryBigInt(token).map((Function1 & Serializable)_$1 -> TIntLiteral$.MODULE$.apply(pos, (BigInt)_$1));
    }

    public Option<TLiteral> tryLiteral(String token) {
        if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(token), (Function1 & Serializable)c -> Parser.tryLiteral$$anonfun$1(BoxesRunTime.unboxToChar((Object)c)))) {
            return Some$.MODULE$.apply((Object)TLiteral$.MODULE$.apply(this.it().lastPosition(), token));
        }
        return None$.MODULE$;
    }

    public Option<TLiteral> tryFractional(String token) {
        Position pos = this.it().lastPosition();
        if (Tokenizer$.MODULE$.FRACTIONAL().matcher(token).matches()) {
            return Some$.MODULE$.apply((Object)TLiteral$.MODULE$.apply(pos, token));
        }
        return None$.MODULE$;
    }

    public Option<TPrimitive> tryPrimitiveValue(String token) {
        return this.tryFractional(token).orElse(() -> this.tryPrimitiveValue$$anonfun$1(token)).orElse(() -> this.tryPrimitiveValue$$anonfun$2(token)).orElse(() -> this.tryPrimitiveValue$$anonfun$3(token));
    }

    public Option<TBytes> tryBytesLiteral(String token) {
        Position pos = this.it().lastPosition();
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        if (!this.tryBytesLiteralSingle(token, sb)) {
            return None$.MODULE$;
        }
        while (this.tryBytesLiteralSingle(this.it().currentToken(), sb)) {
            this.it().nextToken();
        }
        return Some$.MODULE$.apply((Object)TBytes$.MODULE$.apply(pos, sb.result()));
    }

    public boolean tryBytesLiteralSingle(String token, scala.collection.mutable.StringBuilder sb) {
        char quote;
        char c = quote = token.isEmpty() ? (char)' ' : (char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), 0);
        if (quote != '\"' && quote != '\'') {
            return false;
        }
        if (token.length() < 2 || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(token)) != quote) {
            throw this.parseException("String missing ending quote");
        }
        sb.$plus$plus$eq(token.substring(1, token.length() - 1));
        return true;
    }

    public Option<TValue> tryColonValue(String init) {
        String string = init;
        String string2 = ":";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return None$.MODULE$;
        }
        if (!this.it().hasNext()) {
            throw this.parseException("Expected value");
        }
        String token = this.it().next();
        return this.tryMessage(token).orElse(() -> this.tryColonValue$$anonfun$1(token)).orElse(() -> this.tryColonValue$$anonfun$2(token));
    }

    public TValue parseValue(String init) {
        return (TValue)this.tryMessage(init).orElse(() -> this.parseValue$$anonfun$1(init)).orElse(() -> this.parseValue$$anonfun$2(init)).getOrElse(() -> this.parseValue$$anonfun$3(init));
    }

    public TMessage parseMessage() {
        return TMessage$.MODULE$.apply(this.it().lastPosition(), this.parseKeyValueList((Option<String>)None$.MODULE$, (Seq<TField>)package$.MODULE$.Nil()));
    }

    public TextFormatException parseException(String msg) {
        throw new TextFormatException(new StringBuilder(17).append(msg).append(" (line ").append(this.it().lastPosition().line() + 1).append(", column ").append(this.it().lastPosition().col() + 1).append(")").toString());
    }

    private final Option valueArray$$anonfun$1$$anonfun$1(String m$1) {
        return this.tryPrimitiveValue(m$1);
    }

    private static final /* synthetic */ boolean tryHexIntegral$$anonfun$1(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private static final /* synthetic */ boolean tryOctIntegral$$anonfun$1(char ch) {
        return ch >= '0' && ch <= '7';
    }

    private static final /* synthetic */ boolean tryDecimal$$anonfun$1(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private final Option tryBigInt$$anonfun$1(String token$1, int index$1, int sign$1) {
        return this.tryOctIntegral(token$1, index$1, sign$1);
    }

    private final Option tryBigInt$$anonfun$2(String token$2, int index$2, int sign$2) {
        return this.tryDecimal(token$2, index$2, sign$2);
    }

    private static final /* synthetic */ boolean tryLiteral$$anonfun$1(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-';
    }

    private final Option tryPrimitiveValue$$anonfun$1(String token$3) {
        return this.tryBigIntLiteral(token$3);
    }

    private final Option tryPrimitiveValue$$anonfun$2(String token$4) {
        return this.tryBytesLiteral(token$4);
    }

    private final Option tryPrimitiveValue$$anonfun$3(String token$5) {
        return this.tryLiteral(token$5);
    }

    private final Option tryColonValue$$anonfun$1(String token$6) {
        return this.tryValueArray(token$6);
    }

    private final Option tryColonValue$$anonfun$2(String token$7) {
        return this.tryPrimitiveValue(token$7);
    }

    private final Option parseValue$$anonfun$1(String init$1) {
        return this.tryMessageArray(init$1);
    }

    private final Option parseValue$$anonfun$2(String init$2) {
        return this.tryColonValue(init$2);
    }

    private final TValue parseValue$$anonfun$3(String init$3) {
        throw this.parseException(new StringBuilder(38).append("Expected ':', '{', '<', or '[', got '").append(init$3).append("'").toString());
    }
}

