/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Decimal;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Precision;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfigurable;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchConstants;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchSetup;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.util.DefaultTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class ElasticSearchIndex
implements IndexProvider {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchIndex.class);
    private static final String TTL_FIELD = "_ttl";
    private static final String STRING_MAPPING_SUFFIX = "$STRING";
    public static final ImmutableList<String> DATA_SUBDIRS = ImmutableList.of((Object)"data", (Object)"work", (Object)"logs");
    public static final ConfigNamespace ELASTICSEARCH_NS = new ConfigNamespace(GraphDatabaseConfiguration.INDEX_NS, "elasticsearch", "Elasticsearch index configuration");
    public static final ConfigOption<Boolean> CLIENT_ONLY = new ConfigOption(ELASTICSEARCH_NS, "client-only", "The Elasticsearch node.client option is set to this boolean value, and the Elasticsearch node.data option is set to the negation of this value.  True creates a thin client which holds no data.  False creates a regular Elasticsearch cluster node that may store data.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)true);
    public static final ConfigOption<String> CLUSTER_NAME = new ConfigOption(ELASTICSEARCH_NS, "cluster-name", "The name of the Elasticsearch cluster.  This should match the \"cluster.name\" setting in the Elasticsearch nodes' configuration.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)"elasticsearch");
    public static final ConfigOption<Boolean> LOCAL_MODE = new ConfigOption(ELASTICSEARCH_NS, "local-mode", "On the legacy config track, this option chooses between starting a TransportClient (false) or a Node with JVM-local transport and local data (true).  On the interface config track, this option is considered by (but optional for) the Node client and ignored by the TransportClient.  See the manual for more information about ES config tracks.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)false);
    public static final ConfigOption<Boolean> CLIENT_SNIFF = new ConfigOption(ELASTICSEARCH_NS, "sniff", "Whether to enable cluster sniffing.  This option only applies to the TransportClient.  Enabling this option makes the TransportClient attempt to discover other cluster nodes besides those in the initial host list provided at startup.", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<ElasticSearchSetup> INTERFACE = new ConfigOption(ELASTICSEARCH_NS, "interface", "Whether to connect to ES using the Node or Transport client (see the \"Talking to Elasticsearch\" section of the ES manual for discussion of the difference).  Setting this option enables the interface config track (see manual for more information about ES config tracks).", ConfigOption.Type.MASKABLE, ElasticSearchSetup.class, (Object)ElasticSearchSetup.TRANSPORT_CLIENT);
    public static final ConfigOption<Boolean> IGNORE_CLUSTER_NAME = new ConfigOption(ELASTICSEARCH_NS, "ignore-cluster-name", "Whether to bypass validation of the cluster name of connected nodes.  This option is only used on the interface configuration track (see manual for information about ES config tracks).", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<String> TTL_INTERVAL = new ConfigOption(ELASTICSEARCH_NS, "ttl-interval", "The period of time between runs of ES's bulit-in expired document deleter.  This string will become the value of ES's indices.ttl.interval setting and should be formatted accordingly, e.g. 5s or 60s.", ConfigOption.Type.MASKABLE, (Object)"5s");
    public static final ConfigOption<String> HEALTH_REQUEST_TIMEOUT = new ConfigOption(ELASTICSEARCH_NS, "health-request-timeout", "When Titan initializes its ES backend, Titan waits up to this duration for the ES cluster health to reach at least yellow status.  This string should be formatted as a natural number followed by the lowercase letter \"s\", e.g. 3s or 60s.", ConfigOption.Type.MASKABLE, (Object)"30s");
    public static final ConfigOption<Boolean> LOAD_DEFAULT_NODE_SETTINGS = new ConfigOption(ELASTICSEARCH_NS, "load-default-node-settings", "Whether ES's Node client will internally attempt to load default configuration settings from system properties/process environment variables.  Only meaningful when using the Node client (has no effect with TransportClient).", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigNamespace ES_EXTRAS_NS = new ConfigNamespace(ELASTICSEARCH_NS, "ext", "Overrides for arbitrary elasticsearch.yaml settings", true);
    public static final ConfigNamespace ES_CREATE_NS = new ConfigNamespace(ELASTICSEARCH_NS, "create", "Settings related to index creation");
    public static final ConfigOption<Long> CREATE_SLEEP = new ConfigOption(ES_CREATE_NS, "sleep", "How long to sleep, in milliseconds, between the successful completion of a (blocking) index creation request and the first use of that index.  This only applies when creating an index in ES, which typically only happens the first time Titan is started on top of ES. If the index Titan is configured to use already exists, then this setting has no effect.", ConfigOption.Type.MASKABLE, (Object)200L);
    public static final ConfigNamespace ES_CREATE_EXTRAS_NS = new ConfigNamespace(ES_CREATE_NS, "ext", "Overrides for arbitrary settings applied at index creation", true);
    private static final IndexFeatures ES_FEATURES = new IndexFeatures.Builder().supportsDocumentTTL().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.TEXTSTRING, Mapping.STRING}).build();
    public static final int HOST_PORT_DEFAULT = 9300;
    private final Node node;
    private final Client client;
    private final String indexName;
    private final int maxResultsSize;

    public ElasticSearchIndex(Configuration config) {
        this.indexName = (String)config.get(GraphDatabaseConfiguration.INDEX_NAME, new String[0]);
        this.checkExpectedClientVersion();
        ElasticSearchSetup.Connection c = !config.has(INTERFACE, new String[0]) ? this.legacyConfiguration(config) : this.interfaceConfiguration(config);
        this.node = c.getNode();
        this.client = c.getClient();
        this.maxResultsSize = (Integer)config.get(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, new String[0]);
        log.debug("Configured ES query result set max size to {}", (Object)this.maxResultsSize);
        this.client.admin().cluster().prepareHealth(new String[0]).setTimeout((String)config.get(HEALTH_REQUEST_TIMEOUT, new String[0])).setWaitForYellowStatus().execute().actionGet();
        this.checkForOrCreateIndex(config);
    }

    private void checkForOrCreateIndex(Configuration config) {
        Preconditions.checkState((null != this.client ? 1 : 0) != 0);
        IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{this.indexName})).actionGet();
        if (!response.isExists()) {
            ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
            ElasticSearchSetup.applySettingsFromTitanConf(settings, config, ES_CREATE_EXTRAS_NS);
            CreateIndexResponse create = (CreateIndexResponse)this.client.admin().indices().prepareCreate(this.indexName).setSettings(settings.build()).execute().actionGet();
            try {
                long sleep = (Long)config.get(CREATE_SLEEP, new String[0]);
                log.debug("Sleeping {} ms after {} index creation returned from actionGet()", (Object)sleep, (Object)this.indexName);
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw new TitanException("Interrupted while waiting for index to settle in", (Throwable)e);
            }
            if (!create.isAcknowledged()) {
                throw new IllegalArgumentException("Could not create index: " + this.indexName);
            }
        }
    }

    private ElasticSearchSetup.Connection interfaceConfiguration(Configuration config) {
        ElasticSearchSetup clientMode = (ElasticSearchSetup)((Object)config.get(INTERFACE, new String[0]));
        try {
            return clientMode.connect(config);
        }
        catch (IOException e) {
            throw new TitanException((Throwable)e);
        }
    }

    private ElasticSearchSetup.Connection legacyConfiguration(Configuration config) {
        TransportClient client;
        Node node;
        block14: {
            block11: {
                NodeBuilder builder;
                boolean local;
                boolean clientOnly;
                block13: {
                    block12: {
                        if (!((Boolean)config.get(LOCAL_MODE, new String[0])).booleanValue()) break block11;
                        log.debug("Configuring ES for JVM local transport");
                        clientOnly = (Boolean)config.get(CLIENT_ONLY, new String[0]);
                        local = (Boolean)config.get(LOCAL_MODE, new String[0]);
                        builder = NodeBuilder.nodeBuilder();
                        Preconditions.checkArgument((config.has(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0]) || config.has(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]) ? 1 : 0) != 0, (Object)"Must either configure configuration file or base directory");
                        if (!config.has(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0])) break block12;
                        String configFile = (String)config.get(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0]);
                        ImmutableSettings.Builder sb = ImmutableSettings.settingsBuilder();
                        log.debug("Configuring ES from YML file [{}]", (Object)configFile);
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(configFile);
                            sb.loadFromStream(configFile, (InputStream)fis);
                            builder.settings(sb.build());
                        }
                        catch (FileNotFoundException e) {
                            try {
                                throw new TitanException((Throwable)e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(fis);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Closeable)fis);
                        break block13;
                    }
                    String dataDirectory = (String)config.get(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]);
                    log.debug("Configuring ES with data directory [{}]", (Object)dataDirectory);
                    File f = new File(dataDirectory);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    ImmutableSettings.Builder b = ImmutableSettings.settingsBuilder();
                    for (String sub : DATA_SUBDIRS) {
                        String subdir = dataDirectory + File.separator + sub;
                        f = new File(subdir);
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                        b.put("path." + sub, subdir);
                    }
                    b.put("script.disable_dynamic", false);
                    b.put("indices.ttl.interval", "5s");
                    builder.settings(b.build());
                    String clustername = (String)config.get(CLUSTER_NAME, new String[0]);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)clustername), (String)"Invalid cluster name: %s", (Object[])new Object[]{clustername});
                    builder.clusterName(clustername);
                }
                node = builder.client(clientOnly).data(!clientOnly).local(local).node();
                client = node.client();
                break block14;
            }
            log.debug("Configuring ES for network transport");
            ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
            if (config.has(CLUSTER_NAME, new String[0])) {
                String clustername = (String)config.get(CLUSTER_NAME, new String[0]);
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)clustername), (String)"Invalid cluster name: %s", (Object[])new Object[]{clustername});
                settings.put("cluster.name", clustername);
            } else {
                settings.put("client.transport.ignore_cluster_name", true);
            }
            log.debug("Transport sniffing enabled: {}", config.get(CLIENT_SNIFF, new String[0]));
            settings.put("client.transport.sniff", ((Boolean)config.get(CLIENT_SNIFF, new String[0])).booleanValue());
            settings.put("script.disable_dynamic", false);
            TransportClient tc = new TransportClient(settings.build());
            int defaultPort = config.has(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) ? (Integer)config.get(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) : 9300;
            for (String host : (String[])config.get(GraphDatabaseConfiguration.INDEX_HOSTS, new String[0])) {
                String[] hostparts = host.split(":");
                String hostname = hostparts[0];
                int hostport = defaultPort;
                if (hostparts.length == 2) {
                    hostport = Integer.parseInt(hostparts[1]);
                }
                log.info("Configured remote host: {} : {}", (Object)hostname, (Object)hostport);
                tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, hostport));
            }
            client = tc;
            node = null;
        }
        return new ElasticSearchSetup.Connection(node, (Client)client);
    }

    private BackendException convert(Exception esException) {
        if (esException instanceof InterruptedException) {
            return new TemporaryBackendException("Interrupted while waiting for response", (Throwable)esException);
        }
        return new PermanentBackendException("Unknown exception while executing index operation", (Throwable)esException);
    }

    private static String getDualMappingName(String key) {
        return key + STRING_MAPPING_SUFFIX;
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        XContentBuilder mapping;
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        Preconditions.checkArgument((map == Mapping.DEFAULT || AttributeUtil.isString((Class)dataType) ? 1 : 0) != 0, (String)"Specified illegal mapping [%s] for data type [%s]", (Object[])new Object[]{map, dataType});
        try {
            block25: {
                block24: {
                    mapping = XContentFactory.jsonBuilder().startObject().startObject(store).field(TTL_FIELD, (Map)new HashMap<String, Object>(){
                        {
                            this.put("enabled", true);
                        }
                    }).startObject("properties").startObject(key);
                    if (!AttributeUtil.isString((Class)dataType)) break block24;
                    if (map == Mapping.DEFAULT) {
                        map = Mapping.TEXT;
                    }
                    log.debug("Registering string type for {} with mapping {}", (Object)key, (Object)map);
                    mapping.field("type", "string");
                    switch (map) {
                        case STRING: {
                            mapping.field("index", "not_analyzed");
                            break block25;
                        }
                        case TEXT: 
                        case TEXTSTRING: {
                            mapping.endObject();
                            mapping.startObject(ElasticSearchIndex.getDualMappingName(key));
                            mapping.field("type", "string");
                            mapping.field("index", "not_analyzed");
                            break block25;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected mapping: " + map));
                        }
                    }
                }
                if (dataType == Float.class) {
                    log.debug("Registering float type for {}", (Object)key);
                    mapping.field("type", "float");
                } else if (dataType == Double.class || dataType == Decimal.class || dataType == Precision.class) {
                    log.debug("Registering double type for {}", (Object)key);
                    mapping.field("type", "double");
                } else if (dataType == Byte.class) {
                    log.debug("Registering byte type for {}", (Object)key);
                    mapping.field("type", "byte");
                } else if (dataType == Short.class) {
                    log.debug("Registering short type for {}", (Object)key);
                    mapping.field("type", "short");
                } else if (dataType == Integer.class) {
                    log.debug("Registering integer type for {}", (Object)key);
                    mapping.field("type", "integer");
                } else if (dataType == Long.class) {
                    log.debug("Registering long type for {}", (Object)key);
                    mapping.field("type", "long");
                } else if (dataType == Boolean.class) {
                    log.debug("Registering boolean type for {}", (Object)key);
                    mapping.field("type", "boolean");
                } else if (dataType == Geoshape.class) {
                    log.debug("Registering geo_point type for {}", (Object)key);
                    mapping.field("type", "geo_point");
                }
            }
            mapping.endObject().endObject().endObject().endObject();
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not render json for put mapping request", (Throwable)e);
        }
        try {
            PutMappingResponse response = (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{this.indexName}).setIgnoreConflicts(false).setType(store).setSource(mapping).execute().actionGet();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    private static Mapping getStringMapping(KeyInformation information) {
        assert (AttributeUtil.isString((Class)information.getDataType()));
        Mapping map = Mapping.getMapping((KeyInformation)information);
        if (map == Mapping.DEFAULT) {
            map = Mapping.TEXT;
        }
        return map;
    }

    private static boolean hasDualStringMapping(KeyInformation information) {
        return AttributeUtil.isString((Class)information.getDataType()) && ElasticSearchIndex.getStringMapping(information) == Mapping.TEXTSTRING;
    }

    public XContentBuilder getContent(final List<IndexEntry> additions, KeyInformation.StoreRetriever informations, int ttl) throws BackendException {
        Preconditions.checkArgument((ttl >= 0 ? 1 : 0) != 0);
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            HashMap<String, IndexEntry> uniq = new HashMap<String, IndexEntry>(additions.size()){
                {
                    super(x0);
                    for (IndexEntry e : additions) {
                        this.put(e.field, e);
                    }
                }
            };
            for (IndexEntry add : uniq.values()) {
                if (add.value instanceof Number) {
                    if (AttributeUtil.isWholeNumber((Number)((Number)add.value))) {
                        builder.field(add.field, ((Number)add.value).longValue());
                        continue;
                    }
                    builder.field(add.field, ((Number)add.value).doubleValue());
                    continue;
                }
                if (AttributeUtil.isString((Object)add.value)) {
                    builder.field(add.field, (String)add.value);
                    if (!ElasticSearchIndex.hasDualStringMapping(informations.get(add.field))) continue;
                    builder.field(ElasticSearchIndex.getDualMappingName(add.field), (String)add.value);
                    continue;
                }
                if (add.value instanceof Geoshape) {
                    Geoshape shape = (Geoshape)add.value;
                    if (shape.getType() == Geoshape.Type.POINT) {
                        Geoshape.Point p = shape.getPoint();
                        builder.field(add.field, new double[]{p.getLongitude(), p.getLatitude()});
                        continue;
                    }
                    throw new UnsupportedOperationException("Geo type is not supported: " + shape.getType());
                }
                throw new IllegalArgumentException("Unsupported type: " + add.value);
            }
            if (ttl > 0) {
                builder.field(TTL_FIELD, TimeUnit.MILLISECONDS.convert(ttl, TimeUnit.SECONDS));
            }
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not write json");
        }
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        BulkRequestBuilder brb = this.client.prepareBulk();
        int bulkrequests = 0;
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                String storename = stores.getKey();
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    String docid = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    assert (mutation.isConsolidated());
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.isDeleted() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.hasDeletions() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isDeleted() || !mutation.hasAdditions() ? 1 : 0) != 0);
                    if (mutation.hasDeletions()) {
                        if (mutation.isDeleted()) {
                            log.trace("Deleting entire document {}", (Object)docid);
                            brb.add(new DeleteRequest(this.indexName, storename, docid));
                        } else {
                            StringBuilder script = new StringBuilder();
                            for (String key : Iterables.transform((Iterable)mutation.getDeletions(), (Function)IndexMutation.ENTRY2FIELD_FCT)) {
                                script.append("ctx._source.remove(\"" + key + "\"); ");
                                if (ElasticSearchIndex.hasDualStringMapping(informations.get(storename, key))) {
                                    script.append("ctx._source.remove(\"" + ElasticSearchIndex.getDualMappingName(key) + "\"); ");
                                }
                                log.trace("Deleting individual field [{}] for document {}", (Object)key, (Object)docid);
                            }
                            brb.add(this.client.prepareUpdate(this.indexName, storename, docid).setScript(script.toString()));
                            ++bulkrequests;
                        }
                        ++bulkrequests;
                    }
                    if (!mutation.hasAdditions()) continue;
                    int ttl = mutation.determineTTL();
                    if (mutation.isNew()) {
                        log.trace("Adding entire document {}", (Object)docid);
                        brb.add(new IndexRequest(this.indexName, storename, docid).source(this.getContent(mutation.getAdditions(), informations.get(storename), ttl)));
                    } else {
                        Preconditions.checkArgument((ttl == 0 ? 1 : 0) != 0, (String)"Elasticsearch only supports TTL on new documents [%s]", (Object[])new Object[]{docid});
                        boolean needUpsert = !mutation.hasDeletions();
                        XContentBuilder builder = this.getContent(mutation.getAdditions(), informations.get(storename), ttl);
                        UpdateRequestBuilder update = this.client.prepareUpdate(this.indexName, storename, docid).setDoc(builder);
                        if (needUpsert) {
                            update.setUpsert(builder);
                        }
                        log.trace("Updating document {} with upsert {}", (Object)docid, (Object)needUpsert);
                        brb.add(update);
                        ++bulkrequests;
                    }
                    ++bulkrequests;
                }
            }
            if (bulkrequests > 0) {
                brb.execute().actionGet();
            }
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        BulkRequestBuilder bulk = this.client.prepareBulk();
        int requests = 0;
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                String store = stores.getKey();
                for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                    String docID = entry.getKey();
                    List<IndexEntry> content = entry.getValue();
                    if (content == null || content.size() == 0) {
                        if (log.isTraceEnabled()) {
                            log.trace("Deleting entire document {}", (Object)docID);
                        }
                        bulk.add(new DeleteRequest(this.indexName, store, docID));
                        ++requests;
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Adding entire document {}", (Object)docID);
                    }
                    bulk.add(new IndexRequest(this.indexName, store, docID).source(this.getContent(content, informations.get(store), IndexMutation.determineTTL(content))));
                    ++requests;
                }
            }
            if (requests > 0) {
                bulk.execute().actionGet();
            }
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public FilterBuilder getFilter(Condition<?> condition, KeyInformation.StoreRetriever informations) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            TitanPredicate titanPredicate = atom.getPredicate();
            if (value instanceof Number) {
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + titanPredicate));
                Cmp numRel = (Cmp)titanPredicate;
                Preconditions.checkArgument((boolean)(value instanceof Number));
                switch (numRel) {
                    case EQUAL: {
                        return FilterBuilders.inFilter((String)key, (Object[])new Object[]{value});
                    }
                    case NOT_EQUAL: {
                        return FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])new Object[]{value}));
                    }
                    case LESS_THAN: {
                        return FilterBuilders.rangeFilter((String)key).lt(value);
                    }
                    case LESS_THAN_EQUAL: {
                        return FilterBuilders.rangeFilter((String)key).lte(value);
                    }
                    case GREATER_THAN: {
                        return FilterBuilders.rangeFilter((String)key).gt(value);
                    }
                    case GREATER_THAN_EQUAL: {
                        return FilterBuilders.rangeFilter((String)key).gte(value);
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof String) {
                Mapping map = ElasticSearchIndex.getStringMapping(informations.get(key));
                String fieldName = key;
                if (map == Mapping.TEXT && !titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS queries and not: " + titanPredicate);
                }
                if (map == Mapping.STRING && titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + titanPredicate);
                }
                if (map == Mapping.TEXTSTRING && !titanPredicate.toString().startsWith("CONTAINS")) {
                    fieldName = ElasticSearchIndex.getDualMappingName(key);
                }
                if (titanPredicate == Text.CONTAINS) {
                    value = ((String)value).toLowerCase();
                    AndFilterBuilder b = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
                    for (String term : Text.tokenize((String)((String)value))) {
                        b.add((FilterBuilder)FilterBuilders.termFilter((String)fieldName, (String)term));
                    }
                    return b;
                }
                if (titanPredicate == Text.CONTAINS_PREFIX) {
                    value = ((String)value).toLowerCase();
                    return FilterBuilders.prefixFilter((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Text.CONTAINS_REGEX) {
                    value = ((String)value).toLowerCase();
                    return FilterBuilders.regexpFilter((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Text.PREFIX) {
                    return FilterBuilders.prefixFilter((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Text.REGEX) {
                    return FilterBuilders.regexpFilter((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Cmp.EQUAL) {
                    return FilterBuilders.termFilter((String)fieldName, (String)((String)value));
                }
                if (titanPredicate == Cmp.NOT_EQUAL) {
                    return FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)fieldName, (String)((String)value)));
                }
                throw new IllegalArgumentException("Predicate is not supported for string value: " + titanPredicate);
            }
            if (value instanceof Geoshape) {
                Preconditions.checkArgument((titanPredicate == Geo.WITHIN ? 1 : 0) != 0, (Object)("Relation is not supported for geo value: " + titanPredicate));
                Geoshape shape = (Geoshape)value;
                if (shape.getType() == Geoshape.Type.CIRCLE) {
                    Geoshape.Point center = shape.getPoint();
                    return FilterBuilders.geoDistanceFilter((String)key).lat((double)center.getLatitude()).lon((double)center.getLongitude()).distance((double)shape.getRadius(), DistanceUnit.KILOMETERS);
                }
                if (shape.getType() == Geoshape.Type.BOX) {
                    Geoshape.Point southwest = shape.getPoint(0);
                    Geoshape.Point northeast = shape.getPoint(1);
                    return FilterBuilders.geoBoundingBoxFilter((String)key).bottomRight((double)southwest.getLatitude(), (double)northeast.getLongitude()).topLeft((double)northeast.getLatitude(), (double)southwest.getLongitude());
                }
                throw new IllegalArgumentException("Unsupported or invalid search shape type: " + shape.getType());
            }
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        if (condition instanceof Not) {
            return FilterBuilders.notFilter((FilterBuilder)this.getFilter(((Not)condition).getChild(), informations));
        }
        if (condition instanceof And) {
            AndFilterBuilder b = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
            for (Condition c : condition.getChildren()) {
                b.add(this.getFilter(c, informations));
            }
            return b;
        }
        if (condition instanceof Or) {
            OrFilterBuilder b = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
            for (Condition c : condition.getChildren()) {
                b.add(this.getFilter(c, informations));
            }
            return b;
        }
        throw new IllegalArgumentException("Invalid condition: " + condition);
    }

    public List<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        SearchRequestBuilder srb = this.client.prepareSearch(new String[]{this.indexName});
        srb.setTypes(new String[]{query.getStore()});
        srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        srb.setPostFilter(this.getFilter(query.getCondition(), informations.get(query.getStore())));
        if (!query.getOrder().isEmpty()) {
            List orders = query.getOrder();
            for (int i = 0; i < orders.size(); ++i) {
                srb.addSort((SortBuilder)new FieldSortBuilder(((IndexQuery.OrderEntry)orders.get(i)).getKey()).order(((IndexQuery.OrderEntry)orders.get(i)).getOrder() == Order.ASC ? SortOrder.ASC : SortOrder.DESC).ignoreUnmapped(true));
            }
        }
        srb.setFrom(0);
        if (query.hasLimit()) {
            srb.setSize(query.getLimit());
        } else {
            srb.setSize(this.maxResultsSize);
        }
        srb.setNoFields();
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        log.debug("Executed query [{}] in {} ms", (Object)query.getCondition(), (Object)response.getTookInMillis());
        SearchHits hits = response.getHits();
        if (!query.hasLimit() && hits.totalHits() >= (long)this.maxResultsSize) {
            log.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResultsSize, (Object)query);
        }
        ArrayList<String> result = new ArrayList<String>(hits.hits().length);
        for (SearchHit hit : hits) {
            result.add(hit.id());
        }
        return result;
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        SearchRequestBuilder srb = this.client.prepareSearch(new String[]{this.indexName});
        srb.setTypes(new String[]{query.getStore()});
        srb.setQuery((QueryBuilder)QueryBuilders.queryString((String)query.getQuery()));
        srb.setFrom(query.getOffset());
        if (query.hasLimit()) {
            srb.setSize(query.getLimit());
        } else {
            srb.setSize(this.maxResultsSize);
        }
        srb.setNoFields();
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        log.debug("Executed query [{}] in {} ms", (Object)query.getQuery(), (Object)response.getTookInMillis());
        SearchHits hits = response.getHits();
        if (!query.hasLimit() && hits.totalHits() >= (long)this.maxResultsSize) {
            log.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResultsSize, (Object)query);
        }
        ArrayList<RawQuery.Result<String>> result = new ArrayList<RawQuery.Result<String>>(hits.hits().length);
        for (SearchHit hit : hits) {
            result.add((RawQuery.Result<String>)new RawQuery.Result((Object)hit.id(), (double)hit.getScore()));
        }
        return result;
    }

    public boolean supports(KeyInformation information, TitanPredicate titanPredicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (mapping != Mapping.DEFAULT && !AttributeUtil.isString((Class)dataType)) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            if (titanPredicate instanceof Cmp) {
                return true;
            }
        } else {
            if (dataType == Geoshape.class) {
                return titanPredicate == Geo.WITHIN;
            }
            if (AttributeUtil.isString((Class)dataType)) {
                switch (mapping) {
                    case TEXT: 
                    case DEFAULT: {
                        return titanPredicate == Text.CONTAINS || titanPredicate == Text.CONTAINS_PREFIX || titanPredicate == Text.CONTAINS_REGEX;
                    }
                    case STRING: {
                        return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL || titanPredicate == Text.REGEX || titanPredicate == Text.PREFIX;
                    }
                    case TEXTSTRING: {
                        return titanPredicate instanceof Text || titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL;
                    }
                }
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        return Number.class.isAssignableFrom(dataType) || dataType == Geoshape.class ? mapping == Mapping.DEFAULT : AttributeUtil.isString((Class)dataType) && (mapping == Mapping.DEFAULT || mapping == Mapping.STRING || mapping == Mapping.TEXT || mapping == Mapping.TEXTSTRING);
    }

    public String mapKey2Field(String key, KeyInformation information) {
        Preconditions.checkArgument((!StringUtils.containsAny((String)key, (char[])new char[]{' '}) ? 1 : 0) != 0, (String)"Invalid key name provided: %s", (Object[])new Object[]{key});
        return key;
    }

    public IndexFeatures getFeatures() {
        return ES_FEATURES;
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new DefaultTransaction(config);
    }

    public void close() throws BackendException {
        this.client.close();
        if (this.node != null && !this.node.isClosed()) {
            this.node.close();
        }
    }

    public void clearStorage() throws BackendException {
        try {
            try {
                this.client.admin().indices().delete(new DeleteIndexRequest(this.indexName)).actionGet();
                Thread.sleep(1000L);
            }
            catch (IndexMissingException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            throw new PermanentBackendException("Could not delete index " + this.indexName, (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    Node getNode() {
        return this.node;
    }

    private void checkExpectedClientVersion() {
        try {
            if (!Version.CURRENT.toString().equals(ElasticSearchConstants.ES_VERSION_EXPECTED)) {
                log.warn("ES client version ({}) does not match the version with which Titan was compiled ({}).  This might cause problems.", (Object)Version.CURRENT, (Object)ElasticSearchConstants.ES_VERSION_EXPECTED);
            } else {
                log.debug("Found ES client version matching Titan's compile-time version: {} (OK)", (Object)Version.CURRENT);
            }
        }
        catch (RuntimeException e) {
            log.warn("Unable to check expected ES client version", (Throwable)e);
        }
    }
}

