/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablecheckrecyclerview;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.thoughtbot.expandablecheckrecyclerview.ChildCheckController;
import com.thoughtbot.expandablecheckrecyclerview.listeners.OnCheckChildClickListener;
import com.thoughtbot.expandablecheckrecyclerview.listeners.OnChildCheckChangedListener;
import com.thoughtbot.expandablecheckrecyclerview.listeners.OnChildrenCheckStateChangedListener;
import com.thoughtbot.expandablecheckrecyclerview.models.CheckedExpandableGroup;
import com.thoughtbot.expandablecheckrecyclerview.viewholders.CheckableChildViewHolder;
import com.thoughtbot.expandablerecyclerview.ExpandableRecyclerViewAdapter;
import com.thoughtbot.expandablerecyclerview.models.ExpandableGroup;
import com.thoughtbot.expandablerecyclerview.models.ExpandableListPosition;
import com.thoughtbot.expandablerecyclerview.viewholders.GroupViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class CheckableChildRecyclerViewAdapter<GVH extends GroupViewHolder, CCVH extends CheckableChildViewHolder>
extends ExpandableRecyclerViewAdapter<GVH, CCVH>
implements OnChildCheckChangedListener,
OnChildrenCheckStateChangedListener {
    private static final String CHECKED_STATE_MAP = "child_check_controller_checked_state_map";
    private ChildCheckController childCheckController;
    private OnCheckChildClickListener childClickListener;

    public CheckableChildRecyclerViewAdapter(List<? extends CheckedExpandableGroup> groups) {
        super(groups);
        this.childCheckController = new ChildCheckController(this.expandableList, this);
    }

    public CCVH onCreateChildViewHolder(ViewGroup parent, int viewType) {
        CCVH CCVH = this.onCreateCheckChildViewHolder(parent, viewType);
        ((CheckableChildViewHolder)((Object)CCVH)).setOnChildCheckedListener(this);
        return CCVH;
    }

    public void onBindChildViewHolder(CCVH holder, int flatPosition, ExpandableGroup group, int childIndex) {
        ExpandableListPosition listPosition = this.expandableList.getUnflattenedPosition(flatPosition);
        ((CheckableChildViewHolder)((Object)holder)).onBindViewHolder(flatPosition, this.childCheckController.isChildChecked(listPosition));
        this.onBindCheckChildViewHolder(holder, flatPosition, (CheckedExpandableGroup)group, childIndex);
    }

    @Override
    public void onChildCheckChanged(View view, boolean checked, int flatPos) {
        ExpandableListPosition listPos = this.expandableList.getUnflattenedPosition(flatPos);
        this.childCheckController.onChildCheckChanged(checked, listPos);
        if (this.childClickListener != null) {
            this.childClickListener.onCheckChildCLick(view, checked, (CheckedExpandableGroup)this.expandableList.getExpandableGroup(listPos), listPos.childPos);
        }
    }

    @Override
    public void updateChildrenCheckState(int firstChildFlattenedIndex, int numChildren) {
        this.notifyItemRangeChanged(firstChildFlattenedIndex, numChildren);
    }

    public void setChildClickListener(OnCheckChildClickListener listener) {
        this.childClickListener = listener;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelableArrayList(CHECKED_STATE_MAP, (ArrayList)this.expandableList.groups);
        super.onSaveInstanceState(outState);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null || !savedInstanceState.containsKey(CHECKED_STATE_MAP)) {
            return;
        }
        this.expandableList.groups = savedInstanceState.getParcelableArrayList(CHECKED_STATE_MAP);
        super.onRestoreInstanceState(savedInstanceState);
    }

    public void clearChoices() {
        this.childCheckController.clearCheckStates();
        this.notifyDataSetChanged();
    }

    public abstract CCVH onCreateCheckChildViewHolder(ViewGroup var1, int var2);

    public abstract void onBindCheckChildViewHolder(CCVH var1, int var2, CheckedExpandableGroup var3, int var4);
}

