/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablecheckrecyclerview;

import android.widget.ExpandableListView;
import com.thoughtbot.expandablecheckrecyclerview.listeners.OnChildrenCheckStateChangedListener;
import com.thoughtbot.expandablecheckrecyclerview.models.CheckedExpandableGroup;
import com.thoughtbot.expandablerecyclerview.models.ExpandableList;
import com.thoughtbot.expandablerecyclerview.models.ExpandableListPosition;
import java.util.ArrayList;
import java.util.List;

public class ChildCheckController {
    private ExpandableList expandableList;
    private OnChildrenCheckStateChangedListener childrenUpdateListener;
    private List<Integer> initialCheckedPositions;

    public ChildCheckController(ExpandableList expandableList, OnChildrenCheckStateChangedListener listener) {
        this.expandableList = expandableList;
        this.childrenUpdateListener = listener;
        this.initialCheckedPositions = this.getCheckedPositions();
    }

    public void onChildCheckChanged(boolean checked, ExpandableListPosition listPosition) {
        CheckedExpandableGroup group = (CheckedExpandableGroup)((Object)this.expandableList.groups.get(listPosition.groupPos));
        group.onChildClicked(listPosition.childPos, checked);
        if (this.childrenUpdateListener != null) {
            this.childrenUpdateListener.updateChildrenCheckState(this.expandableList.getFlattenedFirstChildIndex(listPosition), this.expandableList.getExpandableGroupItemCount(listPosition));
        }
    }

    public boolean isChildChecked(ExpandableListPosition listPosition) {
        CheckedExpandableGroup group = (CheckedExpandableGroup)((Object)this.expandableList.groups.get(listPosition.groupPos));
        return group.isChildChecked(listPosition.childPos);
    }

    public List<Integer> getCheckedPositions() {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        for (int i = 0; i < this.expandableList.groups.size(); ++i) {
            if (!(this.expandableList.groups.get(i) instanceof CheckedExpandableGroup)) continue;
            CheckedExpandableGroup group = (CheckedExpandableGroup)((Object)this.expandableList.groups.get(i));
            for (int j = 0; j < group.getItemCount(); ++j) {
                if (!group.isChildChecked(j)) continue;
                long packedPosition = ExpandableListView.getPackedPositionForChild((int)i, (int)j);
                selected.add(this.expandableList.getFlattenedChildIndex(packedPosition));
            }
        }
        return selected;
    }

    public boolean checksChanged() {
        return !this.initialCheckedPositions.equals(this.getCheckedPositions());
    }

    public void clearCheckStates() {
        for (int i = 0; i < this.expandableList.groups.size(); ++i) {
            CheckedExpandableGroup group = (CheckedExpandableGroup)((Object)this.expandableList.groups.get(i));
            group.clearSelections();
        }
    }
}

