/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablecheckrecyclerview.models;

import android.os.Parcel;
import android.util.SparseBooleanArray;
import com.thoughtbot.expandablerecyclerview.models.ExpandableGroup;
import java.util.List;

public abstract class CheckedExpandableGroup
extends ExpandableGroup {
    public SparseBooleanArray selectedChildren;

    public CheckedExpandableGroup(String title, List items) {
        super(title, items);
        this.selectedChildren = new SparseBooleanArray();
        for (int i = 0; i < items.size(); ++i) {
            this.selectedChildren.put(i, false);
        }
    }

    void checkChild(int childIndex) {
        this.selectedChildren.put(childIndex, true);
    }

    void unCheckChild(int childIndex) {
        this.selectedChildren.put(childIndex, false);
    }

    public boolean isChildChecked(int childIndex) {
        return this.selectedChildren.get(childIndex);
    }

    public void clearSelections() {
        if (this.selectedChildren != null) {
            this.selectedChildren.clear();
        }
    }

    protected CheckedExpandableGroup(Parcel in) {
        super(in);
        this.selectedChildren = in.readSparseBooleanArray();
    }

    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeSparseBooleanArray(this.selectedChildren);
    }

    public int describeContents() {
        return 0;
    }

    public abstract void onChildClicked(int var1, boolean var2);
}

