/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablecheckrecyclerview.viewholders;

import android.view.View;
import android.widget.Checkable;
import android.widget.CheckedTextView;
import com.thoughtbot.expandablecheckrecyclerview.listeners.OnChildCheckChangedListener;
import com.thoughtbot.expandablerecyclerview.viewholders.ChildViewHolder;

public abstract class CheckableChildViewHolder
extends ChildViewHolder
implements View.OnClickListener {
    private OnChildCheckChangedListener listener;
    private Checkable checkable;

    public CheckableChildViewHolder(View itemView) {
        super(itemView);
        itemView.setOnClickListener((View.OnClickListener)this);
    }

    public void onBindViewHolder(int flatPos, boolean checked) {
        this.checkable = this.getCheckable();
        this.checkable.setChecked(checked);
    }

    public void onClick(View v) {
        if (this.checkable instanceof CheckedTextView) {
            this.checkable.toggle();
        }
        if (this.listener != null) {
            this.listener.onChildCheckChanged(v, this.checkable.isChecked(), this.getAdapterPosition());
        }
    }

    public void setOnChildCheckedListener(OnChildCheckChangedListener listener) {
        this.listener = listener;
    }

    public abstract Checkable getCheckable();
}

