/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablerecyclerview;

import com.thoughtbot.expandablerecyclerview.listeners.ExpandCollapseListener;
import com.thoughtbot.expandablerecyclerview.models.ExpandableGroup;
import com.thoughtbot.expandablerecyclerview.models.ExpandableList;
import com.thoughtbot.expandablerecyclerview.models.ExpandableListPosition;

public class ExpandCollapseController {
    private ExpandCollapseListener listener;
    private ExpandableList expandableList;

    public ExpandCollapseController(ExpandableList expandableList, ExpandCollapseListener listener) {
        this.expandableList = expandableList;
        this.listener = listener;
    }

    private void collapseGroup(ExpandableListPosition listPosition) {
        this.expandableList.expandedGroupIndexes.put(listPosition.groupPos, false);
        if (this.listener != null) {
            this.listener.onGroupCollapsed(this.expandableList.getFlattenedGroupIndex(listPosition) + 1, this.expandableList.groups.get(listPosition.groupPos).getItemCount());
        }
    }

    private void expandGroup(ExpandableListPosition listPosition) {
        this.expandableList.expandedGroupIndexes.put(listPosition.groupPos, true);
        if (this.listener != null) {
            this.listener.onGroupExpanded(this.expandableList.getFlattenedGroupIndex(listPosition) + 1, this.expandableList.groups.get(listPosition.groupPos).getItemCount());
        }
    }

    public boolean isGroupExpanded(ExpandableGroup group) {
        int groupIndex = this.expandableList.groups.indexOf(group);
        return this.expandableList.expandedGroupIndexes.get(groupIndex);
    }

    public boolean isGroupExpanded(int flatPos) {
        ExpandableListPosition listPosition = this.expandableList.getUnflattenedPosition(flatPos);
        return this.expandableList.expandedGroupIndexes.get(listPosition.groupPos);
    }

    public boolean toggleGroup(int flatPos) {
        ExpandableListPosition listPos = this.expandableList.getUnflattenedPosition(flatPos);
        boolean expanded = this.expandableList.expandedGroupIndexes.get(listPos.groupPos);
        if (expanded) {
            this.collapseGroup(listPos);
        } else {
            this.expandGroup(listPos);
        }
        return expanded;
    }
}

