/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablerecyclerview;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.thoughtbot.expandablerecyclerview.ExpandableRecyclerViewAdapter;
import com.thoughtbot.expandablerecyclerview.models.ExpandableGroup;
import com.thoughtbot.expandablerecyclerview.models.ExpandableListPosition;
import com.thoughtbot.expandablerecyclerview.viewholders.ChildViewHolder;
import com.thoughtbot.expandablerecyclerview.viewholders.GroupViewHolder;
import java.util.List;

public abstract class MultiTypeExpandableRecyclerViewAdapter<GVH extends GroupViewHolder, CVH extends ChildViewHolder>
extends ExpandableRecyclerViewAdapter<GVH, CVH> {
    public MultiTypeExpandableRecyclerViewAdapter(List<? extends ExpandableGroup> groups) {
        super(groups);
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.isGroup(viewType)) {
            Object gvh = this.onCreateGroupViewHolder(parent, viewType);
            ((GroupViewHolder)((Object)gvh)).setOnGroupClickListener(this);
            return gvh;
        }
        if (this.isChild(viewType)) {
            Object cvh = this.onCreateChildViewHolder(parent, viewType);
            return cvh;
        }
        throw new IllegalArgumentException("viewType is not valid");
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ExpandableListPosition listPos = this.expandableList.getUnflattenedPosition(position);
        ExpandableGroup group = this.expandableList.getExpandableGroup(listPos);
        if (this.isGroup(this.getItemViewType(position))) {
            this.onBindGroupViewHolder((GroupViewHolder)holder, position, group);
        } else if (this.isChild(this.getItemViewType(position))) {
            this.onBindChildViewHolder((ChildViewHolder)holder, position, group, listPos.childPos);
        }
    }

    @Override
    public int getItemViewType(int position) {
        ExpandableListPosition listPosition = this.expandableList.getUnflattenedPosition(position);
        ExpandableGroup group = this.expandableList.getExpandableGroup(listPosition);
        int viewType = listPosition.type;
        switch (viewType) {
            case 2: {
                return this.getGroupViewType(position, group);
            }
            case 1: {
                return this.getChildViewType(position, group, listPosition.childPos);
            }
        }
        return viewType;
    }

    public int getChildViewType(int position, ExpandableGroup group, int childIndex) {
        return super.getItemViewType(position);
    }

    public int getGroupViewType(int position, ExpandableGroup group) {
        return super.getItemViewType(position);
    }

    public boolean isGroup(int viewType) {
        return viewType == 2;
    }

    public boolean isChild(int viewType) {
        return viewType == 1;
    }
}

