/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtbot.expandablerecyclerview.models;

import android.widget.ExpandableListView;
import java.util.ArrayList;

public class ExpandableListPosition {
    private static final int MAX_POOL_SIZE = 5;
    private static ArrayList<ExpandableListPosition> sPool = new ArrayList(5);
    public static final int CHILD = 1;
    public static final int GROUP = 2;
    public int groupPos;
    public int childPos;
    int flatListPos;
    public int type;

    private void resetState() {
        this.groupPos = 0;
        this.childPos = 0;
        this.flatListPos = 0;
        this.type = 0;
    }

    private ExpandableListPosition() {
    }

    public long getPackedPosition() {
        if (this.type == 1) {
            return ExpandableListView.getPackedPositionForChild((int)this.groupPos, (int)this.childPos);
        }
        return ExpandableListView.getPackedPositionForGroup((int)this.groupPos);
    }

    static ExpandableListPosition obtainGroupPosition(int groupPosition) {
        return ExpandableListPosition.obtain(2, groupPosition, 0, 0);
    }

    static ExpandableListPosition obtainChildPosition(int groupPosition, int childPosition) {
        return ExpandableListPosition.obtain(1, groupPosition, childPosition, 0);
    }

    static ExpandableListPosition obtainPosition(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return null;
        }
        ExpandableListPosition elp = ExpandableListPosition.getRecycledOrCreate();
        elp.groupPos = ExpandableListView.getPackedPositionGroup((long)packedPosition);
        if (ExpandableListView.getPackedPositionType((long)packedPosition) == 1) {
            elp.type = 1;
            elp.childPos = ExpandableListView.getPackedPositionChild((long)packedPosition);
        } else {
            elp.type = 2;
        }
        return elp;
    }

    public static ExpandableListPosition obtain(int type, int groupPos, int childPos, int flatListPos) {
        ExpandableListPosition elp = ExpandableListPosition.getRecycledOrCreate();
        elp.type = type;
        elp.groupPos = groupPos;
        elp.childPos = childPos;
        elp.flatListPos = flatListPos;
        return elp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExpandableListPosition getRecycledOrCreate() {
        ExpandableListPosition elp;
        ArrayList<ExpandableListPosition> arrayList = sPool;
        synchronized (arrayList) {
            if (sPool.size() <= 0) {
                return new ExpandableListPosition();
            }
            elp = sPool.remove(0);
        }
        elp.resetState();
        return elp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        ArrayList<ExpandableListPosition> arrayList = sPool;
        synchronized (arrayList) {
            if (sPool.size() < 5) {
                sPool.add(this);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandableListPosition that = (ExpandableListPosition)o;
        if (this.groupPos != that.groupPos) {
            return false;
        }
        if (this.childPos != that.childPos) {
            return false;
        }
        if (this.flatListPos != that.flatListPos) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.groupPos;
        result = 31 * result + this.childPos;
        result = 31 * result + this.flatListPos;
        result = 31 * result + this.type;
        return result;
    }

    public String toString() {
        return "ExpandableListPosition{groupPos=" + this.groupPos + ", childPos=" + this.childPos + ", flatListPos=" + this.flatListPos + ", type=" + this.type + '}';
    }
}

