/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution.parameters.parsers.types;

import com.google.common.base.Throwables;
import com.thoughtworks.gauge.execution.parameters.ParsingException;
import com.thoughtworks.gauge.execution.parameters.parsers.base.ParameterParser;
import gauge.messages.Spec;

public class EnumParameterParser
implements ParameterParser {
    public static final String ENUM_VALUE_NOT_FOUND_MESSAGE = "%s is not an enum value of %s.";

    @Override
    public boolean canParse(Class<?> parameterType, Spec.Parameter parameter) {
        return parameterType.isEnum();
    }

    @Override
    public Object parse(Class<?> parameterType, Spec.Parameter parameter) throws ParsingException {
        Class<?> enumClass = parameterType;
        String enumValue = parameter.getValue();
        try {
            return this.getEnumInstance(enumClass, enumValue);
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(Spec.ProtoExecutionResult.newBuilder().setFailed(true).setExecutionTime(0L).setStackTrace(Throwables.getStackTraceAsString((Throwable)e)).setErrorMessage(String.format(ENUM_VALUE_NOT_FOUND_MESSAGE, enumValue, enumClass.getSimpleName())).build());
        }
    }

    public <T extends Enum<T>> Enum<T> getEnumInstance(Class<? extends Enum> clazz, String name) {
        return Enum.valueOf(clazz, name);
    }
}

