/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.refactor;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.Util;
import com.thoughtworks.gauge.refactor.JavaRefactoringElement;
import gauge.messages.Messages;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang.StringEscapeUtils;

public class RefactoringMethodVisitor
extends VoidVisitorAdapter {
    private StepValue oldStepValue;
    private StepValue newStepValue;
    private List<Messages.ParameterPosition> paramPositions;
    private boolean refactored;
    private JavaRefactoringElement javaElement;
    private NodeList<Parameter> newParameters = new NodeList();
    private Range stepSpan;

    public RefactoringMethodVisitor(StepValue oldStepValue, StepValue newStepValue, List<Messages.ParameterPosition> paramPositions) {
        this.oldStepValue = oldStepValue;
        this.newStepValue = newStepValue;
        this.paramPositions = paramPositions;
    }

    public void visit(MethodDeclaration methodDeclaration, Object arg) {
        try {
            NodeList annotations = methodDeclaration.getAnnotations();
            if (annotations == null) {
                return;
            }
            for (AnnotationExpr annotationExpr : annotations) {
                StringLiteralExpr memberValue;
                if (!(annotationExpr instanceof SingleMemberAnnotationExpr)) continue;
                SingleMemberAnnotationExpr annotation = (SingleMemberAnnotationExpr)annotationExpr;
                if (annotation.getMemberValue() instanceof BinaryExpr) {
                    ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
                    try {
                        Object result = engine.eval(annotation.getMemberValue().toString());
                        this.refactor(methodDeclaration, new StringLiteralExpr(result.toString()), annotation);
                    }
                    catch (ScriptException e) {
                        continue;
                    }
                }
                if (annotation.getMemberValue() instanceof StringLiteralExpr) {
                    memberValue = (StringLiteralExpr)annotation.getMemberValue();
                    this.refactor(methodDeclaration, memberValue, annotation);
                }
                if (!(annotation.getMemberValue() instanceof ArrayInitializerExpr) || (memberValue = (ArrayInitializerExpr)annotation.getMemberValue()).getValues().size() != 1) continue;
                StringLiteralExpr expression = (StringLiteralExpr)memberValue.getValues().get(0);
                this.refactor(methodDeclaration, expression, annotation);
            }
        }
        catch (Exception e) {
            Logger.error("Exception while refactoring", e);
        }
    }

    private void refactor(MethodDeclaration methodDeclaration, StringLiteralExpr memberValue, SingleMemberAnnotationExpr annotation) {
        if (StringEscapeUtils.unescapeJava((String)memberValue.getValue()).trim().equals(this.oldStepValue.getStepAnnotationText().trim())) {
            IntStream.range(0, this.paramPositions.size()).forEach(i -> this.newParameters.add((Node)new Parameter()));
            memberValue.setValue(StringEscapeUtils.escapeJava((String)this.newStepValue.getStepAnnotationText()));
            NodeList parameters = methodDeclaration.getParameters();
            int paramPositionsSize = this.paramPositions.size();
            for (int i2 = 0; i2 < paramPositionsSize; ++i2) {
                if (this.paramPositions.get(i2).getOldPosition() < 0) {
                    Object paramName = Util.getValidJavaIdentifier(Util.convertToCamelCase("arg " + this.newStepValue.getParameters().get(this.paramPositions.get(i2).getNewPosition())));
                    if (((String)paramName).equals("arg")) {
                        paramName = (String)paramName + i2;
                    }
                    Parameter param = new Parameter((Type)new ClassOrInterfaceType(null, "Object"), new SimpleName((String)paramName));
                    this.newParameters.set(this.paramPositions.get(i2).getNewPosition(), (Node)param);
                    continue;
                }
                this.newParameters.set(this.paramPositions.get(i2).getNewPosition(), (Node)((Parameter)parameters.get(this.paramPositions.get(i2).getOldPosition())));
            }
            for (int k = 0; k < this.newParameters.size(); ++k) {
                for (int l = k + 1; l < this.newParameters.size(); ++l) {
                    if (!((Parameter)this.newParameters.get(k)).getName().equals((Object)((Parameter)this.newParameters.get(l)).getName())) continue;
                    Parameter param = new Parameter((Type)new ClassOrInterfaceType(null, "Object"), new SimpleName(((Parameter)this.newParameters.get(l)).getName().asString() + l));
                    this.newParameters.set(l, (Node)param);
                }
            }
            methodDeclaration.setParameters(this.newParameters);
            annotation.setMemberValue((Expression)memberValue);
            this.javaElement = new JavaRefactoringElement(this.getJavaFileText(methodDeclaration), null);
            Optional range = ((Node)annotation.getChildNodes().get(1)).getRange();
            range.ifPresent(value -> {
                this.stepSpan = value;
            });
            this.refactored = true;
        }
    }

    private String getJavaFileText(MethodDeclaration methodDeclaration) {
        return this.getFileElement((Node)methodDeclaration).toString();
    }

    private Node getFileElement(Node node) {
        if (node instanceof CompilationUnit) {
            return node;
        }
        return node.getParentNode().map(this::getFileElement).orElse(null);
    }

    public boolean refactored() {
        return this.refactored;
    }

    public JavaRefactoringElement getRefactoredJavaElement() {
        return this.javaElement;
    }

    public List<Parameter> getNewParameters() {
        return this.newParameters;
    }

    public Range getStepLineSpan() {
        return this.stepSpan;
    }
}

