/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.thoughtworks.gauge.StepRegistryEntry;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.Util;
import com.thoughtworks.gauge.registry.StepRegistry;
import com.thoughtworks.gauge.scan.StepsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class RegistryMethodVisitor
extends VoidVisitorAdapter {
    private StepValue stepValue;
    private StepRegistryEntry entry;
    private StepRegistry stepRegistry;
    private String file;

    public RegistryMethodVisitor(StepRegistry stepRegistry, String file) {
        this.stepRegistry = stepRegistry;
        this.file = file;
    }

    public void visit(MethodDeclaration methodDeclaration, Object arg) {
        NodeList annotations = methodDeclaration.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        for (AnnotationExpr annotationExpr : annotations) {
            if (!(annotationExpr instanceof SingleMemberAnnotationExpr)) continue;
            SingleMemberAnnotationExpr annotation = (SingleMemberAnnotationExpr)annotationExpr;
            if (annotation.getMemberValue() instanceof ArrayInitializerExpr) {
                ArrayInitializerExpr memberValue = (ArrayInitializerExpr)annotation.getMemberValue();
                for (Expression expression : memberValue.getValues()) {
                    this.addStepToRegistry(expression, methodDeclaration, annotation);
                }
                continue;
            }
            this.addStepToRegistry(annotation.getMemberValue(), methodDeclaration, annotation);
        }
    }

    private void addStepToRegistry(Expression expression, MethodDeclaration methodDeclaration, SingleMemberAnnotationExpr annotation) {
        String parameterizedStep = this.getParameterizedStep(expression);
        String stepText = new StepsUtil().getStepText(parameterizedStep);
        this.stepValue = new StepValue(stepText, parameterizedStep);
        this.entry = new StepRegistryEntry();
        this.entry.setName(methodDeclaration.getDeclarationAsString());
        String className = this.getClassName(methodDeclaration);
        String fullyQualifiedName = className == null ? methodDeclaration.getNameAsString() : className + "." + methodDeclaration.getNameAsString();
        this.entry.setFullyQualifiedName(fullyQualifiedName);
        this.entry.setStepText(parameterizedStep);
        this.entry.setStepValue(this.stepValue);
        this.entry.setParameters((List<Parameter>)methodDeclaration.getParameters());
        this.entry.setSpan((Range)methodDeclaration.getRange().get());
        this.entry.setHasAlias(this.hasAlias(annotation));
        this.entry.setAliases(this.getAliases(annotation));
        this.entry.setFileName(this.file);
        this.stepRegistry.addStep(this.stepValue, this.entry);
    }

    private String getClassName(MethodDeclaration methodDeclaration) {
        String packageNameStr;
        String classNameStr;
        AtomicReference className = new AtomicReference();
        methodDeclaration.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).ifPresent(c -> className.set(c.getNameAsString()));
        String string = classNameStr = className.get() == null ? null : (String)className.get();
        if (classNameStr == null) {
            return null;
        }
        AtomicReference packageName = new AtomicReference();
        methodDeclaration.findCompilationUnit().ifPresent(c -> c.getPackageDeclaration().ifPresent(p -> packageName.set(p.getName())));
        String string2 = packageNameStr = packageName.get() == null ? null : ((Name)packageName.get()).asString();
        if (packageNameStr == null) {
            return classNameStr;
        }
        return packageNameStr + "." + classNameStr;
    }

    private String getParameterizedStep(Expression expression) {
        if (expression instanceof BinaryExpr) {
            return Util.trimQuotes(((BinaryExpr)expression).getLeft().toString()) + Util.trimQuotes(((BinaryExpr)expression).getRight().toString());
        }
        return Util.trimQuotes(expression.toString());
    }

    private Boolean hasAlias(SingleMemberAnnotationExpr annotation) {
        return annotation.getMemberValue() instanceof ArrayInitializerExpr;
    }

    private List<String> getAliases(SingleMemberAnnotationExpr annotation) {
        ArrayList<String> aliases = new ArrayList<String>();
        if (annotation.getMemberValue() instanceof ArrayInitializerExpr) {
            ArrayInitializerExpr memberValue = (ArrayInitializerExpr)annotation.getMemberValue();
            for (Expression expression : memberValue.getValues()) {
                aliases.add(this.getParameterizedStep(expression));
            }
        }
        return aliases;
    }
}

