/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.command;

import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.RunnerServiceHandler;
import com.thoughtworks.gauge.command.GaugeJavaCommand;
import com.thoughtworks.gauge.connection.MessageProcessorFactory;
import com.thoughtworks.gauge.scan.StaticScanner;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class StartCommand
implements GaugeJavaCommand {
    @Override
    public void execute() throws Exception {
        boolean multithreading = Boolean.valueOf(System.getenv("enable_multithreading"));
        Logger.debug("multithreading is set to " + multithreading);
        int numberOfStreams = 1;
        if (multithreading) {
            String streamsCount = System.getenv("GAUGE_PARALLEL_STREAMS_COUNT");
            try {
                numberOfStreams = Integer.valueOf(streamsCount);
                Logger.debug("multithreading enabled, number of threads=" + numberOfStreams);
            }
            catch (NumberFormatException e) {
                Logger.debug("multithreading enabled, but could not read GAUGE_PARALLEL_STREAMS_COUNT as int. Got GAUGE_PARALLEL_STREAMS_COUNT=" + streamsCount);
                Logger.debug("using numberOfStreams=1, err: " + e.getMessage());
            }
        }
        long start = System.currentTimeMillis();
        StaticScanner staticScanner = new StaticScanner();
        staticScanner.addStepsToRegistry();
        MessageProcessorFactory messageProcessorFactory = new MessageProcessorFactory(staticScanner);
        RunnerServiceHandler runnerServiceHandler = new RunnerServiceHandler(messageProcessorFactory, multithreading, numberOfStreams);
        Server server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress("127.0.0.1", 0)).addService((BindableService)runnerServiceHandler)).executor(Runnable::run)).build();
        runnerServiceHandler.addServer(server);
        long elapsed = System.currentTimeMillis() - start;
        Logger.debug("gauge-java took " + elapsed + "milliseconds to load and scan. This should be less than 'runner_connection_timeout' config value.");
        Logger.debug("run 'gauge config runner_connection_timeout' and verify that it is < " + elapsed);
        Logger.debug("starting gRPC server...");
        server.start();
        int port = server.getPort();
        Logger.debug("started gRPC server on port " + port);
        Logger.info("Listening on port:" + port);
        server.awaitTermination();
        Logger.debug("Runner killed gracefully.");
        System.exit(0);
    }
}

