/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.connection;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.google.protobuf.ProtocolStringList;
import com.thoughtworks.gauge.FileHelper;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import gauge.messages.Messages;
import gauge.messages.Spec;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class StubImplementationCodeProcessor
implements IMessageProcessor {
    private static final String NEW_LINE = "\n";
    private static ArrayList<MethodDeclaration> methodDeclarations = new ArrayList();
    private static Range classRange;

    @Override
    public Messages.Message process(Messages.Message message) {
        Messages.FileDiff fileDiff;
        ProtocolStringList stubs = message.getStubImplementationCodeRequest().getCodesList();
        String filePath = message.getStubImplementationCodeRequest().getImplementationFilePath();
        File file = new File(filePath);
        if (file.exists()) {
            fileDiff = this.implementInExistingFile(stubs, file);
        } else {
            File fileName = FileHelper.getDefaultImplFileName("", 0);
            fileDiff = this.implementInNewClass(stubs, fileName);
        }
        return Messages.Message.newBuilder().setMessageId(message.getMessageId()).setFileDiff(fileDiff).setMessageType(Messages.Message.MessageType.StubImplementationCodeRequest).build();
    }

    private Messages.FileDiff implementInExistingFile(ProtocolStringList stubs, File file) {
        try {
            if (new FileReader(file).read() != -1) {
                return this.implementInExistingClass(stubs, file);
            }
            return this.implementInNewClass(stubs, file);
        }
        catch (IOException e) {
            Logger.error("Unable to implement method", e);
            return null;
        }
    }

    private Messages.FileDiff implementInNewClass(ProtocolStringList stubs, File file) {
        String className = FileHelper.getClassName(file);
        String contents = this.getNewClassContents(className, stubs);
        Spec.Span.Builder span = Spec.Span.newBuilder().setStart(0L).setStartChar(0L).setEnd(0L).setEndChar(0L);
        Messages.TextDiff textDiff = Messages.TextDiff.newBuilder().setSpan(span).setContent(contents).build();
        return Messages.FileDiff.newBuilder().setFilePath(file.toString()).addTextDiffs(textDiff).build();
    }

    private String getNewClassContents(String className, ProtocolStringList stubs) {
        return "import com.thoughtworks.gauge.Step;\n\npublic class " + className + " {\n" + String.join((CharSequence)NEW_LINE, (Iterable<? extends CharSequence>)stubs) + "\n}\n";
    }

    private Messages.FileDiff implementInExistingClass(ProtocolStringList stubs, File file) {
        try {
            int column;
            int lastLine;
            JavaParser javaParser = new JavaParser();
            ParseResult compilationUnit = javaParser.parse(file);
            Object contents = String.join((CharSequence)NEW_LINE, (Iterable<? extends CharSequence>)stubs);
            MethodVisitor methodVisitor = new MethodVisitor();
            methodVisitor.visit((CompilationUnit)compilationUnit.getResult().get(), null);
            if (!methodDeclarations.isEmpty()) {
                MethodDeclaration methodDeclaration = methodDeclarations.get(methodDeclarations.size() - 1);
                lastLine = ((Range)methodDeclaration.getRange().get()).end.line - 1;
                column = ((Range)methodDeclaration.getRange().get()).end.column + 1;
                contents = NEW_LINE + (String)contents;
            } else {
                new ClassVisitor().visit((CompilationUnit)compilationUnit.getResult().get(), null);
                lastLine = StubImplementationCodeProcessor.classRange.end.line - 1;
                column = 0;
                contents = (String)contents + NEW_LINE;
            }
            Spec.Span.Builder span = Spec.Span.newBuilder().setStart(lastLine).setStartChar(column).setEnd(lastLine).setEndChar(column);
            Messages.TextDiff textDiff = Messages.TextDiff.newBuilder().setSpan(span).setContent((String)contents).build();
            return Messages.FileDiff.newBuilder().setFilePath(file.toString()).addTextDiffs(textDiff).build();
        }
        catch (IOException e) {
            Logger.error("Unable to implement method", e);
            return null;
        }
    }

    private static final class MethodVisitor
    extends VoidVisitorAdapter {
        private MethodVisitor() {
        }

        public void visit(MethodDeclaration methodDeclaration, Object arg) {
            methodDeclarations.add(methodDeclaration);
        }
    }

    private static final class ClassVisitor
    extends VoidVisitorAdapter {
        private ClassVisitor() {
        }

        public void visit(ClassOrInterfaceDeclaration node, Object arg) {
            classRange = (Range)node.getRange().get();
        }
    }
}

