/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.processor;

import com.thoughtworks.gauge.processor.IMessageProcessor;
import com.thoughtworks.gauge.scan.StaticScanner;
import gauge.messages.Messages;
import java.io.File;
import java.nio.charset.StandardCharsets;

public class CacheFileRequestProcessor
implements IMessageProcessor {
    private StaticScanner staticScanner;

    public CacheFileRequestProcessor(StaticScanner staticScanner) {
        this.staticScanner = staticScanner;
    }

    @Override
    public Messages.Message process(Messages.Message request) {
        String fileName = request.getCacheFileRequest().getFilePath();
        String contents = request.getCacheFileRequest().getContent();
        Messages.CacheFileRequest.FileStatus status = request.getCacheFileRequest().getStatus();
        switch (status) {
            case OPENED: 
            case CHANGED: {
                this.staticScanner.reloadSteps(fileName, contents);
                break;
            }
            case DELETED: {
                this.staticScanner.removeSteps(fileName);
                break;
            }
            case CREATED: {
                if (this.staticScanner.isFileCached(fileName)) break;
                this.loadFromDisk(fileName);
                break;
            }
            case CLOSED: {
                this.loadFromDisk(fileName);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return Messages.Message.newBuilder().build();
    }

    private void loadFromDisk(String fileName) {
        if (new File(fileName).exists()) {
            this.staticScanner.reloadSteps(fileName, this.staticScanner.readFile(fileName, StandardCharsets.UTF_8));
        }
    }
}

