/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.refactor;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.thoughtworks.gauge.Logger;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class JavaParseWorker
extends Thread {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private File javaFile;
    private CompilationUnit compilationUnit;

    JavaParseWorker(File javaFile) {
        this.javaFile = javaFile;
    }

    @Override
    public void run() {
        try {
            Optional result = new JavaParser().parse(this.javaFile).getResult();
            result.ifPresent(value -> {
                this.compilationUnit = value;
            });
        }
        catch (Exception e) {
            Logger.error("Unable to parse file " + this.javaFile.getName());
        }
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    CompilationUnit getCompilationUnit() {
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.compilationUnit;
    }
}

