/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.TableCell;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableRow {
    private final Map<String, String> cells = new LinkedHashMap<String, String>();

    public String getCell(String columnName) {
        if (!this.cells.containsKey(columnName)) {
            return "";
        }
        return this.cells.get(columnName);
    }

    public void addCell(String columnName, String value) {
        this.cells.put(columnName, value);
    }

    public int size() {
        return this.cells.size();
    }

    public String toString() {
        return "TableRow{cells=" + this.cells + "}";
    }

    public List<String> getCellValues() {
        return new ArrayList<String>(this.cells.values());
    }

    public List<TableCell> getTableCells() {
        ArrayList<TableCell> listOfCells = new ArrayList<TableCell>();
        for (Map.Entry<String, String> mapEntry : this.cells.entrySet()) {
            TableCell cell = new TableCell(mapEntry.getKey(), mapEntry.getValue());
            listOfCells.add(cell);
        }
        return listOfCells;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cells.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableRow other = (TableRow)obj;
        return Objects.equals(this.cells, other.cells);
    }
}

