/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static File workingDir() {
        String wd = System.getenv("GAUGE_PROJECT_ROOT");
        if (wd != null && !wd.isEmpty()) {
            return new File(wd);
        }
        return new File(System.getProperty("user.dir"));
    }

    public static String convertToCamelCase(String s) {
        String[] words = s.trim().split(" ");
        Object text = words[0].toLowerCase();
        int wordsLength = words.length;
        for (int i = 1; i < wordsLength; ++i) {
            String word = words[i].trim();
            if (word.isEmpty()) continue;
            text = (String)text + words[i].substring(0, 1).toUpperCase() + words[i].substring(1).toLowerCase();
        }
        return text;
    }

    public static String getValidJavaIdentifier(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) continue;
            builder.append(s.charAt(i));
        }
        return builder.toString();
    }

    public static String trimQuotes(String text) {
        return StringUtils.stripEnd((String)StringUtils.stripStart((String)text, (String)"\""), (String)"\"");
    }

    public static boolean shouldTakeFailureScreenshot() {
        String screenshotOnFailureEnabled = System.getenv("screenshot_on_failure");
        return screenshotOnFailureEnabled != null && !screenshotOnFailureEnabled.equalsIgnoreCase("false");
    }
}

