/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.processor;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.ExecutionContext;
import com.thoughtworks.gauge.execution.HooksExecutor;
import com.thoughtworks.gauge.execution.MethodExecutor;
import com.thoughtworks.gauge.hook.Hook;
import gauge.messages.Messages;
import gauge.messages.Spec;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class MethodExecutionMessageProcessor {
    private final ClassInstanceManager instanceManager;

    public MethodExecutionMessageProcessor(ClassInstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    public Messages.Message execute(Method method, Messages.Message message, Object ... args) {
        HashSet<Method> methods = new HashSet<Method>();
        methods.add(method);
        return this.execute(methods, message, args);
    }

    protected ClassInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    public Messages.Message execute(Set<Method> methods, Messages.Message message, Object ... args) {
        MethodExecutor methodExecutor = new MethodExecutor(this.instanceManager);
        long totalExecutionTime = 0L;
        for (Method method : methods) {
            Spec.ProtoExecutionResult result = methodExecutor.execute(method, args);
            totalExecutionTime += result.getExecutionTime();
            if (!result.getFailed()) continue;
            return this.createMessageWithExecutionStatusResponse(message, result);
        }
        Spec.ProtoExecutionResult passingExecution = Spec.ProtoExecutionResult.newBuilder().setFailed(false).setExecutionTime(totalExecutionTime).build();
        return this.createMessageWithExecutionStatusResponse(message, passingExecution);
    }

    public Messages.Message executeHooks(List<Hook> hooks, Messages.Message message, ExecutionContext executionInfo) {
        Spec.ProtoExecutionResult executionStatusResponse = new HooksExecutor(hooks, executionInfo, this.instanceManager).execute();
        return this.createMessageWithExecutionStatusResponse(message, executionStatusResponse);
    }

    public Messages.Message createMessageWithExecutionStatusResponse(Messages.Message receivedMessage, Spec.ProtoExecutionResult result) {
        return Messages.Message.newBuilder().setMessageId(receivedMessage.getMessageId()).setMessageType(Messages.Message.MessageType.ExecutionStatusResponse).setExecutionStatusResponse(Messages.ExecutionStatusResponse.newBuilder().setExecutionResult(result).build()).build();
    }
}

