/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.hook;

import com.thoughtworks.gauge.Operator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Hook
implements Comparable<Hook> {
    private final Method method;
    private List<String> tags = new ArrayList<String>();
    private Operator operator = Operator.AND;

    public Hook(Method method, String[] tags, Operator operator) {
        this.method = method;
        this.tags = Arrays.asList(tags);
        this.operator = operator;
    }

    public Hook(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Operator getTagsAggregation() {
        return this.operator;
    }

    public boolean isTagged() {
        return !this.tags.isEmpty();
    }

    @Override
    public int compareTo(Hook h) {
        if (this.isTagged() && !h.isTagged()) {
            return 1;
        }
        if (!this.isTagged() && h.isTagged()) {
            return -1;
        }
        return this.getMethod().getName().compareTo(h.getMethod().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hook hook = (Hook)o;
        return this.getMethod() != null ? this.getMethod().equals(hook.getMethod()) : hook.getMethod() == null;
    }

    public int hashCode() {
        return this.getMethod() != null ? this.getMethod().hashCode() : 0;
    }
}

