/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.processor;

import com.thoughtworks.gauge.processor.IMessageProcessor;
import com.thoughtworks.gauge.registry.StepRegistry;
import gauge.messages.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ValidateStepProcessor
implements IMessageProcessor {
    private static Integer num = 1;
    private final StepRegistry registry;

    public ValidateStepProcessor(StepRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Messages.Message process(Messages.Message message) {
        Messages.StepValidateResponse stepValidationResponse = this.validateStep(message.getStepValidateRequest());
        return Messages.Message.newBuilder().setMessageId(message.getMessageId()).setStepValidateResponse(stepValidationResponse).setMessageType(Messages.Message.MessageType.StepValidateResponse).build();
    }

    private Messages.StepValidateResponse validateStep(Messages.StepValidateRequest stepValidateRequest) {
        String stepToValidate = stepValidateRequest.getStepText();
        if (!this.registry.contains(stepToValidate)) {
            StringBuilder suggestion = new StringBuilder(String.format("\n\t@Step(\"%s\")\n", stepValidateRequest.getStepValue().getParameterizedStepValue()));
            String methodName = this.getMethodName(stepValidateRequest.getStepText());
            suggestion.append(String.format("\tpublic void %s(%s){\n\t\t", methodName, this.getParamList((List<String>)stepValidateRequest.getStepValue().getParametersList())));
            suggestion.append("throw new UnsupportedOperationException(\"Provide custom implementation\");\n\t}");
            return this.buildFailureValidationResponse("Step implementation not found", Messages.StepValidateResponse.ErrorType.STEP_IMPLEMENTATION_NOT_FOUND, suggestion.toString());
        }
        if (this.registry.hasMultipleImplementations(stepToValidate)) {
            return this.buildFailureValidationResponse("Duplicate step implementation found", Messages.StepValidateResponse.ErrorType.DUPLICATE_STEP_IMPLEMENTATION, "");
        }
        return this.buildSuccessValidationResponse();
    }

    private String getMethodName(String stepText) {
        StringBuilder methodName = new StringBuilder();
        if (!stepText.equals("")) {
            String[] methodNameArray = stepText.split("\\s+");
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(methodNameArray));
            list.removeAll(Collections.singletonList("{}"));
            int length = list.size();
            if (length == 0) {
                Object[] objectArray = new Object[1];
                Integer n = num;
                num = num + 1;
                objectArray[0] = n.toString();
                methodName.append(String.format("implementation%s", objectArray));
            } else {
                for (int i = 0; i < length; ++i) {
                    String firstLetter = i == 0 ? ((String)list.get(i)).substring(0, 1).toLowerCase() : ((String)list.get(i)).substring(0, 1).toUpperCase();
                    methodName.append(firstLetter);
                    methodName.append(((String)list.get(i)).substring(1).toLowerCase());
                }
            }
            return methodName.toString();
        }
        Object[] objectArray = new Object[1];
        Integer n = num;
        num = num + 1;
        objectArray[0] = n.toString();
        return methodName.append(String.format("implementation%s", objectArray)).toString();
    }

    private String getParamList(List<String> params) {
        StringBuilder paramlistBuilder = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            paramlistBuilder.append("Object arg").append(i);
            if (i == params.size() - 1) continue;
            paramlistBuilder.append(", ");
        }
        return paramlistBuilder.toString();
    }

    private Messages.StepValidateResponse buildFailureValidationResponse(String errorMessage, Messages.StepValidateResponse.ErrorType errorType, String suggestion) {
        return Messages.StepValidateResponse.newBuilder().setIsValid(false).setErrorType(errorType).setErrorMessage(errorMessage).setSuggestion(suggestion).build();
    }

    private Messages.StepValidateResponse buildSuccessValidationResponse() {
        return Messages.StepValidateResponse.newBuilder().setIsValid(true).build();
    }
}

