/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import org.assertj.core.util.Throwables;
import org.json.JSONObject;

public class Logger {
    public static void info(String message) {
        Logger.logToStdout("info", message);
    }

    public static void error(String message) {
        Logger.logToStdErr("error", message);
    }

    public static void error(String message, Throwable t) {
        Logger.error(String.format("%s\n%s\n%s", message, t.getMessage(), Throwables.getStackTrace((Throwable)t)));
    }

    public static void warning(String message) {
        Logger.logToStdout("warning", message);
    }

    public static void warning(String message, Throwable t) {
        Logger.warning(String.format("%s\n%s\n%s", message, t.getMessage(), Throwables.getStackTrace((Throwable)t)));
    }

    public static void debug(String message) {
        Logger.logToStdout("debug", message);
    }

    public static void fatal(String message) {
        Logger.logToStdErr("fatal", message);
        System.exit(1);
    }

    public static void fatal(String message, Throwable t) {
        Logger.fatal(String.format("%s\n%s\n%s", message, t.getMessage(), Throwables.getStackTrace((Throwable)t)));
    }

    private static void logToStdout(String level, String message) {
        System.out.println(Logger.getJsonObject(level, message));
    }

    private static JSONObject getJsonObject(String level, String message) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("logLevel", (Object)level);
        jsonObj.put("message", (Object)message);
        return jsonObj;
    }

    private static void logToStdErr(String level, String message) {
        System.err.println(Logger.getJsonObject(level, message));
    }
}

