/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.registry;

import com.thoughtworks.gauge.AfterClassSteps;
import com.thoughtworks.gauge.AfterScenario;
import com.thoughtworks.gauge.AfterSpec;
import com.thoughtworks.gauge.AfterStep;
import com.thoughtworks.gauge.AfterSuite;
import com.thoughtworks.gauge.BeforeClassSteps;
import com.thoughtworks.gauge.BeforeScenario;
import com.thoughtworks.gauge.BeforeSpec;
import com.thoughtworks.gauge.BeforeStep;
import com.thoughtworks.gauge.BeforeSuite;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.Operator;
import com.thoughtworks.gauge.hook.Hook;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class HooksRegistry {
    private static final String TAGS_METHOD = "tags";
    private static final String TAG_AGGREGATION_METHOD = "tagAggregation";
    private static final Map<Class<?>, HashSet<Hook>> REGISTRY_MAP = new ConcurrentHashMap();

    public static List<Hook> getBeforeSpecHooks() {
        return HooksRegistry.sort((Set<Hook>)REGISTRY_MAP.get(BeforeSpec.class));
    }

    public static void addBeforeSpecHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, BeforeSpec.class);
    }

    public static List<Hook> getAfterSpecHooks() {
        return HooksRegistry.sortReverse((Set<Hook>)REGISTRY_MAP.get(AfterSpec.class));
    }

    public static void addAfterSpecHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, AfterSpec.class);
    }

    public static List<Hook> getBeforeScenarioHooks() {
        return HooksRegistry.sort((Set<Hook>)REGISTRY_MAP.get(BeforeScenario.class));
    }

    private static List<Hook> sort(Set<Hook> hooks) {
        return hooks.stream().sorted().collect(Collectors.toList());
    }

    private static List<Hook> sortReverse(Set<Hook> hooks) {
        return hooks.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    public static void addBeforeScenarioHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, BeforeScenario.class);
    }

    public static List<Hook> getAfterScenarioHooks() {
        return HooksRegistry.sortReverse((Set<Hook>)REGISTRY_MAP.get(AfterScenario.class));
    }

    public static void addAfterScenarioHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, AfterScenario.class);
    }

    public static List<Hook> getBeforeStepHooks() {
        return HooksRegistry.sort((Set<Hook>)REGISTRY_MAP.get(BeforeStep.class));
    }

    public static void addBeforeStepHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, BeforeStep.class);
    }

    public static List<Hook> getAfterStepHooks() {
        return HooksRegistry.sortReverse((Set<Hook>)REGISTRY_MAP.get(AfterStep.class));
    }

    public static void setAfterStepHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, AfterStep.class);
    }

    public static List<Hook> getBeforeSuiteHooks() {
        return HooksRegistry.sort((Set<Hook>)REGISTRY_MAP.get(BeforeSuite.class));
    }

    public static void addBeforeSuiteHooks(Set<Method> methods) {
        HooksRegistry.addHooks(methods, BeforeSuite.class);
    }

    public static List<Hook> getAfterSuiteHooks() {
        return HooksRegistry.sortReverse((Set<Hook>)REGISTRY_MAP.get(AfterSuite.class));
    }

    public static void addAfterSuiteHooks(Set<Method> methods) {
        HooksRegistry.addHooks(methods, AfterSuite.class);
    }

    public static void addAfterClassStepsHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, AfterClassSteps.class);
    }

    public static void addBeforeClassStepsHooks(Set<Method> methods) {
        HooksRegistry.addHooksWithTags(methods, BeforeClassSteps.class);
    }

    public static List<Hook> getBeforeClassStepsHooksOfClass(Class<?> aClass) {
        return HooksRegistry.sort(HooksRegistry.findClassHooksForClass(HooksRegistry.getBeforeClassHooks(), aClass));
    }

    public static List<Hook> getAfterClassStepsHooksOfClass(Class<?> aClass) {
        return HooksRegistry.sortReverse(HooksRegistry.findClassHooksForClass(HooksRegistry.getAfterClassHooks(), aClass));
    }

    private static Set<Hook> findClassHooksForClass(List<Hook> allClassHooks, Class<?> aClass) {
        return allClassHooks.stream().filter(hook -> hook.getMethod().getDeclaringClass().equals(aClass)).collect(Collectors.toSet());
    }

    private static void addHooks(Set<Method> methods, Class hookClass) {
        REGISTRY_MAP.putIfAbsent(hookClass, new HashSet());
        REGISTRY_MAP.get(hookClass).addAll(methods.stream().map(Hook::new).collect(Collectors.toList()));
    }

    private static void addHooksWithTags(Set<Method> methods, Class hookClass) {
        REGISTRY_MAP.putIfAbsent(hookClass, new HashSet());
        for (Method method : methods) {
            Object annotation = method.getAnnotation(hookClass);
            try {
                String[] tags = (String[])annotation.getClass().getMethod(TAGS_METHOD, new Class[0]).invoke(annotation, new Object[0]);
                Operator tagsAggregation = (Operator)((Object)annotation.getClass().getMethod(TAG_AGGREGATION_METHOD, new Class[0]).invoke(annotation, new Object[0]));
                REGISTRY_MAP.get(hookClass).add(new Hook(method, tags, tagsAggregation));
            }
            catch (Exception e) {
                Logger.warning("Unable to add hooks", e);
            }
        }
    }

    private static List<Hook> getBeforeClassHooks() {
        return HooksRegistry.sort((Set<Hook>)REGISTRY_MAP.get(BeforeClassSteps.class));
    }

    private static List<Hook> getAfterClassHooks() {
        return HooksRegistry.sortReverse((Set<Hook>)REGISTRY_MAP.get(AfterClassSteps.class));
    }

    static void remove(Class hookType) {
        REGISTRY_MAP.remove(hookType);
    }
}

