/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.FileHelper;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.connection.MessageProcessorFactory;
import com.thoughtworks.gauge.execution.ExecutorPool;
import com.thoughtworks.gauge.processor.IMessageProcessor;
import gauge.messages.Messages;
import gauge.messages.RunnerGrpc;
import io.grpc.Server;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.stream.Collectors;

public class RunnerServiceHandler
extends RunnerGrpc.RunnerImplBase {
    private final MessageProcessorFactory messageProcessorFactory;
    private final boolean multithreading;
    private Server server;
    private final ExecutorPool pool;

    public RunnerServiceHandler(MessageProcessorFactory messageProcessorFactory, boolean multithreading, int poolSize) {
        this.messageProcessorFactory = messageProcessorFactory;
        this.multithreading = multithreading;
        this.pool = new ExecutorPool(poolSize);
    }

    public void addServer(Server lspServer) {
        this.server = lspServer;
    }

    @Override
    public void initializeSuiteDataStore(Messages.SuiteDataStoreInitRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            int stream = this.getStream(request.getStream());
            this.pool.execute(stream, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.SuiteDataStoreInit);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setMessageType(Messages.Message.MessageType.SuiteDataStoreInit);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.SuiteDataStoreInit, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void startExecution(Messages.ExecutionStartingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.ExecutionStarting);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setExecutionStartingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ExecutionStarting, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void initializeSpecDataStore(Messages.SpecDataStoreInitRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.SpecDataStoreInit);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setMessageType(Messages.Message.MessageType.SpecDataStoreInit);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.SpecDataStoreInit, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void startSpecExecution(Messages.SpecExecutionStartingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.SpecExecutionStarting);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setSpecExecutionStartingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.SpecExecutionStarting, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void initializeScenarioDataStore(Messages.ScenarioDataStoreInitRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.ScenarioDataStoreInit);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setMessageType(Messages.Message.MessageType.ScenarioDataStoreInit);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ScenarioDataStoreInit, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void startScenarioExecution(Messages.ScenarioExecutionStartingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.ScenarioExecutionStarting);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setScenarioExecutionStartingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ScenarioExecutionStarting, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void startStepExecution(Messages.StepExecutionStartingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.StepExecutionStarting);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setStepExecutionStartingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.StepExecutionEnding, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void executeStep(Messages.ExecuteStepRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.ExecuteStep);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setExecuteStepRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ExecuteStep, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void finishStepExecution(Messages.StepExecutionEndingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.StepExecutionEnding);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setStepExecutionEndingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.StepExecutionEnding, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void finishScenarioExecution(Messages.ScenarioExecutionEndingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.ScenarioExecutionEnding);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setScenarioExecutionEndingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ScenarioExecutionEnding, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void finishSpecExecution(Messages.SpecExecutionEndingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.SpecExecutionEnding);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setSpecExecutionEndingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.SpecExecutionEnding, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void finishExecution(Messages.ExecutionEndingRequest request, StreamObserver<Messages.ExecutionStatusResponse> responseObserver) {
        try {
            this.pool.execute(this.getStream(request.getStream()), () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.ExecutionEnding);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setExecutionEndingRequest(request);
                Messages.Message message = processor.process(builder.build());
                responseObserver.onNext((Object)message.getExecutionStatusResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ExecutionEnding, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void getStepNames(Messages.StepNamesRequest request, StreamObserver<Messages.StepNamesResponse> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.StepNamesRequest);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setStepNamesRequest(request);
                Messages.Message process = processor.process(builder.build());
                responseObserver.onNext((Object)process.getStepNamesResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.StepNameRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void cacheFile(Messages.CacheFileRequest request, StreamObserver<Messages.Empty> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.CacheFileRequest);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setCacheFileRequest(request);
                processor.process(builder.build());
                responseObserver.onNext((Object)Messages.Empty.newBuilder().build());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.CacheFileRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void getStepPositions(Messages.StepPositionsRequest request, StreamObserver<Messages.StepPositionsResponse> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.StepPositionsRequest);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setStepPositionsRequest(request);
                Messages.Message process = processor.process(builder.build());
                responseObserver.onNext((Object)process.getStepPositionsResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.StepPositionsRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void getImplementationFiles(Messages.Empty request, StreamObserver<Messages.ImplementationFileListResponse> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                List<String> allImplFiles = FileHelper.getAllImplementationFiles();
                responseObserver.onNext((Object)Messages.ImplementationFileListResponse.newBuilder().addAllImplementationFilePaths(allImplFiles).build());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ImplementationFileListRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void implementStub(Messages.StubImplementationCodeRequest request, StreamObserver<Messages.FileDiff> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.StubImplementationCodeRequest);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setStubImplementationCodeRequest(request);
                Messages.Message process = processor.process(builder.build());
                responseObserver.onNext((Object)process.getFileDiff());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.StubImplementationCodeRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void validateStep(Messages.StepValidateRequest request, StreamObserver<Messages.StepValidateResponse> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.StepValidateRequest);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setStepValidateRequest(request);
                Messages.Message process = processor.process(builder.build());
                responseObserver.onNext((Object)process.getStepValidateResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.StepValidateRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void refactor(Messages.RefactorRequest request, StreamObserver<Messages.RefactorResponse> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.RefactorRequest);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setRefactorRequest(request);
                Messages.Message process = processor.process(builder.build());
                responseObserver.onNext((Object)process.getRefactorResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.RefactorRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void getStepName(Messages.StepNameRequest request, StreamObserver<Messages.StepNameResponse> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                IMessageProcessor processor = this.messageProcessorFactory.getProcessor(Messages.Message.MessageType.StepNameRequest);
                Messages.Message.Builder builder = Messages.Message.newBuilder();
                builder.setStepNameRequest(request);
                Messages.Message process = processor.process(builder.build());
                responseObserver.onNext((Object)process.getStepNameResponse());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.StepNameRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void getGlobPatterns(Messages.Empty request, StreamObserver<Messages.ImplementationFileGlobPatternResponse> responseObserver) {
        try {
            this.pool.execute(1, () -> {
                List<String> patterns = FileHelper.getStepImplDirs().stream().map(dir -> dir + "/**/*.java").collect(Collectors.toList());
                responseObserver.onNext((Object)Messages.ImplementationFileGlobPatternResponse.newBuilder().addAllGlobPatterns(patterns).build());
                responseObserver.onCompleted();
            });
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.ImplementationFileGlobPatternRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    @Override
    public void kill(Messages.KillProcessRequest request, StreamObserver<Messages.Empty> responseObserver) {
        try {
            Logger.debug("Killing Java runner...");
            responseObserver.onNext((Object)Messages.Empty.newBuilder().build());
            responseObserver.onCompleted();
            Logger.debug("Stopping execution pool...");
            this.pool.stopAfterCompletion();
            Logger.debug("Shutting down grpc server...");
            this.server.shutdownNow();
        }
        catch (Throwable e) {
            Logger.error(String.format("Failed to process %s.\nReason: %s", new Object[]{Messages.Message.MessageType.KillProcessRequest, e.toString()}));
            responseObserver.onError(e);
        }
    }

    private int getStream(int stream) {
        if (!this.multithreading) {
            return 1;
        }
        return Math.max(stream, 1);
    }
}

