/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution.parameters.parsers.base;

import com.thoughtworks.gauge.ClasspathHelper;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.execution.parameters.ParsingException;
import com.thoughtworks.gauge.execution.parameters.parsers.base.CustomParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.base.ParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.converters.TableConverter;
import com.thoughtworks.gauge.execution.parameters.parsers.types.EnumParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.types.PrimitiveParameterParser;
import com.thoughtworks.gauge.execution.parameters.parsers.types.PrimitivesConverter;
import com.thoughtworks.gauge.execution.parameters.parsers.types.TableParameterParser;
import gauge.messages.Spec;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ParameterParsingChain
implements ParameterParser {
    private final List<ParameterParser> chain = new LinkedList<ParameterParser>();

    public ParameterParsingChain() {
        this.createReflections().getSubTypesOf(CustomParameterParser.class).stream().map(this::asCustomParameterParser).filter(Objects::nonNull).forEach(this.chain::add);
        this.chain.add(new TableParameterParser(new TableConverter()));
        this.chain.add(new EnumParameterParser());
        this.chain.add(new PrimitiveParameterParser(new PrimitivesConverter()));
    }

    private Reflections createReflections() {
        ConfigurationBuilder config = new ConfigurationBuilder().setScanners(new Scanner[]{Scanners.SubTypes}).addUrls(ClasspathHelper.getUrls()).filterInputsBy((Predicate)new FilterBuilder().includePattern(".+\\.class"));
        return new Reflections((Configuration)config);
    }

    @Nullable
    private ParameterParser asCustomParameterParser(Class<? extends ParameterParser> clazz) {
        try {
            ParameterParser instance = clazz.newInstance();
            Logger.debug(String.format("Adding %s as custom parameter parser", clazz.getName()));
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logger.error(String.format("Cannot add %s as custom parameter parser", clazz.getName()), e);
            return null;
        }
    }

    @Override
    public boolean canParse(Class<?> parameterType, Spec.Parameter parameter) {
        return true;
    }

    @Override
    public Object parse(Class<?> parameterType, Spec.Parameter parameter) throws ParsingException {
        for (ParameterParser parser : this.chain) {
            if (!parser.canParse(parameterType, parameter)) continue;
            return parser.parse(parameterType, parameter);
        }
        return parameter.getValue();
    }
}

