/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.thoughtworks.gauge.FileHelper;
import com.thoughtworks.gauge.Logger;
import com.thoughtworks.gauge.registry.StepRegistry;
import com.thoughtworks.gauge.scan.RegistryMethodVisitor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StaticScanner {
    private final StepRegistry stepRegistry = new StepRegistry();

    public StepRegistry getRegistry() {
        return this.stepRegistry;
    }

    public void reloadSteps(String fileName, String contents) {
        this.removeSteps(fileName);
        this.addStepsFromFileContents(fileName, contents);
    }

    public void addStepsFromFileContents(String file, String contents) {
        StringReader reader = new StringReader(contents);
        ParseResult result = new JavaParser().parse((Reader)reader);
        boolean shouldScan = result.getResult().map(this::shouldScan).orElse(false);
        if (!shouldScan) {
            return;
        }
        RegistryMethodVisitor methodVisitor = new RegistryMethodVisitor(this.stepRegistry, file);
        methodVisitor.visit((CompilationUnit)result.getResult().get(), null);
    }

    private boolean shouldScan(CompilationUnit unit) {
        String packagesToScan = System.getenv("package_to_scan");
        if (packagesToScan == null || packagesToScan.isEmpty() || unit.getPackageDeclaration().isEmpty()) {
            return true;
        }
        List packages = Arrays.stream(packagesToScan.split(",")).map(String::trim).collect(Collectors.toList());
        return unit.getPackageDeclaration().map(p -> packages.contains(p.getName().asString())).orElse(false);
    }

    public void addStepsToRegistry() {
        List<String> files = FileHelper.getAllImplementationFiles();
        for (String file : files) {
            String contents = this.readFile(file, StandardCharsets.UTF_8);
            this.addStepsFromFileContents(file, contents);
        }
    }

    public void removeSteps(String fileName) {
        this.stepRegistry.removeSteps(fileName);
    }

    public boolean isFileCached(String fileName) {
        return this.stepRegistry.isFileCached(fileName);
    }

    public String readFile(String path, Charset encoding) {
        try {
            byte[] contents = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(contents, encoding);
        }
        catch (IOException e) {
            Logger.error("Unable to read file", e);
            return null;
        }
    }
}

