// Copyright 2015 ThoughtWorks, Inc.

// This file is part of Gauge-Java.

// This program is free software.
//
// It is dual-licensed under:
// 1) the GNU General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version;
// or
// 2) the Eclipse Public License v1.0.
//
// You can redistribute it and/or modify it under the terms of either license.
// We would then provide copied of each license in a separate .txt file with the name of the license as the title of the file.

package com.thoughtworks.gauge.datastore;

public class DataStoreFactory {
    private static ThreadLocal<DataStore> suiteDataStore = new InheritableThreadLocal<DataStore>() {
        @Override
        protected DataStore initialValue() {
            return new DataStore();
        }
    };
    private static ThreadLocal<DataStore> specDataStore = new InheritableThreadLocal<DataStore>() {
        @Override
        protected DataStore initialValue() {
            return new DataStore();
        }
    };
    private static ThreadLocal<DataStore> scenarioDataStore = new InheritableThreadLocal<DataStore>() {
        @Override
        protected DataStore initialValue() {
            return new DataStore();
        }
    };


    /**
     * @return The current instance of the SuiteDataStore
     */
    public static DataStore getSuiteDataStore() {
        return suiteDataStore.get();
    }

    /**
     * @return The current instance of the SpecDataStore
     */
    public static DataStore getSpecDataStore() {
        return specDataStore.get();
    }

    /**
     * @return The current instance of the ScenarioDataStore
     */
    public static DataStore getScenarioDataStore() {
        return scenarioDataStore.get();
    }

}
