// Copyright 2015 ThoughtWorks, Inc.

// This file is part of Gauge-Java.

// This program is free software.
//
// It is dual-licensed under:
// 1) the GNU General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version;
// or
// 2) the Eclipse Public License v1.0.
//
// You can redistribute it and/or modify it under the terms of either license.
// We would then provide copied of each license in a separate .txt file with the name of the license as the title of the file.

package com.thoughtworks.gauge.tag;

import com.thoughtworks.gauge.Operator;

import java.util.List;

public class TagMatcher {
    public boolean isMatch(List<String> tags, Operator operator, List<String> allTags) {
        return new TagMatcherFactory().matcherFor(operator).isMatch(tags, allTags);
    }

    private class TagMatcherFactory {
        public SimpleTagMatcher matcherFor(Operator operator) {
            switch (operator) {
                case OR:
                    return new OrMatcher();
                case AND:
                    return new AndMatcher();
                default:
                    return new AndMatcher();
            }
        }
    }
}
