/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.connection.GaugeConnector;
import com.thoughtworks.gauge.connection.MessageDispatcher;
import com.thoughtworks.gauge.execution.parameters.parsers.base.ParameterParsingChain;
import com.thoughtworks.gauge.registry.StepRegistry;
import com.thoughtworks.gauge.scan.ClasspathScanner;
import com.thoughtworks.gauge.scan.CustomClassInitializerScanner;
import com.thoughtworks.gauge.scan.HooksScanner;
import com.thoughtworks.gauge.scan.StepsScanner;
import com.thoughtworks.gauge.screenshot.CustomScreenshotScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GaugeRuntime {
    private static List<Thread> threads = new ArrayList<Thread>();

    public static void main(String[] args) throws Exception {
        int apiPort = GaugeRuntime.readEnvVar("GAUGE_API_PORT");
        String portInfo = System.getenv("GAUGE_API_PORTS");
        StepRegistry stepRegistry = new StepRegistry();
        if (portInfo != null && !portInfo.trim().isEmpty()) {
            List<String> ports = Arrays.asList(portInfo.split(","));
            int portsSize = ports.size();
            for (int i = 0; i < portsSize; ++i) {
                if (i == 0) {
                    GaugeRuntime.connectSynchronously(Integer.parseInt(ports.get(i)), apiPort, stepRegistry);
                    continue;
                }
                GaugeRuntime.connectInParallel(Integer.parseInt(ports.get(i)), apiPort, stepRegistry);
            }
        } else {
            GaugeRuntime.connectSynchronously(GaugeRuntime.readEnvVar("GAUGE_INTERNAL_PORT"), apiPort, stepRegistry);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        System.exit(0);
    }

    private static int readEnvVar(String env) {
        String port = System.getenv(env);
        if (port == null || port.equalsIgnoreCase("")) {
            throw new RuntimeException(env + " not set");
        }
        return Integer.parseInt(port);
    }

    private static void connectInParallel(int gaugeInternalPort, int gaugeApiPort, StepRegistry stepRegistry) {
        Thread thread = new Thread(() -> GaugeRuntime.dispatchMessages(GaugeRuntime.makeConnection(gaugeInternalPort, gaugeApiPort), stepRegistry));
        GaugeRuntime.startThread(thread);
    }

    private static void connectSynchronously(int gaugeInternalPort, int gaugeApiPort, StepRegistry stepRegistry) {
        GaugeConnector connector = GaugeRuntime.makeConnection(gaugeInternalPort, gaugeApiPort);
        new ClasspathScanner().scan(new StepsScanner(connector, stepRegistry), new HooksScanner(), new CustomScreenshotScanner(), new CustomClassInitializerScanner());
        Thread thread = new Thread(() -> GaugeRuntime.dispatchMessages(connector, stepRegistry));
        GaugeRuntime.startThread(thread);
    }

    private static void startThread(Thread thread) {
        threads.add(thread);
        thread.start();
    }

    private static GaugeConnector makeConnection(int gaugeInternalPort, int gaugeApiPort) {
        GaugeConnector connector = new GaugeConnector();
        connector.makeConnectionsToGaugeCore(gaugeInternalPort, gaugeApiPort);
        return connector;
    }

    private static void dispatchMessages(GaugeConnector connector, StepRegistry stepRegistry) {
        try {
            new MessageDispatcher(new ParameterParsingChain(), stepRegistry).dispatchMessages(connector);
        }
        catch (IOException e) {
            Thread t = Thread.currentThread();
            t.getUncaughtExceptionHandler().uncaughtException(t, e);
        }
    }
}

